/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.ConnectedServerDTO;
import de.virtimo.bpc.opensearch.plugin.dto.LoadedModuleDTO;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class ConnectedServersDTO
implements OpenSearchPluginDTO,
Iterable<ConnectedServerDTO> {
    private final List<ConnectedServerDTO> servers = new ArrayList<ConnectedServerDTO>();

    private ConnectedServersDTO() {
    }

    public ConnectedServersDTO(List<ConnectedServerDTO> servers) {
        this();
        if (servers != null) {
            this.servers.addAll(servers);
        }
    }

    public ConnectedServersDTO(Map<String, Object> connectedServersData) {
        this();
        this.servers.addAll(MapUtil.getArrayValueAsListOfObjects(connectedServersData, (String)"servers", ConnectedServerDTO.class));
    }

    public ConnectedServersDTO(StreamInput in) throws IOException {
        this();
        this.servers.addAll(in.readList(ConnectedServerDTO::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.servers);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("servers");
        for (ConnectedServerDTO server : this.servers) {
            server.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public boolean isEmpty() {
        return this.servers.isEmpty();
    }

    public int size() {
        return this.servers.size();
    }

    public ConnectedServerDTO get(int index) {
        return this.servers.get(index);
    }

    public List<ConnectedServerDTO> getServers() {
        return new ArrayList<ConnectedServerDTO>(this.servers);
    }

    public boolean isConnectedTo(String nodeName, String serverUUID) {
        if (nodeName != null && serverUUID != null) {
            for (ConnectedServerDTO server : this.servers) {
                if (!nodeName.equals(server.getNodeName()) || server.getServerStateInfo() == null || !serverUUID.equals(server.getServerStateInfo().getServerUUID())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConnectedServerUUID(String serverUUID) {
        return serverUUID != null && this.getConnectedServerByUUID(serverUUID) != null;
    }

    public ConnectedServerDTO getConnectedServerByUUID(String serverUUID) {
        for (ConnectedServerDTO server : this.servers) {
            if (server.getServerStateInfo() == null || !serverUUID.equals(server.getServerStateInfo().getServerUUID())) continue;
            return server;
        }
        return null;
    }

    public List<String> getUUIDs() {
        ArrayList<String> result = new ArrayList<String>();
        for (ConnectedServerDTO server : this.servers) {
            String serverUUID = server.getServerStateInfo() != null ? server.getServerStateInfo().getServerUUID() : null;
            if (serverUUID == null) continue;
            result.add(serverUUID);
        }
        return result;
    }

    public boolean isSameModuleVersionUsedOnAllServers(String idOfLoadedModule) {
        if (StringUtil.isNullOrEmpty((String)idOfLoadedModule)) {
            return false;
        }
        String moduleVersionToDoTheCheckFor = null;
        for (ConnectedServerDTO connectedServer : this.servers) {
            LoadedModuleDTO loadedModule = connectedServer.getLoadedModules().getLoadedModule(idOfLoadedModule);
            if (loadedModule == null) {
                return false;
            }
            if (moduleVersionToDoTheCheckFor == null) {
                moduleVersionToDoTheCheckFor = loadedModule.getVersion();
            }
            if (moduleVersionToDoTheCheckFor.equals(loadedModule.getVersion())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<ConnectedServerDTO> iterator() {
        return this.servers.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectedServersDTO that = (ConnectedServersDTO)o;
        return Objects.equals(this.servers, that.servers);
    }

    public int hashCode() {
        return Objects.hash(this.servers);
    }

    public String toString() {
        return "ConnectedServersDTO{servers=" + this.servers + "}";
    }
}

