/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.forms;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.Error;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.module.forms.Form;
import de.virtimo.bpc.module.forms.FormValidator;
import de.virtimo.bpc.module.forms.InvalidFormConfigException;
import de.virtimo.bpc.module.forms.Manager;
import de.virtimo.bpc.module.forms.NoFormFoundException;
import de.virtimo.bpc.module.forms.PersistenceLayerException;
import de.virtimo.bpc.module.forms.SimpleForm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.aggregations.metrics.TopHits;
import org.opensearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;

public class OpenSearchManagerImpl
implements Manager {
    private static final Logger LOG = Logger.getLogger(OpenSearchManagerImpl.class.getName());
    static final String FORMS_INDEX = "bpc-forms";
    static final String FORM_ID_FIELD = "id";
    static final String FORM_VERSION_FIELD = "version";
    static final int LATEST_VERSION = -1;
    private final OpenSearchService openSearchService;
    private final FormValidator formValidator;
    private static final ObjectMapper mapper = new ObjectMapper();

    public OpenSearchManagerImpl(OpenSearchService openSearchService) {
        this(openSearchService, new FormValidator());
    }

    public OpenSearchManagerImpl(OpenSearchService openSearchService, FormValidator formValidator) {
        this.openSearchService = openSearchService;
        this.formValidator = formValidator;
    }

    @Override
    public Form getForm(String formId) throws NoFormFoundException, PersistenceLayerException {
        return this.getForm(formId, -1);
    }

    @Override
    public Form getForm(String formId, int version) throws NoFormFoundException, PersistenceLayerException {
        if (version <= 0) {
            version = this.getLastFormVersion(formId);
        }
        GetRequest getRequest = new GetRequest(FORMS_INDEX, this.getOpenSearchFormId(formId, version));
        try {
            GetResponse getResponse = this.openSearchService.get(getRequest, RequestOptions.DEFAULT);
            if (!getResponse.isExists()) {
                throw new NoFormFoundException(formId, version);
            }
            return OpenSearchManagerImpl.getFormFromMap(OpenSearchManagerImpl.getOrderedMapFromGetResponse(getResponse));
        }
        catch (OpenSearchIndexNotFoundException ex) {
            throw new PersistenceLayerException(ex);
        }
        catch (OpenSearchRelatedException ex) {
            throw new PersistenceLayerException(ex);
        }
    }

    @Override
    public Set<Form> getForms() throws PersistenceLayerException {
        LOG.finest("getForms");
        try {
            SearchRequest searchRequest = this.getFormsSearchLatestVersion(null);
            return this.getFormsFromSearchRequest(searchRequest);
        }
        catch (OpenSearchIndexNotFoundException ex) {
            throw new PersistenceLayerException(ex);
        }
        catch (OpenSearchRelatedException ex) {
            throw new PersistenceLayerException(ex);
        }
    }

    @Override
    public Set<Form> getFormHistory(String formID) throws NoFormFoundException, PersistenceLayerException {
        LOG.finest("getFormHistory");
        try {
            SearchRequest searchRequest = this.getFormsSearch((QueryBuilder)QueryBuilders.termQuery((String)FORM_ID_FIELD, (String)formID));
            Set<Form> foundForms = this.getFormsFromSearchRequest(searchRequest);
            if (foundForms.isEmpty()) {
                throw new NoFormFoundException(formID);
            }
            return foundForms;
        }
        catch (OpenSearchIndexNotFoundException ex) {
            throw new PersistenceLayerException(ex);
        }
        catch (OpenSearchRelatedException ex) {
            throw new PersistenceLayerException(ex);
        }
    }

    @Override
    public Form addForm(String formId, String formName, Map<String, Object> formConfig) throws InvalidFormConfigException, PersistenceLayerException {
        return this.addForm(formId, formName, formConfig, true);
    }

    public Form addForm(String formId, String formName, Map<String, Object> formConfig, boolean waitUntilVisible) throws InvalidFormConfigException, PersistenceLayerException {
        LOG.finest("addForm formId=" + formId + ", formName=" + formName + ", formConfig=..., waitUntilVisible=" + waitUntilVisible);
        try {
            int nextVersion = this.getNextFormVersion(formId);
            SimpleForm form = new SimpleForm(formId, nextVersion, formName, formConfig);
            List<Error> validationErrors = this.formValidator.validate(form);
            if (!validationErrors.isEmpty()) {
                InvalidFormConfigException invalidFormConfigException = new InvalidFormConfigException(validationErrors);
                LOG.warning("addForm canceled. formConfig Validation failed:\n" + invalidFormConfigException.getMessage());
                throw invalidFormConfigException;
            }
            IndexRequest indexRequest = new IndexRequest(FORMS_INDEX).id(this.getOpenSearchFormId(form)).source(OpenSearchManagerImpl.getMapFromForm(form));
            if (waitUntilVisible) {
                indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
            }
            LOG.finest("addForm Request: " + indexRequest.toString());
            this.openSearchService.index(indexRequest, RequestOptions.DEFAULT);
            return form;
        }
        catch (OpenSearchIndexNotFoundException ex) {
            throw new PersistenceLayerException(ex);
        }
        catch (OpenSearchRelatedException ex) {
            throw new PersistenceLayerException(ex);
        }
    }

    static Map<String, Object> getOrderedMapFromSearchHit(SearchHit hit) {
        return (Map)XContentHelper.convertToMap((BytesReference)hit.getSourceRef(), (boolean)true, (MediaType)MediaType.fromMediaType((String)XContentType.JSON.mediaType())).v2();
    }

    static Map<String, Object> getOrderedMapFromGetResponse(GetResponse getResponse) {
        return (Map)XContentHelper.convertToMap((BytesReference)getResponse.getSourceAsBytesRef(), (boolean)true, (MediaType)MediaType.fromMediaType((String)XContentType.JSON.mediaType())).v2();
    }

    static Form getFormFromMap(Map<String, Object> formMap) {
        return (Form)mapper.convertValue(formMap, SimpleForm.class);
    }

    static Map<String, Object> getMapFromForm(Form form) {
        return (Map)mapper.convertValue((Object)form, Map.class);
    }

    private String getOpenSearchFormId(Form form) {
        return this.getOpenSearchFormId(form.getId(), form.getVersion());
    }

    private String getOpenSearchFormId(String formId, int version) {
        return formId + "-" + version;
    }

    private SearchRequest getFormsSearch(QueryBuilder queryBuilder) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(100).sort(FORM_ID_FIELD, SortOrder.DESC).sort(FORM_VERSION_FIELD, SortOrder.DESC);
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        return new SearchRequest().indices(new String[]{FORMS_INDEX}).source(searchSourceBuilder).scroll(new TimeValue(60000L));
    }

    private SearchRequest getFormsSearchLatestVersion(QueryBuilder queryBuilder) {
        ArrayList<CompositeValuesSourceBuilder> sources = new ArrayList<CompositeValuesSourceBuilder>();
        sources.add(new TermsValuesSourceBuilder("form").field(FORM_ID_FIELD));
        CompositeAggregationBuilder compositeAggregationBuilder = (CompositeAggregationBuilder)new CompositeAggregationBuilder("forms", sources).size(10000).subAggregation((AggregationBuilder)new TopHitsAggregationBuilder("latestVersion").sort(FORM_VERSION_FIELD, SortOrder.DESC).size(1));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).aggregation((AggregationBuilder)compositeAggregationBuilder);
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        return new SearchRequest().indices(new String[]{FORMS_INDEX}).source(searchSourceBuilder);
    }

    private Set<Form> getFormsFromSearchRequest(SearchRequest searchRequest) throws OpenSearchIndexNotFoundException, OpenSearchRelatedException {
        try {
            LinkedHashSet<Form> formSet = new LinkedHashSet<Form>();
            SearchResponse searchResponse = this.openSearchService.getClient().search(searchRequest, RequestOptions.DEFAULT);
            LOG.info("Number of settings read from OpenSearch: " + searchResponse.getHits().getTotalHits().value);
            if (searchResponse.getHits().getTotalHits().value > 0L) {
                do {
                    for (SearchHit hit : searchResponse.getHits().getHits()) {
                        formSet.add(OpenSearchManagerImpl.getFormFromMap(OpenSearchManagerImpl.getOrderedMapFromSearchHit(hit)));
                    }
                    if (searchResponse.getScrollId() == null) continue;
                    searchResponse = this.openSearchService.getClient().scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(600000L)), RequestOptions.DEFAULT);
                } while (searchResponse.getHits().getHits().length != 0);
            }
            if (searchResponse.getAggregations() != null && searchResponse.getAggregations().get("forms") != null) {
                CompositeAggregation forms = (CompositeAggregation)searchResponse.getAggregations().get("forms");
                for (CompositeAggregation.Bucket formBucket : forms.getBuckets()) {
                    if (formBucket.getAggregations() == null || formBucket.getAggregations().get("latestVersion") == null) continue;
                    TopHits latestVersions = (TopHits)formBucket.getAggregations().get("latestVersion");
                    for (SearchHit hit : latestVersions.getHits().getHits()) {
                        formSet.add(OpenSearchManagerImpl.getFormFromMap(OpenSearchManagerImpl.getOrderedMapFromSearchHit(hit)));
                    }
                }
            }
            this.openSearchService.releaseScrollId(searchResponse);
            return formSet;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new OpenSearchIndexNotFoundException(Objects.toString(searchRequest.indices()));
            }
            throw new OpenSearchRelatedException(ex);
        }
    }

    private int getLastFormVersion(String formId) throws NoFormFoundException, PersistenceLayerException {
        Set<Form> formHistory = this.getFormHistory(formId);
        return formHistory.iterator().next().getVersion();
    }

    private int getNextFormVersion(String formId) throws PersistenceLayerException {
        int nextVersion = 1;
        try {
            nextVersion = this.getLastFormVersion(formId) + 1;
            LOG.finest("add new version " + nextVersion + " to form " + formId);
        }
        catch (NoFormFoundException e) {
            LOG.finest("create new form " + formId);
        }
        return nextVersion;
    }
}

