/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_chr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AZ = "\u13a0\u13ce\u13c6\u13e3\u13c2";
        final String metaValue_JP = "\u13e3\u13e9\u13c2\u13cf";
        final String metaValue_KG = "\u13a9\u13b5\u13e3\u13a2\u13cd";
        final String metaValue_ML = "\u13b9\u13b5";
        final String metaValue_NP = "\u13c1\u13c6\u13b5";
        final String metaValue_NR = "\u13c3\u13a4\u13b7";
        final String metaValue_SO = "\u13d0\u13b9\u13b5";
        final String metaValue_TV = "\u13da\u13e9\u13b7";
        final String metaValue_bo = "\u13d8\u13c7\u13d4\u13c2";
        final String metaValue_gu = "\u13ab\u13e3\u13b3\u13d8";
        final String metaValue_hy = "\u13a0\u13b3\u13bb\u13a0\u13c2";
        final String metaValue_ka = "\u13e6\u13e5\u13a0\u13c2";
        final String metaValue_km = "\u13a9\u13bb\u13b7";
        final String metaValue_kn = "\u13a7\u13be\u13d3";
        final String metaValue_ko = "\u13aa\u13b5\u13a0\u13c2";
        final String metaValue_la = "\u13b3\u13d8\u13c2";
        final String metaValue_lo = "\u13b3\u13a3";
        final String metaValue_ml = "\u13b9\u13b3\u13ef\u13b3\u13bb";
        final String metaValue_mn = "\u13b9\u13c2\u13aa\u13b5\u13a0\u13c2";
        final String metaValue_or = "\u13a3\u13d7\u13a0";
        final String metaValue_ta = "\u13d4\u13bb\u13b5";
        final String metaValue_te = "\u13d6\u13b7\u13a6";
        final String metaValue_chr = "\u13e3\u13b3\u13a9";
        final Object[][] data = new Object[][] {
            { "ksh", "\u13aa\u13b6\u13c2\u13a0\u13c2" },
            { "mwl", "\u13bb\u13b3\u13d5\u13cf" },
            { "Zsym", "\u13d7\u13ac\u13df\u13b6\u13cd\u13d9\u13d7" },
            { "Zsye", "\u13a1\u13bc\u13e5" },
            { "ccp", "\u13e3\u13a7\u13b9" },
            { "tem", "\u13d8\u13b9\u13c1" },
            { "teo", "\u13d6\u13d0" },
            { "rap", "\u13b3\u13c6\u13c4\u13eb" },
            { "AC", "\u13a4\u13b5\u13cc\u13b3\u13d3\u13c5 \u13a4\u13a6\u13da\u13db\u13a2" },
            { "rar", "\u13b3\u13b6\u13d9\u13be\u13a6\u13c2" },
            { "tet", "\u13d6\u13da\u13bc" },
            { "AD", "\u13a0\u13c2\u13d9\u13b3" },
            { "AE", "\u13cc\u13ca \u13a2\u13f3\u13be\u13b5\u13cd\u13d4\u13c5 \u13a1\u13b3\u13c8 \u13a2\u13b9\u13b5\u13d8\u13cf" },
            { "nl_BE", "\u13ca\u13b5\u13e5\u13a5\u13bb \u13db\u13e5" },
            { "AF", "\u13a0\u13eb\u13a8\u13c2\u13cd\u13d6\u13c2" },
            { "AG", "\u13a4\u13ea\u13d8 & \u13c6\u13ca\u13d3" },
            { "type.ca.ethiopic", "\u13a2\u13d7\u13ef\u13c8\u13a9 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "AI", "\u13a0\u13c2\u13a9\u13b3" },
            { "AL", "\u13a0\u13b5\u13c7\u13c2\u13ef" },
            { "AM", "\u13a0\u13b5\u13bb\u13c2\u13a0" },
            { "AO", "\u13a0\u13c2\u13aa\u13b3" },
            { "AQ", "\u13e7\u13c1\u13cd\u13d3\u13b8" },
            { "AR", "\u13a0\u13e5\u13c2\u13d8\u13c2\u13a0" },
            { "AS", "\u13a0\u13ba\u13b5\u13a7 \u13cc\u13bc\u13a0" },
            { "AT", "\u13a0\u13cd\u13df\u13ef" },
            { "AU", "\u13a1\u13b3\u13d7\u13dc" },
            { "AW", "\u13a0\u13b7\u13c6" },
            { "en_US", "\u13a0\u13b9\u13f0\u13df \u13a9\u13b5\u13cf" },
            { "AX", "\u13a3\u13b4\u13c5\u13d3 \u13da\u13a6\u13da\u13db\u13a2" },
            { "AZ", metaValue_AZ },
            { "BA", "\u13c9\u13cf\u13c2\u13a0 & \u13b2\u13e4\u13aa\u13eb\u13be" },
            { "BB", "\u13c6\u13c7\u13d9\u13cd" },
            { "ceb", "\u13ce\u13c6\u13c3" },
            { "BD", "\u13c6\u13c2\u13a6\u13b5\u13d5\u13cd" },
            { "kum", "\u13ab\u13bb\u13a7" },
            { "BE", "\u13c7\u13b5\u13e5\u13a5\u13bb" },
            { "BF", "\u13cb\u13a9\u13be \u13e9\u13d0" },
            { "BG", "\u13ca\u13b5\u13a8\u13b5\u13a0" },
            { "BH", "\u13c6\u13ad\u13b4\u13a2\u13c2" },
            { "BI", "\u13cb\u13b7\u13c2\u13d7" },
            { "BJ", "\u13c6\u13c2\u13a2\u13c2" },
            { "BL", "\u13a4\u13d3\u13c5\u13d8 \u13c6\u13d5\u13b3\u13bb" },
            { "BM", "\u13c6\u13ca\u13d3" },
            { "myv", "\u13a1\u13cf\u13ef" },
            { "BN", "\u13ca\u13be\u13a2" },
            { "BO", "\u13c9\u13b5\u13eb\u13a0" },
            { "BQ", "\u13a7\u13b5\u13c8\u13a2\u13c2\u13af \u13be\u13cd\u13a9\u13c1\u13db\u13b3\u13c2" },
            { "BR", "\u13c6\u13cf\u13b5" },
            { "BS", "\u13be\u13cd\u13a9 \u13c6\u13ad\u13b9\u13cd" },
            { "xog", "\u13d0\u13a6" },
            { "BT", "\u13ca\u13d4\u13c2" },
            { "BV", "\u13ca\u13ea \u13a4\u13a6\u13da\u13db\u13a2" },
            { "BW", "\u13c6\u13e3\u13e9\u13be" },
            { "BY", "\u13c7\u13b3\u13b7\u13cd" },
            { "BZ", "\u13c7\u13b5\u13cd" },
            { "type.ca.persian", "\u13c7\u13cf\u13a0\u13c2 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.hebr", "\u13a0\u13c2\u13c8\u13b7 \u13d7\u13ce\u13cd\u13d7" },
            { "CA", "\u13a8\u13be\u13d3" },
            { "CC", "\u13aa\u13aa\u13cd (\u13a9\u13b5\u13c2) \u13da\u13a6\u13da\u13db\u13a2" },
            { "mzn", "\u13b9\u13cc\u13d5\u13b3\u13c2" },
            { "CD", "\u13a7\u13c2\u13aa - \u13a8\u13c2\u13dd\u13cc" },
            { "CF", "\u13ac\u13bf\u13a8\u13cd\u13db \u13a0\u13f0\u13df \u13cd\u13a6\u13da\u13a9" },
            { "CG", "\u13a7\u13c2\u13aa - \u13c6\u13cc\u13e9\u13b5" },
            { "CH", "\u13cd\u13eb\u13cd" },
            { "CI", "\u13a2\u13ec\u13b5 \u13be\u13bf \u13a0\u13b9\u13f3\u13b6\u13d7" },
            { "CK", "\u13a0\u13d3\u13cd\u13d3\u13f4\u13b2\u13cd\u13a9 \u13da\u13a6\u13da\u13db\u13a2" },
            { "CL", "\u13e5\u13b5" },
            { "CM", "\u13a7\u13b9\u13b7\u13c2" },
            { "CN", "\u13d3\u13b6\u13c2\u13a8\u13cd\u13db" },
            { "CO", "\u13aa\u13b8\u13bb\u13c8\u13a2\u13a0" },
            { "CP", "\u13a6\u13c2\u13f4\u13d4\u13c5\u13a3\u13d3\u13b8 \u13a4\u13a6\u13da\u13db\u13a2" },
            { "CR", "\u13aa\u13cd\u13d3 \u13b5\u13a7" },
            { "CU", "\u13ab\u13c6" },
            { "CV", "\u13a2\u13ac\u13be\u13d5\u13be \u13a2\u13e4\u13f3\u13cd\u13d7" },
            { "CW", "\u13ab\u13b3\u13a8\u13a3" },
            { "CX", "\u13d3\u13c2\u13cd\u13d3\u13f2\u13af\u13b2 \u13a4\u13a6\u13da\u13db\u13a2" },
            { "CY", "\u13cc\u13a2\u13c6\u13cd" },
            { "CZ", "\u13e4\u13a9\u13a0" },
            { "eka", "\u13a8\u13a7\u13e7\u13a7" },
            { "DE", "\u13a0\u13c2\u13db\u13e5" },
            { "ace", "\u13a0\u13e5\u13c2\u13cf" },
            { "cgg", "\u13e5\u13a6" },
            { "DG", "\u13d7\u13f0\u13aa \u13a6\u13cf\u13ef" },
            { "type.nu.deva", "\u13d5\u13eb\u13be\u13a6\u13b5 \u13d7\u13ce\u13cd\u13d7" },
            { "DJ", "\u13e5\u13ca\u13d7" },
            { "DK", "\u13d7\u13c2\u13b9\u13a6" },
            { "Brai", "\u13d7\u13c2\u13a8\u13eb \u13a4\u13c3\u13ea\u13b6\u13d9\u13d7" },
            { "DM", "\u13d9\u13bb\u13c2\u13a7" },
            { "type.nu.armnlow", "\u13a0\u13b3\u13bb\u13a0\u13c2 \u13e7\u13cd\u13d7 \u13d7\u13aa\u13ea\u13b5 \u13d7\u13ce\u13cd\u13d7" },
            { "DO", "\u13d9\u13bb\u13c2\u13a7\u13c2 \u13cd\u13a6\u13da\u13a9" },
            { "gor", "\u13aa\u13b6\u13c2\u13d4\u13c3" },
            { "zun", "\u13d1\u13c2" },
            { "tig", "\u13e2\u13d3\u13e5" },
            { "DZ", "\u13a0\u13b5\u13e5\u13b5\u13ef" },
            { "pag", "\u13c7\u13a6\u13cf\u13a0\u13c2" },
            { "EA", "\u13d1\u13d4 \u13a0\u13b4 \u13ba\u13b5\u13ef" },
            { "pam", "\u13c6\u13b9\u13c6\u13be\u13a6" },
            { "EC", "\u13a1\u13c6\u13d9\u13b5" },
            { "pap", "\u13c6\u13c8\u13ef\u13ba\u13be\u13d9" },
            { "ada", "\u13a0\u13d3\u13be\u13a6\u13ba" },
            { "EE", "\u13a1\u13cd\u13d9\u13c2\u13ef" },
            { "EG", "\u13a2\u13e5\u13c8\u13a2" },
            { "EH", "\u13ed\u13d5\u13b5\u13ac \u13d7\u13dc \u13cc\u13ae\u13b3" },
            { "pau", "\u13c6\u13b3\u13a4\u13e9\u13c2" },
            { "chk", "\u13e7\u13a8\u13ce" },
            { "chm", metaValue_ML },
            { "cho", "\u13a0\u13e3\u13d3" },
            { "chr", metaValue_chr },
            { "ER", "\u13a1\u13b5\u13df\u13ef" },
            { "ES", "\u13a0\u13c2\u13cd\u13c6\u13c2\u13f1" },
            { "ET", "\u13a2\u13d7\u13a3\u13c8\u13a0" },
            { "EU", "\u13f3\u13b3\u13db \u13a0\u13c2\u13a4\u13be\u13d3\u13e1\u13ac" },
            { "type.ca.gregorian", "\u13a9\u13b4\u13aa\u13b5\u13a0\u13c2 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "EZ", "\u13f3\u13b6\u13a0\u13cd\u13d3\u13c5\u13c5" },
            { "chy", "\u13e3\u13f0\u13c2" },
            { "type.nu.gujr", "\u13ab\u13e3\u13b3\u13d8 \u13d7\u13ce\u13cd\u13d7" },
            { "ady", "\u13a0\u13d7\u13a8" },
            { "FI", "\u13eb\u13c2\u13a6\u13d9\u13af" },
            { "FJ", "\u13eb\u13e5" },
            { "FK", "\u13e9\u13a9 \u13da\u13a6\u13da\u13db\u13a2" },
            { "FM", "\u13b9\u13a2\u13c9\u13c2\u13cf\u13ef" },
            { "FO", "\u13ea\u13b6 \u13da\u13a6\u13da\u13db\u13a2" },
            { "Taml", metaValue_ta },
            { "FR", "\u13a6\u13b8\u13e5\u13f1" },
            { "GA", "\u13a6\u13c9\u13c2" },
            { "GB", "\u13a9\u13b5\u13cf\u13f2" },
            { "pcm", "\u13be\u13a9\u13b5\u13a0\u13c2 \u13c8\u13e5\u13c2" },
            { "GD", "\u13cb\u13be\u13d3" },
            { "GE", "\u13e3\u13a0\u13e5\u13a2" },
            { "GF", "\u13a0\u13c2\u13a6\u13b8\u13e5 \u13a9\u13a0" },
            { "GG", "\u13ac\u13c2\u13cf" },
            { "GH", "\u13a6\u13a0\u13be" },
            { "GI", "\u13e5\u13c6\u13b5\u13d3" },
            { "GL", "\u13a2\u13e4\u13cd\u13db\u13f1" },
            { "GM", "\u13a6\u13b9\u13c8\u13a2\u13a0" },
            { "GN", "\u13a9\u13a2\u13c2" },
            { "GP", "\u13e9\u13d3\u13b7\u13c7" },
            { "GQ", "\u13a1\u13c6\u13d9\u13b5\u13a0\u13b5 \u13a9\u13a2\u13c2" },
            { "GR", "\u13aa\u13a2\u13af" },
            { "GS", "\u13e7\u13a6\u13c3\u13ee \u13e3\u13a0\u13e5\u13a2 \u13a0\u13b4 \u13be\u13cd\u13a9 \u13e7\u13a6\u13c3\u13ee \u13a0\u13cd\u13db\u13ad\u13df \u13da\u13a6\u13da\u13db\u13a2" },
            { "GT", "\u13e9\u13d4\u13b9\u13b3" },
            { "GU", "\u13c6\u13bb" },
            { "GW", "\u13a9\u13a2\u13c2-\u13c8\u13cc\u13a4\u13eb" },
            { "tlh", "\u13df\u13a6\u13be" },
            { "GY", "\u13a6\u13ef\u13be" },
            { "ckb", "\u13a0\u13f0\u13df \u13ab\u13d7\u13cf" },
            { "zxx", "\u13dd \u13a6\u13ec\u13c2\u13af\u13cd\u13d7 \u13a6\u13b8\u13db\u13a2 \u13f1\u13a9" },
            { "de_AT", "\u13a0\u13df\u13ef\u13c2 \u13a0\u13c2\u13d3\u13e5" },
            { "HK", "\u13b0\u13c2\u13a9 \u13aa\u13c2\u13a9 \u13a4\u13d3\u13e4\u13b5\u13d3 \u13e7\u13c2\u13b8\u13eb\u13cd\u13d3\u13c1\u13d7 \u13a2\u13ac\u13be\u13d5\u13be \u13d3\u13b6\u13c2\u13a8\u13cd\u13db" },
            { "HM", "\u13b2\u13d7 \u13a4\u13a6\u13da\u13db\u13a2 \u13a0\u13b4 \u13ba\u13a9\u13d3\u13be\u13b5\u13d7 \u13da\u13a6\u13da\u13db\u13a2" },
            { "HN", "\u13ad\u13c2\u13da\u13b3\u13cd" },
            { "HR", "\u13a7\u13b6\u13a1\u13cf\u13a0" },
            { "agq", "\u13a0\u13a8\u13b9" },
            { "gsw", "\u13cd\u13eb\u13cf \u13a0\u13c2\u13d3\u13e5" },
            { "HT", "\u13ae\u13a2\u13d8" },
            { "HU", "\u13b2\u13c2\u13a6\u13b5" },
            { "IC", "\u13e5\u13cd\u13c6 \u13da\u13a6\u13da\u13db\u13a2" },
            { "ID", "\u13a2\u13c2\u13d9\u13c2\u13cd\u13ef" },
            { "IE", "\u13a0\u13f2\u13b3\u13c2" },
            { "nap", "\u13c2\u13ef\u13c6\u13b5\u13d4\u13c2" },
            { "naq", "\u13be\u13b9" },
            { "zza", "\u13cc\u13cc" },
            { "IL", "\u13a2\u13cf\u13b5\u13f1" },
            { "IM", "\u13a4\u13cd\u13d7 \u13a4\u13a6\u13da\u13db\u13a2 \u13be\u13bf \u13a0\u13cd\u13a6\u13ef" },
            { "IN", "\u13a2\u13c5\u13d7\u13be" },
            { "IO", "\u13c8\u13d7\u13cf \u13f4\u13eb\u13ef \u13a0\u13ba\u13c9 \u13a2\u13ac\u13be\u13d5\u13c5" },
            { "IQ", "\u13a2\u13b3\u13a9" },
            { "IR", "\u13a2\u13b4\u13c2" },
            { "IS", "\u13e7\u13c1\u13cd\u13d3\u13b8\u13af" },
            { "IT", "\u13a2\u13d4\u13b5" },
            { "Zmth", "\u13a0\u13f0\u13a6\u13b4\u13f4\u13eb\u13cd\u13a9 \u13a0\u13a4\u13d3\u13d7\u13cd\u13d9\u13d7" },
            { "type.nu.thai", "\u13d4\u13f1 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.beng", "\u13c7\u13c2\u13a6\u13b3 \u13d7\u13ce\u13cd\u13d7" },
            { "JE", "\u13e8\u13b5\u13cf" },
            { "type.ca.islamic", "\u13a2\u13cd\u13b3\u13bb\u13a9 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "JM", "\u13e3\u13ba\u13a2\u13a7" },
            { "Beng", "\u13c7\u13c2\u13a6\u13a0" },
            { "JO", "\u13e6\u13d3\u13c2" },
            { "JP", metaValue_JP },
            { "ain", "\u13a0\u13f1\u13c4" },
            { "guz", "\u13ab\u13cf" },
            { "type.nu.knda", "\u13a7\u13be\u13d3 \u13d7\u13ce\u13cd\u13d7" },
            { "de_CH", "\u13cd\u13eb\u13cf \u13a6\u13b8\u13b3\u13d7 \u13a0\u13c2\u13d3\u13e5" },
            { "type.ca.buddhist", "\u13ca\u13d7\u13cd\u13d8 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "KE", "\u13a8\u13c2\u13ef" },
            { "KG", metaValue_KG },
            { "419", "\u13b3\u13d8\u13c2 \u13a0\u13b9\u13f0\u13df" },
            { "KH", "\u13a7\u13b9\u13c9\u13d7\u13a0\u13c2" },
            { "KI", "\u13a7\u13b5\u13c6\u13d8" },
            { "KM", "\u13aa\u13bc\u13b3\u13cd" },
            { "Knda", metaValue_kn },
            { "KN", "\u13a4\u13d3\u13c5\u13d8 \u13a8\u13d8\u13cf \u13a0\u13b4 \u13c1\u13ea\u13cf" },
            { "fr_CA", "\u13a8\u13be\u13d3 \u13a6\u13b8\u13e5" },
            { "KP", "\u13e7\u13f4\u13e2 \u13aa\u13b5\u13a0" },
            { "KR", "\u13e7\u13a6\u13c3\u13ee \u13aa\u13b5\u13a0" },
            { "fr_CH", "\u13cd\u13eb\u13cf \u13a6\u13b8\u13e5" },
            { "KW", "\u13ab\u13ea\u13a2\u13d8" },
            { "tpi", "\u13d9\u13a9 \u13c8\u13cf\u13c2" },
            { "KY", "\u13a8\u13a2\u13b9\u13c2 \u13da\u13a6\u13da\u13db\u13a2" },
            { "KZ", "\u13a7\u13ce\u13a7\u13cd\u13d5\u13c2" },
            { "Cyrl", "\u13f2\u13c2\u13a2 \u13d7\u13aa\u13ea\u13b5" },
            { "LA", "\u13b4\u13a3\u13cd" },
            { "LB", "\u13b4\u13c6\u13be\u13c2" },
            { "LC", "\u13a4\u13d3\u13c5\u13d8 \u13b7\u13cf\u13ef" },
            { "gwi", "\u13c8\u13e5\u13c2" },
            { "nds", "\u13a1\u13b3\u13d7 \u13a0\u13c2\u13d3\u13e5" },
            { "LI", "\u13b5\u13a6\u13d7\u13c2\u13cd\u13d3\u13c2" },
            { "LK", "\u13cd\u13b5 \u13b3\u13c2\u13a7" },
            { "LR", "\u13b3\u13c8\u13b5\u13ef" },
            { "LS", "\u13b4\u13d0\u13d9" },
            { "LT", "\u13b5\u13d7\u13ea\u13c2\u13a0" },
            { "LU", "\u13b8\u13a7\u13ce\u13cb\u13a9" },
            { "LV", "\u13b3\u13d8\u13eb\u13a0" },
            { "Kana", "\u13a7\u13d4\u13a7\u13be" },
            { "LY", "\u13b5\u13c8\u13ef" },
            { "lad", "\u13b3\u13d7\u13c3" },
            { "vun", "\u13ed\u13be\u13e6" },
            { "lag", "\u13b3\u13c2\u13a9" },
            { "Thaa", "\u13d4\u13a0\u13be" },
            { "MA", "\u13bc\u13b6\u13aa" },
            { "MC", "\u13b9\u13be\u13aa" },
            { "MD", "\u13b9\u13b5\u13d9\u13eb\u13a0" },
            { "ME", "\u13bc\u13c2\u13d4\u13c1\u13a6\u13b6" },
            { "MF", "\u13a4\u13d3\u13c5\u13d8 \u13e1\u13e1" },
            { "MG", "\u13b9\u13d3\u13a6\u13cd\u13a7\u13b5" },
            { "MH", "\u13b9\u13cc\u13b5 \u13da\u13a6\u13da\u13db\u13a2" },
            { "ale", "\u13a0\u13b5\u13a4\u13d8" },
            { "Thai", "\u13d4\u13f1 \u13d4\u13ef\u13b4\u13c2" },
            { "MK", "\u13e7\u13f4\u13dc \u13b9\u13ce\u13d9\u13c2\u13ef" },
            { "ML", metaValue_ML },
            { "MM", "\u13b9\u13ef\u13b9\u13b5 (\u13c7\u13b5\u13b9)" },
            { "MN", "\u13b9\u13c2\u13aa\u13b5\u13a0" },
            { "new", "\u13c1\u13e9\u13b5" },
            { "MO", "\u13b9\u13a7\u13a3 (\u13a4\u13d3\u13e4\u13b5\u13d3 \u13e7\u13c2\u13b8\u13eb\u13cd\u13d3\u13c1\u13d7 \u13a2\u13ac\u13be\u13d5\u13be) \u13e3\u13a2" },
            { "MP", "\u13e7\u13f4\u13e2 \u13d7\u13dc \u13b9\u13b5\u13a0\u13be \u13da\u13a6\u13da\u13db\u13a2" },
            { "MQ", "\u13b9\u13d8\u13c2\u13a8" },
            { "MR", "\u13b9\u13d8\u13a2\u13ef" },
            { "MS", "\u13b9\u13c2\u13d8\u13cc\u13b3\u13d7" },
            { "MT", "\u13b9\u13b5\u13d4" },
            { "MU", "\u13bc\u13b5\u13cf\u13a5\u13cd" },
            { "alt", "\u13e7\u13a6\u13be\u13ee \u13d7\u13dc \u13a0\u13b5\u13d4\u13a2" },
            { "MV", "\u13b9\u13b5\u13d7\u13eb\u13cd" },
            { "MW", "\u13b9\u13b3\u13eb" },
            { "MX", "\u13a0\u13c2\u13cd\u13c6\u13c2" },
            { "type.ca.japanese", "\u13e3\u13c6\u13c2\u13cf \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "MY", "\u13b9\u13b4\u13cf\u13a2\u13a0" },
            { "MZ", "\u13bc\u13ce\u13bb\u13c7\u13a9" },
            { "NA", "\u13be\u13bb\u13c8\u13a2\u13ef" },
            { "202", "\u13ad\u13eb\u13c2-\u13cc\u13ad\u13e9 \u13ac\u13bf\u13a8\u13cd\u13db" },
            { "type.ca.hebrew", "\u13a0\u13c2\u13c8\u13b7 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "NC", "\u13a2\u13e4 \u13a7\u13b5\u13d9\u13c2\u13a0\u13c2" },
            { "NE", "\u13be\u13a2\u13e8" },
            { "NF", "\u13c3\u13b5\u13ec\u13b5\u13a9 \u13a4\u13a6\u13da\u13db\u13a2" },
            { "NG", "\u13c2\u13e5\u13b5\u13ef" },
            { "trv", "\u13d4\u13b6\u13aa" },
            { "NI", "\u13c2\u13a7\u13b3\u13c6" },
            { "NL", "\u13c1\u13db\u13b3\u13c2" },
            { "NO", "\u13c3\u13ea" },
            { "NP", metaValue_NP },
            { "NR", metaValue_NR },
            { "NU", "\u13c2\u13f3" },
            { "rof", "\u13b6\u13b9\u13c9" },
            { "NZ", "\u13a2\u13e4 \u13cf\u13a2\u13b4\u13c2\u13d7" },
            { "OM", "\u13a3\u13ba\u13c2" },
            { "anp", "\u13a0\u13be\u13a9\u13a7" },
            { "crs", "\u13ce\u13ce\u13b5\u13e9 \u13df\u13f2\u13b5 \u13a0\u13c2\u13a6\u13b8" },
            { "PA", "\u13c6\u13be\u13b9" },
            { "en_GB", "\u13a9\u13b5\u13cf\u13f2 \u13a9\u13b5\u13cf" },
            { "PE", "\u13c7\u13b7" },
            { "PF", "\u13a0\u13c2\u13a6\u13b8\u13e5 \u13c6\u13b5\u13c2\u13cf\u13a0" },
            { "PG", "\u13c6\u13c7 \u13a2\u13e4 \u13a9\u13a2\u13c2" },
            { "PH", "\u13a0\u13c2\u13c8\u13b5\u13a9\u13c3" },
            { "PK", "\u13c6\u13a9\u13cd\u13d6\u13c2" },
            { "PL", "\u13c9\u13b3\u13c2" },
            { "ewo", "\u13a1\u13ec\u13c2\u13d9" },
            { "PM", "\u13a4\u13d3\u13c5\u13d8 \u13c8\u13f0 \u13a0\u13b4 \u13bb\u13c7\u13b6\u13c2" },
            { "PN", "\u13c8\u13a7\u13b5\u13c2 \u13da\u13a6\u13da\u13db\u13a2" },
            { "PR", "\u13c7\u13a1\u13d9 \u13b5\u13a2\u13aa" },
            { "PS", "\u13c6\u13b4\u13cd\u13d7\u13c2\u13a0\u13c2 \u13c4\u13ac\u13eb\u13f3\u13cc\u13d5\u13a9" },
            { "PT", "\u13c9\u13e5\u13a6\u13b3" },
            { "PW", "\u13c6\u13b4\u13a0\u13eb" },
            { "nia", "\u13c2\u13a0\u13cf" },
            { "type.nu.greklow", "\u13a0\u13c2\u13aa\u13a2 \u13e7\u13cd\u13d7 \u13d7\u13aa\u13ea\u13b5 \u13d7\u13ce\u13cd\u13d7" },
            { "PY", "\u13c6\u13b3\u13c7\u13a2\u13ef" },
            { "tum", "\u13db\u13b9\u13ca\u13a7" },
            { "Hebr", "\u13a0\u13c2\u13c8\u13b5" },
            { "QA", "\u13a7\u13d4\u13b5" },
            { "niu", "\u13c2\u13f3\u13eb\u13ef\u13c2" },
            { "QO", "\u13a0\u13cd\u13db \u13a3\u13cf\u13f0\u13c2\u13a0" },
            { "lez", "\u13b4\u13cf\u13a6\u13c2" },
            { "tvl", metaValue_TV },
            { "001", "\u13a1\u13b6\u13af" },
            { "002", "\u13ac\u13bf\u13a8\u13cd\u13db" },
            { "003", "\u13e7\u13f4\u13e2 \u13a0\u13b9\u13f0\u13df" },
            { "RE", "\u13b4\u13f3\u13c2\u13a0\u13c2" },
            { "005", "\u13e7\u13a6\u13c3\u13ee \u13a0\u13ba\u13b5\u13a6" },
            { "jbo", "\u13b6\u13e3\u13c6\u13c2" },
            { "009", "\u13a3\u13cf\u13f0\u13c2\u13a0" },
            { "RO", "\u13b6\u13b9\u13c2\u13ef" },
            { "RS", "\u13d2\u13c8\u13ef" },
            { "RU", "\u13f2\u13c2\u13a2" },
            { "RW", "\u13b6\u13e9\u13c2\u13d3" },
            { "SA", "\u13cc\u13a4\u13d7 \u13a1\u13b4\u13c8\u13a0" },
            { "SB", "\u13d0\u13b6\u13b9\u13c2 \u13da\u13a6\u13da\u13db\u13a2" },
            { "twq", "\u13d4\u13cc\u13e9\u13a9" },
            { "011", "\u13ed\u13d5\u13b5\u13ac \u13d7\u13dc \u13ac\u13bf\u13a8\u13cd\u13db" },
            { "SC", "\u13cf\u13a1\u13e5\u13b5\u13cd" },
            { "SD", "\u13d1\u13d5\u13c2" },
            { "013", "\u13a0\u13f0\u13df \u13a0\u13b9\u13f0\u13df" },
            { "SE", "\u13cd\u13eb\u13d5\u13c2" },
            { "014", "\u13d7\u13a7\u13b8\u13ac \u13d7\u13dc \u13ac\u13bf\u13a8\u13cd\u13db" },
            { "015", "\u13e7\u13f4\u13e2 \u13d7\u13dc \u13ac\u13bf\u13a8\u13cd\u13db" },
            { "SG", "\u13cf\u13c2\u13a6\u13c9\u13b5" },
            { "SH", "\u13a4\u13d3\u13c5\u13d8 \u13ae\u13b5\u13be" },
            { "type.lb.strict", "\u13a4\u13b6\u13d2\u13cd\u13d4\u13c5\u13af \u13a0\u13cd\u13d3\u13c5\u13c5 \u13a0\u13f2\u13cd\u13d4\u13c5\u13a9 \u13c2\u13da\u13cd\u13db" },
            { "017", "\u13a0\u13f0\u13df \u13ac\u13bf\u13a8\u13cd\u13db" },
            { "SI", "\u13cd\u13b6\u13eb\u13c2\u13a0" },
            { "018", "\u13e7\u13a6\u13be\u13ee \u13d7\u13dc \u13ac\u13bf\u13a8\u13cd\u13db" },
            { "SJ", "\u13cd\u13e9\u13b5\u13c6\u13b5\u13d7 \u13a0\u13b4 \u13e4\u13c2 \u13b9\u13f0\u13c2" },
            { "019", "\u13a0\u13ba\u13b5\u13a6\u13a2" },
            { "SK", "\u13cd\u13b6\u13e9\u13a9\u13a0" },
            { "SL", "\u13cf\u13a1\u13b3 \u13b4\u13a3\u13c2" },
            { "SM", "\u13a4\u13d3\u13c5\u13d8 \u13b9\u13b5\u13a2\u13c3" },
            { "SN", "\u13cf\u13c2\u13a6\u13b5" },
            { "SO", metaValue_SO },
            { "arn", "\u13b9\u13ca\u13e4" },
            { "arp", "\u13a0\u13e9\u13c8\u13b0" },
            { "type.nu.taml", "\u13a4\u13e6\u13cd\u13d7 \u13d4\u13bb\u13b5 \u13d7\u13ce\u13cd\u13d7" },
            { "SR", "\u13d2\u13b5\u13be\u13bb" },
            { "SS", "\u13e7\u13a6\u13be\u13ee \u13d1\u13d5\u13c2" },
            { "ST", "\u13cc\u13a3 \u13d9\u13ba \u13a0\u13b4 \u13c8\u13c2\u13cf\u13c7" },
            { "SV", "\u13a1\u13b5\u13cc\u13b5\u13c6\u13d9\u13b5" },
            { "SX", "\u13cf\u13c2\u13d8 \u13b9\u13d8\u13c2" },
            { "SY", "\u13cf\u13b5\u13a0" },
            { "SZ", "\u13a1\u13cd\u13e9\u13d8\u13c2" },
            { "TA", "\u13df\u13cd\u13db\u13c2 \u13d3 \u13ab\u13be\u13ad" },
            { "asa", "\u13a0\u13d1" },
            { "type.ms.ussystem", "US \u13a0\u13df\u13b6\u13db \u13c4\u13cd\u13d7\u13d3\u13c5\u13a2" },
            { "021", "\u13e7\u13f4\u13e2 \u13d7\u13dc \u13a0\u13b9\u13f0\u13df" },
            { "TC", "\u13a0\u13c2\u13db\u13b5\u13a9 \u13a0\u13b4 \u13a8\u13a2\u13aa \u13da\u13a6\u13da\u13db\u13a2" },
            { "yav", "\u13f0\u13be\u13a6\u13c7\u13c2" },
            { "TD", "\u13e3\u13d7" },
            { "TF", "\u13a0\u13c2\u13a6\u13b8\u13e5 \u13e7\u13a6\u13be\u13ee \u13a6\u13d9\u13af \u13a4\u13b5\u13cd\u13db\u13a2" },
            { "TG", "\u13d9\u13aa" },
            { "TH", "\u13d4\u13ef\u13b4\u13c2" },
            { "TJ", "\u13d4\u13e5\u13a9\u13cd\u13d5\u13c2" },
            { "029", "\u13a8\u13c6\u13d9\u13ef" },
            { "TK", "\u13d9\u13a8\u13b3\u13ed" },
            { "TL", "\u13d8\u13bc\u13b5-\u13b4\u13cd\u13d6" },
            { "ybb", "\u13f0\u13b9\u13cb" },
            { "TM", "\u13db\u13b5\u13a9\u13ba\u13c2\u13cd\u13d4\u13c2" },
            { "TN", "\u13da\u13c2\u13cf\u13cd\u13a0" },
            { "TO", "\u13d9\u13be\u13a6" },
            { "TR", "\u13ac\u13c3" },
            { "TT", "\u13df\u13c2\u13d5\u13d7 \u13a0\u13b4 \u13d9\u13c6\u13aa" },
            { "TV", metaValue_TV },
            { "TW", "\u13d4\u13a2\u13e9\u13c2" },
            { "ast", "\u13a0\u13cd\u13da\u13b5\u13a0\u13c2" },
            { "TZ", "\u13d6\u13c2\u13cf\u13c2\u13ef" },
            { "nmg", "\u13c6\u13cf\u13f2" },
            { "Zzzz", "\u13c4\u13ec\u13b5\u13cd\u13db\u13be \u13a0\u13cd\u13d3\u13e9\u13db\u13cd\u13d9\u13d7" },
            { "UA", "\u13f3\u13a7\u13b4\u13c2" },
            { "rup", "\u13a0\u13ec\u13b9\u13c2\u13a0\u13c2" },
            { "030", "\u13d7\u13a7\u13b8\u13ac \u13d7\u13dc \u13d3\u13b6\u13c2\u13a8\u13cd\u13db" },
            { "tyv", "\u13da\u13eb\u13c2\u13a0\u13c2" },
            { "sw_CD", "\u13a7\u13c2\u13aa \u13cd\u13e9\u13af\u13b5" },
            { "034", "\u13e7\u13a6\u13be\u13ee \u13d7\u13dc \u13d3\u13b6\u13c2\u13a8\u13cd\u13db" },
            { "035", "\u13e7\u13a6\u13be\u13ee \u13d7\u13a7\u13b8\u13ac \u13d3\u13b6\u13c2\u13a8\u13cd\u13db" },
            { "UG", "\u13f3\u13a6\u13c2\u13d3" },
            { "039", "\u13e7\u13a6\u13be\u13ee \u13d7\u13dc \u13f3\u13b3\u13db" },
            { "Sinh", "\u13cf\u13c5\u13ad\u13b3" },
            { "UM", "U.S. \u13a0\u13cd\u13db \u13da\u13a6\u13da\u13db\u13a2" },
            { "UN", "\u13cc\u13ca \u13a2\u13f3\u13be\u13b5\u13cd\u13d4\u13c5 \u13a0\u13f0\u13b5 \u13da\u13be\u13d9\u13e2\u13d2" },
            { "US", "\u13cc\u13ca \u13a2\u13f3\u13be\u13b5\u13cd\u13d4\u13c5 \u13cd\u13a6\u13da\u13a9" },
            { "haw", "\u13ad\u13e9\u13bc" },
            { "UY", "\u13f3\u13b7\u13c7" },
            { "prg", "\u13e1\u13cf\u13a0\u13c2" },
            { "UZ", "\u13a4\u13cd\u13c7\u13a9\u13cd\u13d6\u13c2" },
            { "tzm", "\u13a0\u13f0\u13df \u13a1\u13b6\u13af \u13d3\u13df\u13b6\u13cd\u13d7\u13d3\u13c5\u13a2 \u13d4\u13b9\u13cf\u13d8" },
            { "nnh", "\u13be\u13e5\u13f0\u13b9\u13ca\u13c2" },
            { "VA", "\u13a0\u13e5\u13b3\u13c1\u13e0 \u13a6\u13da\u13b2" },
            { "VC", "\u13a4\u13d3\u13c5\u13d8 \u13eb\u13c2\u13cf\u13c2\u13d7 \u13a0\u13b4 \u13be\u13cd\u13a9 \u13c7\u13be\u13d7\u13c1\u13cd" },
            { "VE", "\u13ea\u13c1\u13d1\u13ea\u13b3" },
            { "VG", "\u13c8\u13d7\u13cd \u13a0\u13d2\u13c2\u13b8 \u13c2\u13a8\u13d2\u13be \u13da\u13a6\u13da\u13db\u13a2" },
            { "VI", "U.S. \u13a0\u13d2\u13c2\u13b8 \u13c2\u13a8\u13d2\u13be \u13da\u13a6\u13da\u13db\u13a2" },
            { "VN", "\u13eb\u13a1\u13d8\u13be\u13bb" },
            { "VU", "\u13e9\u13c2\u13a4\u13e9\u13da" },
            { "nog", "\u13c3\u13a6\u13f1" },
            { "rwk", "\u13c6" },
            { "053", "\u13a0\u13cd\u13d4\u13b4\u13cf\u13a0" },
            { "054", "\u13ba\u13b3\u13c1\u13cf\u13a0" },
            { "WF", "\u13e9\u13b5\u13cd \u13a0\u13b4 \u13ca\u13da\u13be" },
            { "057", "\u13a0\u13f0\u13df \u13e7\u13be\u13b5\u13aa\u13af \u13be\u13bf \u13b9\u13a2\u13c9\u13c2\u13cf\u13ef \u13a2\u13ac\u13be\u13d5\u13be" },
            { "jgo", "\u13be\u13aa\u13c6" },
            { "lkt", "\u13b3\u13aa\u13d3" },
            { "wae", "\u13e9\u13b5\u13ce\u13b5" },
            { "WS", "\u13cc\u13bc\u13a0" },
            { "wal", "\u13ec\u13b3\u13f1\u13d4" },
            { "XA", "\u13e1\u13d9-\u13c4\u13cd\u13db\u13a2\u13a5\u13a7\u13c1\u13ac\u13a2" },
            { "war", "\u13e9\u13b4" },
            { "XB", "\u13e1\u13d9-\u13c8\u13d7" },
            { "awa", "\u13a0\u13e9\u13d7" },
            { "061", "\u13c6\u13b5\u13c2\u13cf\u13a0" },
            { "XK", "\u13aa\u13d0\u13c9" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u13aa\u13ea\u13b3\u13c5 \u13c2\u13a8\u13d2\u13be" },
            { "YE", "\u13f0\u13ba\u13c2" },
            { "nqo", "\u13be\u13aa" },
            { "type.co.standard", "\u13a0\u13df\u13b6\u13cd\u13d7 \u13d7\u13a6\u13c5\u13c3\u13d9\u13d7 \u13d5\u13a6\u13c5\u13c3\u13db\u13a2" },
            { "YT", "\u13ba\u13ef\u13d6" },
            { "ZA", "\u13e7\u13a6\u13be\u13ee \u13ac\u13bf\u13a8\u13cd\u13db" },
            { "type.lb.loose", "\u13e9\u13be\u13a2 \u13a0\u13cd\u13d3\u13c5\u13c5 \u13a0\u13f2\u13cd\u13d4\u13c5\u13a9 \u13c2\u13da\u13cd\u13db" },
            { "Deva", "\u13d5\u13eb\u13be\u13a6\u13b5" },
            { "type.nu.geor", "\u13a9\u13b4\u13aa\u13b5\u13a0\u13c2 \u13d7\u13ce\u13cd\u13d7" },
            { "Hira", "\u13af\u13b3\u13a6\u13be" },
            { "ZM", "\u13cc\u13bb\u13c8\u13ef" },
            { "ZW", "\u13cf\u13bb\u13c6\u13c7" },
            { "ZZ", "\u13c4\u13ec\u13b5\u13cd\u13db\u13be \u13a4\u13d4\u13c2\u13d7\u13a6\u13d9\u13af" },
            { "type.ms.metric", "\u13a0\u13c2\u13a9\u13b8\u13e5 \u13c2\u13d3\u13f3\u13d3\u13b4\u13c5\u13af \u13d7\u13ce\u13cd\u13d7 \u13c4\u13cd\u13d7\u13d3\u13c5\u13a2" },
            { "type.ca.iso8601", "ISO-8601 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "nso", "\u13e7\u13f4\u13e2 \u13d7\u13dc \u13d0\u13e0" },
            { "type.nu.telu", "\u13d6\u13b7\u13a6 \u13d7\u13ce\u13cd\u13d7" },
            { "loz", "\u13b6\u13cf" },
            { "jmc", "\u13b9\u13e3\u13ba" },
            { "type.nu.hansfin", "\u13a0\u13af\u13d7\u13a8 \u13d3\u13b6\u13c2\u13a8 \u13a0\u13d5\u13b3 \u13d7\u13ce\u13cd\u13d7" },
            { "hil", "\u13af\u13b5\u13a8\u13be\u13c2" },
            { "type.nu.arabext", "\u13a6\u13c5\u13af\u13db \u13a0\u13b3\u13c8-\u13a1\u13c2\u13d7\u13a9 \u13d7\u13ce\u13cd\u13d7" },
            { "nus", "\u13c4\u13ea\u13b5" },
            { "dak", "\u13d3\u13aa\u13d4" },
            { "type.nu.fullwide", "\u13a7\u13b5\u13a2-\u13be\u13ef\u13db\u13d2 \u13d7\u13ce\u13cd\u13d7" },
            { "dar", "\u13d3\u13b3\u13c6" },
            { "dav", "\u13d4\u13a2\u13d4" },
            { "lrc", "\u13e7\u13f4\u13e2 \u13d7\u13dc \u13b7\u13b5" },
            { "udm", "\u13a4\u13da\u13b7\u13d8" },
            { "Khmr", metaValue_km },
            { "sad", "\u13cc\u13c5\u13d3\u13eb" },
            { "type.nu.roman", "\u13a0\u13c2\u13b6\u13bb \u13d7\u13ce\u13cd\u13d7" },
            { "sah", "\u13cc\u13a7\u13be" },
            { "saq", "\u13cc\u13b9\u13ca\u13b7" },
            { "sat", "\u13cc\u13c2\u13d4\u13b5" },
            { "sba", "\u13be\u13a6\u13b9\u13c7" },
            { "Guru", "\u13ac\u13b9\u13a9" },
            { "lua", "\u13b7\u13c6-\u13b7\u13b7\u13a0" },
            { "sbp", "\u13cc\u13c1\u13ab" },
            { "nyn", "\u13c2\u13ef\u13be\u13aa\u13b4" },
            { "lun", "\u13b7\u13be\u13d3" },
            { "luo", "\u13b7\u13a3" },
            { "fil", "\u13a0\u13c8\u13b5\u13a9" },
            { "hmn", "\u13ad\u13bc\u13c2\u13a9" },
            { "lus", "\u13bb\u13d0" },
            { "ban", "\u13c6\u13b5\u13c1\u13cf" },
            { "luy", "\u13b7\u13f1\u13a0" },
            { "bas", "\u13c6\u13cc\u13a0" },
            { "es_ES", "\u13a0\u13c2\u13cd\u13c6\u13c2\u13f1 \u13cd\u13c6\u13c2" },
            { "sco", "\u13cd\u13a6\u13d7" },
            { "scn", "\u13cf\u13cf\u13b5\u13a0\u13c2" },
            { "aa", "\u13a0\u13e9\u13b3" },
            { "ab", "\u13a0\u13c6\u13cf\u13a0\u13c2" },
            { "af", "\u13a0\u13ac\u13bf\u13a8\u13cd\u13db" },
            { "ak", "\u13a0\u13a7\u13be" },
            { "am", "\u13a0\u13b9\u13ad\u13b5\u13a9" },
            { "an", "\u13a0\u13e9\u13aa\u13c2\u13cf" },
            { "Arab", "\u13a1\u13b3\u13c8\u13a9" },
            { "Jpan", "\u13e3\u13c6\u13c2\u13cf" },
            { "ar", "\u13a1\u13b3\u13c8" },
            { "Hrkt", "\u13e3\u13e9\u13c2\u13cf \u13e7\u13c3\u13f4\u13a9" },
            { "as", "\u13a0\u13cc\u13bb\u13cf" },
            { "av", "\u13a0\u13e9\u13b5\u13a7" },
            { "ay", "\u13a0\u13f1\u13b9\u13b3" },
            { "az", metaValue_AZ },
            { "ba", "\u13c6\u13cd\u13af\u13a9\u13a0" },
            { "be", "\u13c7\u13b3\u13b7\u13cf" },
            { "bg", "\u13ca\u13b5\u13a8\u13b5\u13a0\u13c2" },
            { "bi", "\u13c8\u13cd\u13b3\u13b9" },
            { "bm", "\u13c6\u13bb\u13c6\u13b3" },
            { "bn", "\u13c7\u13c2\u13a6\u13b3" },
            { "bo", metaValue_bo },
            { "dgr", "\u13a9\u13df \u13a4\u13c4\u13b3\u13e5" },
            { "br", "\u13c7\u13d9\u13c2" },
            { "bs", "\u13c6\u13cd\u13c2\u13a0\u13c2" },
            { "see", "\u13cf\u13c2\u13a6" },
            { "Mymr", "\u13b9\u13a1\u13c2\u13b9\u13b3" },
            { "type.nu.laoo", "\u13b3\u13a3 \u13d7\u13ce\u13cd\u13d7" },
            { "seh", "\u13ce\u13be" },
            { "ca", "\u13a8\u13d4\u13b3\u13c2" },
            { "ses", "\u13aa\u13f1\u13b3\u13c8\u13b6 \u13ce\u13c2" },
            { "ce", "\u13e4\u13e4\u13c2" },
            { "ch", "\u13e3\u13bc\u13b6" },
            { "co", "\u13aa\u13b5\u13cd\u13a2\u13a7\u13c2" },
            { "Orya", metaValue_or },
            { "cs", "\u13e4\u13a9" },
            { "cu", "\u13e7\u13c2\u13b3\u13eb\u13cd\u13d7 \u13cd\u13b3\u13eb\u13aa" },
            { "cv", "\u13e7\u13e9\u13cf" },
            { "cy", "\u13ea\u13b5\u13cf" },
            { "type.nu.ethi", "\u13a2\u13d7\u13ef\u13c8\u13a9 \u13d7\u13ce\u13cd\u13d7" },
            { "da", "\u13d5\u13c2\u13cd" },
            { "pt_PT", "\u13f3\u13b3\u13c8 \u13c9\u13e7\u13a9\u13cd" },
            { "de", "\u13d9\u13a2\u13e5" },
            { "type.cf.standard", "\u13a0\u13df\u13b6\u13cd\u13d7 \u13a0\u13d5\u13b3 \u13f1\u13ac\u13c1\u13b8\u13af" },
            { "bem", "\u13c7\u13b9\u13c6" },
            { "dv", "\u13d7\u13ea\u13af" },
            { "es_419", "\u13d4\u13d8\u13c2 \u13a0\u13b9\u13f0\u13df \u13cd\u13c6\u13c2" },
            { "dz", "\u13d3\u13d0\u13c5\u13a7" },
            { "bez", "\u13c7\u13be" },
            { "type.ca.chinese", "\u13d3\u13b6\u13c2\u13a8\u13cd\u13db \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "dje", "\u13cc\u13b9" },
            { "type.nu.grek", "\u13a0\u13c2\u13aa\u13a2 \u13d7\u13ce\u13cd\u13d7" },
            { "ee", "\u13a1\u13ea" },
            { "type.lb.normal", "\u13f1\u13ac\u13cd\u13d7\u13ad\u13ca \u13a0\u13cd\u13d3\u13c5\u13c5 \u13a0\u13f2\u13cd\u13d4\u13c5\u13a9 \u13c2\u13da\u13cd\u13db" },
            { "ro_MD", "\u13b9\u13b5\u13d9\u13eb\u13a0 \u13e3\u13b9\u13c2\u13a0\u13c2" },
            { "el", "\u13a0\u13c2\u13aa\u13a2" },
            { "en", "\u13a9\u13b5\u13cf" },
            { "eo", "\u13a1\u13cd\u13c7\u13b3\u13c2\u13d9" },
            { "es", "\u13cd\u13c6\u13c2" },
            { "et", "\u13a1\u13cd\u13d9\u13c2\u13a0\u13c2" },
            { "Hanb", "\u13ad\u13c2 \u13be\u13bf \u13c6\u13c9\u13bc\u13ec" },
            { "eu", "\u13c6\u13cd\u13a8" },
            { "Hang", "\u13ad\u13c2\u13ab\u13b5" },
            { "shi", "\u13d4\u13e4\u13b5\u13af\u13d8" },
            { "hsb", "\u13a6\u13b8\u13b3\u13d7\u13a8 \u13d0\u13c8\u13a0\u13c2" },
            { "Hani", "\u13ad\u13c2" },
            { "shn", "\u13dd\u13c2" },
            { "fa", "\u13c7\u13cf\u13a0\u13c2" },
            { "Hans", "\u13a0\u13af\u13d7\u13a8" },
            { "type.nu.latn", "\u13ed\u13d7\u13b5\u13ac \u13d7\u13dc \u13d7\u13ce\u13cd\u13d7" },
            { "Hant", "\u13a4\u13e6\u13cd\u13d7" },
            { "ff", "\u13ca\u13b3\u13c2" },
            { "fi", "\u13c8\u13c2\u13cd" },
            { "fj", "\u13eb\u13e5\u13a0\u13c2" },
            { "fon", "\u13e0\u13c2" },
            { "yue", "\u13a8\u13be\u13d9\u13c2\u13cf" },
            { "fo", "\u13c7\u13b6\u13a1\u13cd" },
            { "umb", "\u13a4\u13b9\u13ca\u13c5\u13da" },
            { "fr", "\u13a6\u13b8\u13e5" },
            { "fy", "\u13ed\u13d5\u13b5\u13ac \u13d7\u13dc \u13df\u13cf\u13a0\u13c2" },
            { "ga", "\u13a8\u13b5\u13a9" },
            { "gd", "\u13cd\u13a6\u13d7 \u13a8\u13b5\u13a9" },
            { "gl", "\u13a6\u13b5\u13cf\u13a0\u13c2" },
            { "gn", "\u13c6\u13b3\u13c2" },
            { "bho", "\u13c9\u13e3\u13ca\u13b5" },
            { "und", "\u13c4\u13ec\u13b5\u13cd\u13db\u13be \u13a6\u13ec\u13c2\u13af\u13cd\u13d7" },
            { "gu", metaValue_gu },
            { "gv", "\u13b9\u13be\u13a7\u13cf" },
            { "ha", "\u13ad\u13a4\u13cc" },
            { "he", "\u13a0\u13c2\u13c8\u13b7" },
            { "hi", "\u13af\u13c2\u13d7" },
            { "hup", "\u13a0\u13c2\u13b1\u13c6" },
            { "bin", "\u13c8\u13c2" },
            { "hr", "\u13a7\u13b6\u13a1\u13cf\u13c2" },
            { "ht", "\u13ae\u13cf\u13a0\u13c2 \u13df\u13f2\u13b5" },
            { "hu", "\u13b2\u13c2\u13a6\u13b5\u13a0\u13c2" },
            { "hy", metaValue_hy },
            { "hz", "\u13ae\u13b4\u13b6" },
            { "ia", "\u13a0\u13f0\u13df \u13a6\u13ec\u13c2\u13af\u13cd\u13d7" },
            { "Jamo", "\u13e3\u13bc" },
            { "id", "\u13a2\u13c2\u13d9\u13c2\u13cf\u13a0" },
            { "type.nu.tibt", "\u13d8\u13c7\u13d4\u13c2 \u13d7\u13ce\u13cd\u13d7" },
            { "ig", "\u13a2\u13a6\u13aa" },
            { "ii", "\u13cf\u13e7\u13e9\u13c2 \u13f1" },
            { "io", "\u13a2\u13d9" },
            { "is", "\u13e7\u13c1\u13cd\u13d3\u13b8\u13af\u13a2\u13a9" },
            { "it", "\u13ac\u13e9\u13b5\u13f2\u13e5\u13a2" },
            { "iu", "\u13a2\u13c4\u13a6\u13d8\u13da" },
            { "ja", metaValue_JP },
            { "Mlym", metaValue_ml },
            { "sma", "\u13e7\u13a6\u13be\u13ee \u13d7\u13dc \u13cc\u13bb" },
            { "jv", "\u13c6\u13cc \u13e3\u13e9" },
            { "mad", "\u13b9\u13da\u13b4\u13cf" },
            { "smj", "\u13b7\u13b4 \u13cc\u13bb" },
            { "mag", "\u13b9\u13a6\u13af" },
            { "mai", "\u13b9\u13df\u13b5" },
            { "smn", "\u13a2\u13be\u13b5 \u13cc\u13bb" },
            { "ka", metaValue_ka },
            { "bla", "\u13cf\u13a9\u13cf\u13a7" },
            { "mak", "\u13b9\u13a7\u13cc" },
            { "sms", "\u13cd\u13aa\u13b5\u13d8 \u13cc\u13bb" },
            { "ki", "\u13a9\u13ab\u13f3" },
            { "mas", "\u13b9\u13cc\u13f1" },
            { "kj", "\u13ab\u13e9\u13c2\u13a0\u13b9" },
            { "kk", "\u13a7\u13cc\u13a7" },
            { "kl", "\u13a7\u13b3\u13b5\u13d1\u13d8" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u13a7\u13c4\u13b5" },
            { "ks", "\u13a7\u13cf\u13bb\u13b5" },
            { "ku", "\u13ab\u13d7\u13cf" },
            { "kv", "\u13aa\u13bb" },
            { "kw", "\u13ce\u13b7\u13ad" },
            { "ky", metaValue_KG },
            { "snk", "\u13d0\u13c2\u13c2\u13a8" },
            { "la", metaValue_la },
            { "lb", "\u13b8\u13a6\u13cf\u13bb\u13cb\u13a2\u13cd" },
            { "type.nu.mlym", "\u13b9\u13b3\u13ef\u13b3\u13bb \u13d7\u13ce\u13cd\u13d7" },
            { "lg", "\u13a6\u13c2\u13d3" },
            { "li", "\u13b4\u13b9\u13ca\u13b5\u13cf" },
            { "Tibt", metaValue_bo },
            { "ln", "\u13b5\u13c2\u13a6\u13b3" },
            { "fur", "\u13de\u13a4\u13b5\u13a0\u13c2" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u13c2\u13ac\u13be\u13db\u13a2 \u13a4\u13d3\u13e4\u13b5\u13a6\u13ef \u13a0\u13df\u13b6\u13db \u13c4\u13cd\u13d7\u13d3\u13c5\u13a2" },
            { "lt", "\u13b5\u13da\u13e9\u13c2\u13a0\u13c2" },
            { "lu", "\u13b7\u13c6-\u13a7\u13d4\u13a6" },
            { "lv", "\u13b3\u13d8\u13eb\u13a0\u13c2" },
            { "mg", "\u13b9\u13b3\u13a6\u13cf" },
            { "mh", "\u13b9\u13cc\u13b5\u13cf" },
            { "type.co.ducet", "\u13a0\u13d3\u13c1\u13df\u13f4\u13d7\u13cd\u13a9 Unicode \u13d7\u13a6\u13c5\u13c3\u13d9\u13d7 \u13d5\u13a6\u13c5\u13c3\u13db\u13a2" },
            { "mi", "\u13b9\u13eb" },
            { "mk", "\u13b9\u13ce\u13d9\u13c2\u13a0\u13c2" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "\u13b9\u13b3\u13d8" },
            { "ms", "\u13b9\u13b4" },
            { "mt", "\u13b9\u13b5\u13d8\u13cd" },
            { "my", "\u13cb\u13bb\u13cd" },
            { "Armn", metaValue_hy },
            { "mdf", "\u13bc\u13a7\u13cc" },
            { "dsb", "\u13a1\u13b3\u13d7 \u13d0\u13c8\u13a0\u13c2" },
            { "na", metaValue_NR },
            { "type.co.search", "\u13c2\u13a6\u13a5-\u13a2\u13f3\u13f1\u13b8\u13d7 \u13a0\u13f1\u13cd\u13d7" },
            { "nb", "\u13c3\u13b5\u13ea\u13e5\u13c2 \u13c9\u13a7\u13b9\u13b5" },
            { "nd", "\u13e7\u13f4\u13e2 \u13c2\u13d5\u13c7\u13b4" },
            { "ne", metaValue_NP },
            { "ng", "\u13be\u13d9\u13a6" },
            { "nl", "\u13db\u13e5" },
            { "nn", "\u13c3\u13b5\u13ea\u13e5\u13c2 \u13be\u13b5\u13cd\u13a9" },
            { "nr", "\u13e7\u13a6\u13be\u13ee \u13c2\u13d5\u13c7\u13b4" },
            { "nv", "\u13be\u13e9\u13b0" },
            { "ny", "\u13c2\u13ef\u13c2\u13e3" },
            { "kac", "\u13a7\u13e5\u13c2" },
            { "kab", "\u13a7\u13c8\u13b4" },
            { "oc", "\u13a0\u13cf\u13d4\u13c2" },
            { "kaj", "\u13e5\u13e7" },
            { "kam", "\u13a7\u13bb\u13c6" },
            { "men", "\u13ba\u13be\u13d5" },
            { "mer", "\u13ba\u13b7" },
            { "type.nu.armn", "\u13a0\u13b3\u13bb\u13a0\u13c2 \u13d7\u13ce\u13cd\u13d7" },
            { "om", "\u13a3\u13b6\u13bc" },
            { "or", metaValue_or },
            { "os", "\u13a3\u13ce\u13d8\u13a7" },
            { "kbd", "\u13a7\u13c6\u13d7\u13a0\u13c2" },
            { "mfe", "\u13bc\u13b5\u13cf\u13a1\u13c2" },
            { "srn", "\u13cf\u13b3\u13be\u13c2 \u13d9\u13c3\u13aa" },
            { "pa", "\u13e1\u13c2\u13e3\u13c8" },
            { "dua", "\u13da\u13a0\u13b3" },
            { "pl", "\u13c9\u13b5\u13cd" },
            { "type.ca.dangi", "\u13d3\u13c2\u13a9 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "ps", "\u13c6\u13cd\u13d9" },
            { "pt", "\u13c9\u13e7\u13a9\u13cd" },
            { "key.co", "\u13d7\u13a6\u13c5\u13c3\u13d9\u13d7 \u13d5\u13a6\u13c5\u13c3\u13db\u13a2" },
            { "pt_BR", "\u13c6\u13cf\u13b5\u13a2 \u13c9\u13e7\u13a9\u13cd" },
            { "kcg", "\u13d4\u13ef\u13c6" },
            { "mgh", "\u13b9\u13ab\u13e9-\u13bb\u13d9" },
            { "key.cf", "\u13a0\u13d5\u13b3 \u13f1\u13ac\u13c1\u13b8\u13af" },
            { "key.ca", "\u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u13ba\u13b3\u2019" },
            { "type.hc.h23", "24 \u13a2\u13f3\u13df\u13b6\u13d3 \u13c4\u13cd\u13d7\u13d3\u13c5\u13a2 (0\u201323)" },
            { "type.hc.h24", "24 \u13a2\u13f3\u13df\u13b6\u13d3 \u13c4\u13cd\u13d7\u13d3\u13c5\u13a2 (1\u201324)" },
            { "ssy", "\u13cc\u13b0" },
            { "type.nu.mymr", "\u13b9\u13ef\u13b9\u13b5 \u13d7\u13ce\u13cd\u13d7" },
            { "qu", "\u13a8\u13e7\u13e9" },
            { "brx", "\u13c9\u13d9" },
            { "kde", "\u13b9\u13aa\u13d5" },
            { "Ethi", "\u13a2\u13d7\u13ef\u13c8\u13a9" },
            { "type.hc.h12", "12 \u13a2\u13f3\u13df\u13b6\u13d3 \u13c4\u13cd\u13d7\u13d3\u13c5\u13a2 (1\u201312)" },
            { "type.hc.h11", "12 \u13a2\u13f3\u13df\u13b6\u13d3 \u13c4\u13cd\u13d7\u13d3\u13c5\u13a2 (0\u201311)" },
            { "rm", "\u13a0\u13c2\u13b6\u13ba\u13c2" },
            { "rn", "\u13b7\u13c2\u13d7" },
            { "key.cu", "\u13a0\u13d5\u13b3" },
            { "ro", "\u13b6\u13b9\u13c2\u13a0\u13c2" },
            { "type.nu.orya", "\u13a3\u13d7\u13a0 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.hanidec", "\u13d3\u13b6\u13c2\u13a8 \u13d5\u13cf\u13b9\u13b5 \u13d7\u13ce\u13cd\u13d7" },
            { "ru", "\u13f2\u13c5\u13af" },
            { "rw", "\u13a9\u13c2\u13ef\u13e9\u13c2\u13d3" },
            { "kea", "\u13a7\u13ca\u13ea\u13d7\u13a0\u13c4" },
            { "mic", "\u13bb\u13a7\u13b9\u13a9" },
            { "suk", "\u13d1\u13ab\u13b9" },
            { "en_AU", "\u13a1\u13b3\u13d7\u13dc \u13a9\u13b5\u13cf" },
            { "sa", "\u13cd\u13c2\u13cd\u13a9\u13d7" },
            { "sc", "\u13cc\u13d7\u13c2\u13a0\u13c2" },
            { "sd", "\u13cf\u13c2\u13d7" },
            { "se", "\u13e7\u13f4\u13e2 \u13d7\u13dc \u13cc\u13bb" },
            { "min", "\u13bb\u13be\u13a7\u13c6\u13a4" },
            { "sg", "\u13cc\u13c2\u13aa" },
            { "si", "\u13cf\u13be\u13ad\u13b3" },
            { "sk", "\u13cd\u13b6\u13e9\u13a9" },
            { "sl", "\u13cd\u13b6\u13eb\u13c2\u13a0\u13c2" },
            { "sm", "\u13cc\u13bc\u13ef\u13c2" },
            { "sn", "\u13e0\u13be" },
            { "so", metaValue_SO },
            { "type.nu.arab", "\u13a0\u13b3\u13c8-\u13a1\u13c2\u13d7\u13a9 \u13d7\u13ce\u13cd\u13d7" },
            { "sq", "\u13a0\u13b5\u13c7\u13c2" },
            { "sr", "\u13d2\u13c8\u13a0\u13c2" },
            { "ss", "\u13cd\u13e9\u13d8" },
            { "type.cf.account", "\u13a0\u13d5\u13b3 \u13d7\u13ce\u13af\u13af \u13a0\u13d5\u13b3 \u13f1\u13ac\u13c1\u13b8\u13af" },
            { "st", "\u13e7\u13a6\u13be\u13ee \u13d7\u13dc \u13d0\u13e0" },
            { "su", "\u13d1\u13c2\u13d3\u13c2\u13cf" },
            { "sv", "\u13cd\u13eb\u13d7\u13cf" },
            { "sw", "\u13cd\u13e9\u13af\u13b5" },
            { "type.nu.hantfin", "\u13a4\u13e6\u13cd\u13d7 \u13d3\u13b6\u13c2\u13a8 \u13a0\u13d5\u13b3 \u13d7\u13ce\u13cd\u13d7" },
            { "ibb", "\u13a2\u13c8\u13c8\u13a3" },
            { "iba", "\u13a2\u13c6\u13c2" },
            { "ta", metaValue_ta },
            { "142", "\u13d3\u13b6\u13be\u13a8\u13cd\u13db" },
            { "143", "\u13a0\u13f0\u13df \u13d3\u13b6\u13c2\u13a8\u13cd\u13db" },
            { "te", metaValue_te },
            { "145", "\u13ed\u13d5\u13b5\u13ac \u13d7\u13dc \u13d3\u13b6\u13c2\u13a8\u13cd\u13db" },
            { "tg", "\u13d4\u13e5\u13a9" },
            { "th", "\u13d4\u13f1" },
            { "ti", "\u13d8\u13a9\u13b5\u13c2\u13a0" },
            { "bug", "\u13c8\u13a5\u13a9\u13c2\u13cd" },
            { "kfo", "\u13aa\u13b6" },
            { "en_CA", "\u13a8\u13be\u13d3 \u13a9\u13b5\u13cf" },
            { "tk", "\u13a0\u13c2\u13ac\u13be" },
            { "tn", "\u13e7\u13e9\u13be" },
            { "to", "\u13d9\u13be\u13a6\u13c2" },
            { "dyo", "\u13e6\u13b3-\u13ec\u13f1" },
            { "type.nu.jpan", "\u13e3\u13c6\u13c2\u13cf \u13d7\u13ce\u13cd\u13d7" },
            { "tr", "\u13a0\u13ac\u13be" },
            { "ts", "\u13e6\u13be\u13a6" },
            { "swb", "\u13aa\u13bc\u13b5\u13a0\u13c2" },
            { "tt", "\u13d4\u13d4" },
            { "ty", "\u13d4\u13af\u13d8\u13a0\u13c2" },
            { "150", "\u13f3\u13b3\u13db" },
            { "151", "\u13d7\u13a7\u13b8\u13ac \u13d7\u13dc \u13f3\u13b3\u13db" },
            { "154", "\u13e7\u13f4\u13e2 \u13d7\u13dc \u13f3\u13b3\u13db" },
            { "dzg", "\u13d3\u13cc\u13a6" },
            { "155", "\u13ed\u13d5\u13b5\u13ac \u13d7\u13dc \u13f3\u13b3\u13db" },
            { "ug", "\u13eb\u13a6" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u13ef\u13c3\u13c9 \u13f1\u13ac\u13cd\u13db\u13ed" },
            { "uk", "\u13f3\u13a7\u13b4\u13c2\u13a0\u13c2" },
            { "ur", "\u13a4\u13b5\u13da" },
            { "xal", "\u13a7\u13b3\u13bb\u13a7" },
            { "uz", "\u13a4\u13cd\u13c7\u13a9" },
            { "kha", "\u13a7\u13cf" },
            { "nds_NL", "\u13a1\u13b3\u13d7 \u13c1\u13db\u13b3\u13c2" },
            { "ve", "\u13eb\u13c2\u13d3" },
            { "type.ca.roc", "\u13cd\u13a6\u13da\u13a9 \u13be\u13bf \u13d3\u13b6\u13c2\u13a8\u13cd\u13db \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "vi", "\u13eb\u13a1\u13d8\u13be\u13bb\u13cd" },
            { "khq", "\u13aa\u13f1\u13b3 \u13e5\u13c2" },
            { "key.hc", "\u13d1\u13df\u13b6\u13d3 \u13a0\u13d3\u13c1\u13df\u13f4\u13ce\u13ac (12 vs 24)" },
            { "vo", "\u13ec\u13b3\u13ca\u13a9" },
            { "quc", "\u13a9\u13e4" },
            { "gaa", "\u13a6" },
            { "wa", "\u13e9\u13b7\u13be" },
            { "syr", "\u13cf\u13b5\u13a0\u13a9" },
            { "Grek", "\u13aa\u13a2" },
            { "wo", "\u13ec\u13b6\u13eb" },
            { "zgh", "\u13a0\u13df\u13b6\u13cd\u13d7 \u13bc\u13b6\u13aa \u13d4\u13b9\u13cf\u13d8" },
            { "ar_001", "\u13aa\u13af\u13ca \u13a2\u13ac\u13e5\u13a9 \u13a0\u13df\u13b6\u13cd\u13d7 \u13a1\u13b3\u13c8" },
            { "Mong", metaValue_mn },
            { "mni", "\u13ba\u13c2\u13c9\u13b5" },
            { "Latn", metaValue_la },
            { "type.nu.hans", "\u13a0\u13af\u13d7\u13a8 \u13d3\u13b6\u13c2\u13a8 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.hant", "\u13a4\u13e6\u13cd\u13d7 \u13d3\u13b6\u13c2\u13a8 \u13d7\u13ce\u13cd\u13d7" },
            { "xh", "\u13e0\u13cc" },
            { "type.nu.romanlow", "\u13a0\u13c2\u13b6\u13bb \u13e7\u13cd\u13d7 \u13d7\u13aa\u13ea\u13b5 \u13d7\u13ce\u13cd\u13d7" },
            { "byn", "\u13df\u13c2" },
            { "moh", "\u13bc\u13ad\u13a9" },
            { "kkj", "\u13a7\u13aa" },
            { "yi", "\u13f1\u13d7\u13cd" },
            { "mos", "\u13bc\u13cd\u13cf" },
            { "yo", "\u13f2\u13c4\u13c6" },
            { "es_MX", "\u13cd\u13c6\u13c2\u13f1 \u13cd\u13c6\u13c2" },
            { "vai", "\u13e9\u13f1" },
            { "kln", "\u13a7\u13b4\u13c2\u13e5\u13c2" },
            { "zh", "\u13d3\u13b6\u13c2\u13a8" },
            { "Bopo", "\u13c6\u13c9\u13bc\u13ec" },
            { "key.lb", "\u13a0\u13cd\u13d3\u13c5\u13c5 \u13a0\u13f2\u13cd\u13d4\u13c5\u13a9 \u13c2\u13da\u13cd\u13db" },
            { "zu", "\u13d1\u13b7" },
            { "Geor", metaValue_ka },
            { "kmb", "\u13a9\u13bb\u13ca\u13da" },
            { "type.nu.jpanfin", "\u13e3\u13c6\u13c2\u13cf \u13a0\u13d5\u13b3 \u13d7\u13ce\u13cd\u13d7" },
            { "gez", "\u13a9\u13cf" },
            { "ebu", "\u13a1\u13bb\u13ca" },
            { "zh_Hans", "\u13a0\u13af\u13d7\u13a8 \u13d3\u13b6\u13c2\u13a8" },
            { "kok", "\u13a7\u13c2\u13a7\u13c2" },
            { "zh_Hant", "\u13a4\u13e6\u13cd\u13d7 \u13d3\u13b6\u13c2\u13a8" },
            { "kpe", "\u13c7\u13b4" },
            { "type.nu.khmr", "\u13a9\u13bb\u13b7 \u13d7\u13ce\u13cd\u13d7" },
            { "ilo", "\u13a2\u13b6\u13aa" },
            { "mua", "\u13bd\u13c2\u13d3\u13a9" },
            { "type.nu.guru", "\u13ac\u13b9\u13a9 \u13d7\u13ce\u13cd\u13d7" },
            { "mul", "\u13e7\u13c8\u13cd\u13d7 \u13d7\u13a6\u13ec\u13c2\u13af\u13cd\u13d7" },
            { "key.ms", "\u13a0\u13df\u13b6\u13db \u13c4\u13cd\u13d7\u13d3\u13c5\u13a2" },
            { "mus", "\u13a0\u13ab\u13cc" },
            { "gil", "\u13a9\u13c7\u13d8\u13cf" },
            { "Cher", metaValue_chr },
            { "cay", "\u13a7\u13f3\u13a6" },
            { "type.nu.tamldec", "\u13d4\u13bb\u13b5 \u13d7\u13ce\u13cd\u13d7" },
            { "krc", "\u13a7\u13b3\u13e3\u13f1-\u13c6\u13b5\u13a7\u13b5" },
            { "inh", "\u13a2\u13c2\u13ab\u13cf" },
            { "fa_AF", "\u13d3\u13b5" },
            { "krl", "\u13a7\u13b4\u13b5\u13a0\u13c2" },
            { "efi", "\u13a1\u13eb\u13a9" },
            { "key.nu", "\u13d7\u13ce\u13cd\u13d7" },
            { "kru", "\u13ab\u13b7\u13a9" },
            { "ksb", "\u13dd\u13bb\u13c6\u13b8" },
            { "Telu", metaValue_te },
            { "ksf", "\u13c6\u13eb\u13a0" },
        };
        return data;
    }
}
