/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.obr.internal;

import java.net.MalformedURLException;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.url.obr.internal.FilterValidator;

class Parser {
    private static final String SYNTAX = "obr:<bundle-symbolic-name>['/'<bundle-version>]";
    private final String m_filter;

    public Parser(String path, FilterValidator filterValidator) throws MalformedURLException {
        NullArgumentException.validateNotNull(filterValidator, "Filter validator");
        if (path == null || path.trim().length() == 0) {
            throw new MalformedURLException("Path cannot be null or empty. Syntax obr:<bundle-symbolic-name>['/'<bundle-version>]");
        }
        String[] segments = path.split("/");
        if (segments.length > 2) {
            throw new MalformedURLException("Path canot contain more then one '/'. Syntax  obr:<bundle-symbolic-name>['/'<bundle-version>]");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("(symbolicname=").append(segments[0]).append(")");
        if (!filterValidator.validate(builder.toString())) {
            throw new MalformedURLException("Invalid symbolic name value.");
        }
        if (segments.length > 1) {
            builder.insert(0, "(&").append("(version=").append(segments[1]).append("))");
            if (!filterValidator.validate(builder.toString())) {
                throw new MalformedURLException("Invalid version value.");
            }
        }
        this.m_filter = builder.toString();
    }

    public String getFilter() {
        return this.m_filter;
    }
}

