/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.DiffableUtils;
import org.opensearch.cluster.NamedDiff;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.QueryGroup;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class QueryGroupMetadata
implements Metadata.Custom {
    public static final String TYPE = "queryGroups";
    private static final ParseField QUERY_GROUP_FIELD = new ParseField("queryGroups", new String[0]);
    private final Map<String, QueryGroup> queryGroups;

    public QueryGroupMetadata(Map<String, QueryGroup> queryGroups) {
        this.queryGroups = queryGroups;
    }

    public QueryGroupMetadata(StreamInput in) throws IOException {
        this.queryGroups = in.readMap(StreamInput::readString, QueryGroup::new);
    }

    public Map<String, QueryGroup> queryGroups() {
        return this.queryGroups;
    }

    public String getWriteableName() {
        return TYPE;
    }

    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.queryGroups, StreamOutput::writeString, (stream, val) -> val.writeTo(stream));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Map.Entry<String, QueryGroup> entry : this.queryGroups.entrySet()) {
            builder.field(entry.getKey(), (ToXContent)entry.getValue());
        }
        return builder;
    }

    public static QueryGroupMetadata fromXContent(XContentParser parser) throws IOException {
        HashMap<String, QueryGroup> queryGroupMap = new HashMap<String, QueryGroup>();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("QueryGroupMetadata.fromXContent was expecting a { token but found : " + String.valueOf(parser.currentToken()));
        }
        XContentParser.Token token = parser.currentToken();
        String fieldName = parser.currentName();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            QueryGroup queryGroup = QueryGroup.fromXContent(parser);
            queryGroupMap.put(fieldName, queryGroup);
        }
        return new QueryGroupMetadata(queryGroupMap);
    }

    @Override
    public Diff<Metadata.Custom> diff(Metadata.Custom previousState) {
        return new QueryGroupMetadataDiff((QueryGroupMetadata)previousState, this);
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new QueryGroupMetadataDiff(in);
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryGroupMetadata that = (QueryGroupMetadata)o;
        return Objects.equals(this.queryGroups, that.queryGroups);
    }

    public int hashCode() {
        return Objects.hash(this.queryGroups);
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    static class QueryGroupMetadataDiff
    implements NamedDiff<Metadata.Custom> {
        final Diff<Map<String, QueryGroup>> dataStreamDiff;

        QueryGroupMetadataDiff(QueryGroupMetadata before, QueryGroupMetadata after) {
            this.dataStreamDiff = DiffableUtils.diff(before.queryGroups, after.queryGroups, DiffableUtils.getStringKeySerializer());
        }

        QueryGroupMetadataDiff(StreamInput in) throws IOException {
            this.dataStreamDiff = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), QueryGroup::new, QueryGroup::readDiff);
        }

        public String getWriteableName() {
            return QueryGroupMetadata.TYPE;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.dataStreamDiff.writeTo(out);
        }

        @Override
        public Metadata.Custom apply(Metadata.Custom part) {
            return new QueryGroupMetadata(new HashMap<String, QueryGroup>(this.dataStreamDiff.apply(((QueryGroupMetadata)part).queryGroups)));
        }
    }
}

