/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.stats.CommonStatsFlags;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexingPressure;
import org.opensearch.index.ShardIndexingPressureMemoryManager;
import org.opensearch.index.ShardIndexingPressureSettings;
import org.opensearch.index.ShardIndexingPressureTracker;
import org.opensearch.index.stats.IndexingPressurePerShardStats;
import org.opensearch.index.stats.ShardIndexingPressureStats;

public class ShardIndexingPressure
extends IndexingPressure {
    private static final Logger logger = LogManager.getLogger(ShardIndexingPressure.class);
    private final ShardIndexingPressureSettings shardIndexingPressureSettings;
    private final ShardIndexingPressureMemoryManager memoryManager;

    ShardIndexingPressure(Settings settings, ClusterService clusterService) {
        super(settings);
        this.shardIndexingPressureSettings = new ShardIndexingPressureSettings(clusterService, settings, this.primaryAndCoordinatingLimits);
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        this.memoryManager = new ShardIndexingPressureMemoryManager(this.shardIndexingPressureSettings, clusterSettings, settings);
    }

    public Releasable markCoordinatingOperationStarted(ShardId shardId, long bytes, boolean forceExecution) {
        if (0L == bytes) {
            return () -> {};
        }
        long requestStartTime = System.nanoTime();
        ShardIndexingPressureTracker tracker = this.getShardIndexingPressureTracker(shardId);
        long nodeCombinedBytes = this.currentCombinedCoordinatingAndPrimaryBytes.addAndGet(bytes);
        long nodeReplicaBytes = this.currentReplicaBytes.get();
        long nodeTotalBytes = nodeCombinedBytes + nodeReplicaBytes;
        long shardCombinedBytes = tracker.getCommonOperationTracker().incrementCurrentCombinedCoordinatingAndPrimaryBytes(bytes);
        boolean shardLevelLimitBreached = false;
        if (!forceExecution) {
            boolean nodeLevelLimitBreached = this.memoryManager.isCoordinatingNodeLimitBreached(tracker, nodeTotalBytes);
            if (!nodeLevelLimitBreached) {
                shardLevelLimitBreached = this.memoryManager.isCoordinatingShardLimitBreached(tracker, nodeTotalBytes, requestStartTime);
            }
            if (this.shouldRejectRequest(nodeLevelLimitBreached, shardLevelLimitBreached)) {
                this.coordinatingRejections.getAndIncrement();
                this.currentCombinedCoordinatingAndPrimaryBytes.addAndGet(-bytes);
                tracker.getCommonOperationTracker().incrementCurrentCombinedCoordinatingAndPrimaryBytes(-bytes);
                this.rejectShardRequest(tracker, bytes, nodeTotalBytes, shardCombinedBytes, tracker.getCoordinatingOperationTracker().getRejectionTracker(), "coordinating");
            }
        }
        this.currentCoordinatingBytes.addAndGet(bytes);
        this.totalCombinedCoordinatingAndPrimaryBytes.addAndGet(bytes);
        this.totalCoordinatingBytes.addAndGet(bytes);
        ShardIndexingPressureTracker.StatsTracker statsTracker = tracker.getCoordinatingOperationTracker().getStatsTracker();
        statsTracker.incrementCurrentBytes(bytes);
        this.markShardOperationStarted(statsTracker, tracker.getCoordinatingOperationTracker().getPerformanceTracker());
        boolean isShadowModeBreach = shardLevelLimitBreached;
        return ShardIndexingPressure.wrapReleasable(() -> {
            this.currentCombinedCoordinatingAndPrimaryBytes.addAndGet(-bytes);
            this.currentCoordinatingBytes.addAndGet(-bytes);
            this.markShardOperationComplete(bytes, requestStartTime, isShadowModeBreach, tracker.getCoordinatingOperationTracker(), tracker.getCommonOperationTracker());
            this.memoryManager.decreaseShardPrimaryAndCoordinatingLimits(tracker);
            this.tryReleaseTracker(tracker);
        });
    }

    public Releasable markPrimaryOperationLocalToCoordinatingNodeStarted(ShardId shardId, long bytes) {
        if (bytes == 0L) {
            return () -> {};
        }
        ShardIndexingPressureTracker tracker = this.getShardIndexingPressureTracker(shardId);
        this.currentPrimaryBytes.addAndGet(bytes);
        this.totalPrimaryBytes.addAndGet(bytes);
        tracker.getPrimaryOperationTracker().getStatsTracker().incrementCurrentBytes(bytes);
        tracker.getPrimaryOperationTracker().getStatsTracker().incrementTotalBytes(bytes);
        return ShardIndexingPressure.wrapReleasable(() -> {
            this.currentPrimaryBytes.addAndGet(-bytes);
            tracker.getPrimaryOperationTracker().getStatsTracker().incrementCurrentBytes(-bytes);
        });
    }

    public Releasable markPrimaryOperationStarted(ShardId shardId, long bytes, boolean forceExecution) {
        if (0L == bytes) {
            return () -> {};
        }
        long requestStartTime = System.nanoTime();
        ShardIndexingPressureTracker tracker = this.getShardIndexingPressureTracker(shardId);
        long nodeCombinedBytes = this.currentCombinedCoordinatingAndPrimaryBytes.addAndGet(bytes);
        long nodeReplicaBytes = this.currentReplicaBytes.get();
        long nodeTotalBytes = nodeCombinedBytes + nodeReplicaBytes;
        long shardCombinedBytes = tracker.getCommonOperationTracker().incrementCurrentCombinedCoordinatingAndPrimaryBytes(bytes);
        boolean shardLevelLimitBreached = false;
        if (!forceExecution) {
            boolean nodeLevelLimitBreached = this.memoryManager.isPrimaryNodeLimitBreached(tracker, nodeTotalBytes);
            if (!nodeLevelLimitBreached) {
                shardLevelLimitBreached = this.memoryManager.isPrimaryShardLimitBreached(tracker, nodeTotalBytes, requestStartTime);
            }
            if (this.shouldRejectRequest(nodeLevelLimitBreached, shardLevelLimitBreached)) {
                this.primaryRejections.getAndIncrement();
                this.currentCombinedCoordinatingAndPrimaryBytes.addAndGet(-bytes);
                tracker.getCommonOperationTracker().incrementCurrentCombinedCoordinatingAndPrimaryBytes(-bytes);
                this.rejectShardRequest(tracker, bytes, nodeTotalBytes, shardCombinedBytes, tracker.getPrimaryOperationTracker().getRejectionTracker(), "primary");
            }
        }
        this.currentPrimaryBytes.addAndGet(bytes);
        this.totalCombinedCoordinatingAndPrimaryBytes.addAndGet(bytes);
        this.totalPrimaryBytes.addAndGet(bytes);
        ShardIndexingPressureTracker.StatsTracker statsTracker = tracker.getPrimaryOperationTracker().getStatsTracker();
        statsTracker.incrementCurrentBytes(bytes);
        this.markShardOperationStarted(statsTracker, tracker.getPrimaryOperationTracker().getPerformanceTracker());
        boolean isShadowModeBreach = shardLevelLimitBreached;
        return ShardIndexingPressure.wrapReleasable(() -> {
            this.currentCombinedCoordinatingAndPrimaryBytes.addAndGet(-bytes);
            this.currentPrimaryBytes.addAndGet(-bytes);
            this.markShardOperationComplete(bytes, requestStartTime, isShadowModeBreach, tracker.getPrimaryOperationTracker(), tracker.getCommonOperationTracker());
            this.memoryManager.decreaseShardPrimaryAndCoordinatingLimits(tracker);
            this.tryReleaseTracker(tracker);
        });
    }

    public Releasable markReplicaOperationStarted(ShardId shardId, long bytes, boolean forceExecution) {
        if (0L == bytes) {
            return () -> {};
        }
        long requestStartTime = System.nanoTime();
        ShardIndexingPressureTracker tracker = this.getShardIndexingPressureTracker(shardId);
        long nodeReplicaBytes = this.currentReplicaBytes.addAndGet(bytes);
        long shardReplicaBytes = tracker.getReplicaOperationTracker().getStatsTracker().incrementCurrentBytes(bytes);
        boolean shardLevelLimitBreached = false;
        if (!forceExecution) {
            boolean nodeLevelLimitBreached = this.memoryManager.isReplicaNodeLimitBreached(tracker, nodeReplicaBytes);
            if (!nodeLevelLimitBreached) {
                shardLevelLimitBreached = this.memoryManager.isReplicaShardLimitBreached(tracker, nodeReplicaBytes, requestStartTime);
            }
            if (this.shouldRejectRequest(nodeLevelLimitBreached, shardLevelLimitBreached)) {
                this.replicaRejections.getAndIncrement();
                this.currentReplicaBytes.addAndGet(-bytes);
                tracker.getReplicaOperationTracker().getStatsTracker().incrementCurrentBytes(-bytes);
                this.rejectShardRequest(tracker, bytes, nodeReplicaBytes, shardReplicaBytes, tracker.getReplicaOperationTracker().getRejectionTracker(), "replica");
            }
        }
        this.totalReplicaBytes.addAndGet(bytes);
        ShardIndexingPressureTracker.StatsTracker statsTracker = tracker.getReplicaOperationTracker().getStatsTracker();
        this.markShardOperationStarted(statsTracker, tracker.getReplicaOperationTracker().getPerformanceTracker());
        boolean isShadowModeBreach = shardLevelLimitBreached;
        return ShardIndexingPressure.wrapReleasable(() -> {
            this.currentReplicaBytes.addAndGet(-bytes);
            this.markShardOperationComplete(bytes, requestStartTime, isShadowModeBreach, tracker.getReplicaOperationTracker());
            this.memoryManager.decreaseShardReplicaLimits(tracker);
            this.tryReleaseTracker(tracker);
        });
    }

    private static Releasable wrapReleasable(Releasable releasable) {
        AtomicBoolean called = new AtomicBoolean();
        return () -> {
            if (called.compareAndSet(false, true)) {
                releasable.close();
            } else {
                logger.error("ShardIndexingPressure Release is called twice", (Throwable)new IllegalStateException("Releasable is called twice"));
                assert (false) : "ShardIndexingPressure Release is called twice";
            }
        };
    }

    private boolean shouldRejectRequest(boolean nodeLevelLimitBreached, boolean shardLevelLimitBreached) {
        return nodeLevelLimitBreached || shardLevelLimitBreached && this.shardIndexingPressureSettings.isShardIndexingPressureEnforced();
    }

    private void markShardOperationStarted(ShardIndexingPressureTracker.StatsTracker statsTracker, ShardIndexingPressureTracker.PerformanceTracker performanceTracker) {
        statsTracker.incrementRequestCount();
        performanceTracker.incrementTotalOutstandingRequests();
    }

    private void adjustPerformanceUponCompletion(long bytes, long requestStartTime, ShardIndexingPressureTracker.StatsTracker statsTracker, ShardIndexingPressureTracker.PerformanceTracker performanceTracker) {
        long requestEndTime = System.nanoTime();
        long requestLatency = TimeUnit.NANOSECONDS.toMillis(requestEndTime - requestStartTime);
        performanceTracker.addLatencyInMillis(requestLatency);
        performanceTracker.updateLastSuccessfulRequestTimestamp(requestEndTime);
        performanceTracker.resetTotalOutstandingRequests();
        if (requestLatency > 0L) {
            this.calculateRequestThroughput(bytes, requestLatency, performanceTracker, statsTracker);
        }
    }

    private void calculateRequestThroughput(long bytes, long requestLatency, ShardIndexingPressureTracker.PerformanceTracker performanceTracker, ShardIndexingPressureTracker.StatsTracker statsTracker) {
        double requestThroughput = (double)bytes / (double)requestLatency;
        performanceTracker.addNewThroughout(requestThroughput);
        if (performanceTracker.getThroughputMovingQueueSize() > (long)this.shardIndexingPressureSettings.getRequestSizeWindow()) {
            double front = performanceTracker.getFirstThroughput();
            double movingAverage = this.memoryManager.calculateMovingAverage(performanceTracker.getThroughputMovingAverage(), front, requestThroughput, this.shardIndexingPressureSettings.getRequestSizeWindow());
            performanceTracker.updateThroughputMovingAverage(Double.doubleToLongBits(movingAverage));
        } else {
            double movingAverage = (double)statsTracker.getTotalBytes() / (double)performanceTracker.getLatencyInMillis();
            performanceTracker.updateThroughputMovingAverage(Double.doubleToLongBits(movingAverage));
        }
    }

    private void markShardOperationComplete(long bytes, long requestStartTime, boolean isShadowModeBreach, ShardIndexingPressureTracker.OperationTracker operationTracker, ShardIndexingPressureTracker.CommonOperationTracker commonOperationTracker) {
        commonOperationTracker.incrementCurrentCombinedCoordinatingAndPrimaryBytes(-bytes);
        commonOperationTracker.incrementTotalCombinedCoordinatingAndPrimaryBytes(bytes);
        this.markShardOperationComplete(bytes, requestStartTime, isShadowModeBreach, operationTracker);
    }

    private void markShardOperationComplete(long bytes, long requestStartTime, boolean isShadowModeBreach, ShardIndexingPressureTracker.OperationTracker operationTracker) {
        ShardIndexingPressureTracker.StatsTracker statsTracker = operationTracker.getStatsTracker();
        statsTracker.incrementCurrentBytes(-bytes);
        statsTracker.incrementTotalBytes(bytes);
        if (!isShadowModeBreach) {
            this.adjustPerformanceUponCompletion(bytes, requestStartTime, statsTracker, operationTracker.getPerformanceTracker());
        }
    }

    private void tryReleaseTracker(ShardIndexingPressureTracker tracker) {
        this.memoryManager.tryTrackerCleanupFromHotStore(tracker, () -> tracker.getCommonOperationTracker().getCurrentCombinedCoordinatingAndPrimaryBytes() == 0L && tracker.getReplicaOperationTracker().getStatsTracker().getCurrentBytes() == 0L);
    }

    private void rejectShardRequest(ShardIndexingPressureTracker tracker, long bytes, long nodeTotalBytes, long shardTotalBytes, ShardIndexingPressureTracker.RejectionTracker rejectionTracker, String operationType) {
        long nodeBytesWithoutOperation = nodeTotalBytes - bytes;
        long shardBytesWithoutOperation = shardTotalBytes - bytes;
        ShardId shardId = tracker.getShardId();
        rejectionTracker.incrementTotalRejections();
        throw new OpenSearchRejectedExecutionException("rejected execution of " + operationType + " operation [shard_detail=[" + shardId.getIndexName() + "][" + shardId.id() + "], shard_total_bytes=" + shardBytesWithoutOperation + ", shard_operation_bytes=" + bytes + ", shard_max_coordinating_and_primary_bytes=" + tracker.getPrimaryAndCoordinatingLimits() + ", shard_max_replica_bytes=" + tracker.getReplicaLimits() + "] OR [node_total_bytes=" + nodeBytesWithoutOperation + ", node_operation_bytes=" + bytes + ", node_max_coordinating_and_primary_bytes=" + this.primaryAndCoordinatingLimits + ", node_max_replica_bytes=" + this.replicaLimits + "]", false);
    }

    public ShardIndexingPressureStats shardStats(CommonStatsFlags statsFlags) {
        if (statsFlags.includeOnlyTopIndexingPressureMetrics()) {
            return this.topStats();
        }
        ShardIndexingPressureStats allStats = this.shardStats();
        if (statsFlags.includeAllShardIndexingPressureTrackers()) {
            allStats.addAll(this.coldStats());
        }
        return allStats;
    }

    ShardIndexingPressureStats shardStats() {
        HashMap<ShardId, IndexingPressurePerShardStats> statsPerShard = new HashMap<ShardId, IndexingPressurePerShardStats>();
        boolean isEnforcedMode = this.shardIndexingPressureSettings.isShardIndexingPressureEnforced();
        for (Map.Entry<ShardId, ShardIndexingPressureTracker> shardEntry : this.memoryManager.getShardIndexingPressureHotStore().entrySet()) {
            IndexingPressurePerShardStats shardStats = new IndexingPressurePerShardStats(shardEntry.getValue(), isEnforcedMode);
            statsPerShard.put(shardEntry.getKey(), shardStats);
        }
        return new ShardIndexingPressureStats(statsPerShard, this.memoryManager.getTotalNodeLimitsBreachedRejections(), this.memoryManager.getTotalLastSuccessfulRequestLimitsBreachedRejections(), this.memoryManager.getTotalThroughputDegradationLimitsBreachedRejections(), this.shardIndexingPressureSettings.isShardIndexingPressureEnabled(), isEnforcedMode);
    }

    ShardIndexingPressureStats coldStats() {
        HashMap<ShardId, IndexingPressurePerShardStats> statsPerShard = new HashMap<ShardId, IndexingPressurePerShardStats>();
        boolean isEnforcedMode = this.shardIndexingPressureSettings.isShardIndexingPressureEnforced();
        for (Map.Entry<ShardId, ShardIndexingPressureTracker> shardEntry : this.memoryManager.getShardIndexingPressureColdStore().entrySet()) {
            IndexingPressurePerShardStats shardStats = new IndexingPressurePerShardStats(shardEntry.getValue(), isEnforcedMode);
            statsPerShard.put(shardEntry.getKey(), shardStats);
        }
        return new ShardIndexingPressureStats(statsPerShard, this.memoryManager.getTotalNodeLimitsBreachedRejections(), this.memoryManager.getTotalLastSuccessfulRequestLimitsBreachedRejections(), this.memoryManager.getTotalThroughputDegradationLimitsBreachedRejections(), this.shardIndexingPressureSettings.isShardIndexingPressureEnabled(), isEnforcedMode);
    }

    ShardIndexingPressureStats topStats() {
        return new ShardIndexingPressureStats(Collections.emptyMap(), this.memoryManager.getTotalNodeLimitsBreachedRejections(), this.memoryManager.getTotalLastSuccessfulRequestLimitsBreachedRejections(), this.memoryManager.getTotalThroughputDegradationLimitsBreachedRejections(), this.shardIndexingPressureSettings.isShardIndexingPressureEnabled(), this.shardIndexingPressureSettings.isShardIndexingPressureEnforced());
    }

    ShardIndexingPressureTracker getShardIndexingPressureTracker(ShardId shardId) {
        return this.memoryManager.getShardIndexingPressureTracker(shardId);
    }

    public boolean isShardIndexingPressureEnabled() {
        return this.shardIndexingPressureSettings.isShardIndexingPressureEnabled();
    }
}

