/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.module.ModuleActivator;
import de.virtimo.bpc.module.monitor.MonitorModule;
import de.virtimo.bpc.module.monitor.api.service.MonitorService;
import de.virtimo.bpc.module.monitor.service.MonitorServiceImpl;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class MonitorActivator
extends ModuleActivator {
    private static final Logger LOG = Logger.getLogger(MonitorActivator.class.getName());
    private ServiceRegistration<MonitorService> monitorServiceRegistration;

    public MonitorActivator() {
        LOG.info("********** MonitorActivator **********");
    }

    public Class<? extends Module> getBpcModuleClass() {
        return MonitorModule.class;
    }

    public void start(BundleContext context) throws Exception {
        LOG.warning(context.getBundle().getSymbolicName() + ": START");
        super.start(context);
        long startTimestamp = System.currentTimeMillis();
        try {
            this.monitorServiceRegistration = context.registerService(MonitorService.class, (Object)new MonitorServiceImpl(context), null);
        }
        catch (Throwable t) {
            this.cleanup(context);
            throw t;
        }
        finally {
            LOG.info(context.getBundle().getSymbolicName() + ": STARTED in " + TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTimestamp) + " seconds");
        }
    }

    public void stop(BundleContext context) throws Exception {
        LOG.warning(context.getBundle().getSymbolicName() + ": STOP");
        super.stop(context);
        this.cleanup(context);
        LOG.info(context.getBundle().getSymbolicName() + ": STOPPED");
    }

    private void cleanup(BundleContext context) {
        LOG.info("cleanup context=" + context);
        BpcService.unregister((BundleContext)context, this.monitorServiceRegistration, MonitorService.class);
    }
}

