/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.auth.idp.PasswordValidator;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.util.StringUtil;
import java.util.logging.Logger;

public class PasswordValidatorImpl
implements PasswordValidator {
    private static final Logger LOG = Logger.getLogger(PasswordValidatorImpl.class.getName());
    private final String passwordPattern;

    public PasswordValidatorImpl(String passwordPattern) {
        this.passwordPattern = passwordPattern;
    }

    public PasswordValidatorImpl(IdentityProviderConfiguration idpConfiguration) {
        this.passwordPattern = idpConfiguration == null ? null : idpConfiguration.getPasswordValidationRegExp();
    }

    @Override
    public boolean isValid(String password) {
        LOG.info("isValid password=...");
        if (StringUtil.isNullOrEmpty(password)) {
            return false;
        }
        if (!StringUtil.isNullOrEmpty(this.passwordPattern)) {
            LOG.info("Using the password pattern: " + this.passwordPattern);
            return password.matches(this.passwordPattern);
        }
        LOG.info("No password pattern set.");
        return true;
    }
}

