/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.backup;

import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.backup.BackupJob;
import de.virtimo.bpc.api.backup.SnapshotName;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.CoreModule;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class BackupJobImpl
implements BackupJob {
    private static final Logger LOG = Logger.getLogger(BackupJobImpl.class.getName());
    private final BundleContext bundleContext;
    private final String backupJobIdentifier;
    private final BackupSetting backupSetting;
    private long timestampOfLatestBackup;

    public BackupJobImpl(BundleContext bundleContext, String backupJobIdentifier, BackupSetting backupSetting) {
        this.bundleContext = bundleContext;
        this.backupJobIdentifier = backupJobIdentifier;
        this.backupSetting = backupSetting;
        this.timestampOfLatestBackup = -1L;
    }

    @Override
    public String getBackupJobIdentifier() {
        return this.backupJobIdentifier;
    }

    @Override
    public BackupSetting getBackupSetting() {
        return this.backupSetting;
    }

    @Override
    public SnapshotName createNewSnapshotName() {
        return SnapshotName.createForName(this.backupSetting.getIndicesToBackupNamesAsKey());
    }

    @Override
    public String getSnapshotNamePrefix() {
        return SnapshotName.createForName(this.backupSetting.getIndicesToBackupNamesAsKey()).getPrefix();
    }

    @Override
    public long getTimestampOfLastestBackup() {
        return this.timestampOfLatestBackup;
    }

    @Override
    public void setTimestampOfLatestBackup(long timestampOfLatestBackup) {
        this.timestampOfLatestBackup = timestampOfLatestBackup;
    }

    @Override
    public long getTimestampOfNextBackup() {
        return this.timestampOfLatestBackup <= 0L ? -1L : this.getTimestampOfLastestBackup() + this.backupSetting.getIntervalInSeconds() * 1000L;
    }

    @Override
    public boolean isItTimeToCreateABackup() {
        if (this.timestampOfLatestBackup <= 0L) {
            return true;
        }
        return this.timestampOfLatestBackup < System.currentTimeMillis() - this.backupSetting.getIntervalInSeconds() * 1000L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupJobImpl backupJob = (BackupJobImpl)o;
        return Objects.equals(this.backupJobIdentifier, backupJob.backupJobIdentifier) && Objects.equals(this.backupSetting, backupJob.backupSetting);
    }

    public int hashCode() {
        return Objects.hash(this.backupJobIdentifier);
    }

    public String toString() {
        return "BackupJobImpl{bundleContext=" + this.bundleContext + ", backupJobIdentifier='" + this.backupJobIdentifier + "', backupSetting=" + this.backupSetting + ", timestampOfLatestBackup=" + this.timestampOfLatestBackup + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.info(this.backupJobIdentifier + ": BackupJob start");
        long startTime = System.currentTimeMillis();
        BpcServicesTracker<ModuleManager> moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        BpcServicesTracker<BackupManager> backupManagerTracker = new BpcServicesTracker<BackupManager>(this.bundleContext, BackupManager.class);
        try (BpcServicesTracker<BackupManager> bpcServicesTracker = backupManagerTracker;
             BpcServicesTracker<ModuleManager> bpcServicesTracker2 = moduleManagerTracker;){
            ModuleManager moduleManager = moduleManagerTracker.getService();
            BackupManager backupManager = backupManagerTracker.getService();
            CoreModule coreModule = moduleManager.getModuleByClass(CoreModule.class);
            if (coreModule.isMaintenanceModeEnabled()) {
                LOG.info(this.backupJobIdentifier + ": Skipping backup job execution .... maintenance mode is enabled");
                return;
            }
            backupManager.createBackupForBackupJob(this);
        }
        catch (ServiceNotFoundException ex) {
            LOG.log(Level.SEVERE, this.backupJobIdentifier + ": Failed to perform the backup job without the required services.", ex);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, this.backupJobIdentifier + ": Failed to perform the backup job.", ex);
        }
        finally {
            LOG.info(this.backupJobIdentifier + ": BackupJob finished in " + (System.currentTimeMillis() - startTime) + " ms");
        }
    }
}

