/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.datalock.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.datalock.DataLockService;
import de.virtimo.bpc.jaxrs.ApiResponse;
import de.virtimo.bpc.jaxrs.ApiResponses;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.search.SearchResponse;
import org.osgi.framework.BundleContext;

@Path(value="datalock")
public class DatalockEndpoints {
    private static final Logger LOG = Logger.getLogger(DatalockEndpoints.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<DataLockService> dataLockServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public DatalockEndpoints(BundleContext bundleContext) {
        LOG.info("DatalockEndpoints bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.dataLockServiceTracker = new BpcServicesTracker<DataLockService>(this.bundleContext, DataLockService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response getAllItems(@QueryParam(value="start") @DefaultValue(value="0") Integer start, @QueryParam(value="limit") @DefaultValue(value="1000") Integer limit) {
        LOG.info("getAllItems start=" + start + ", limit=" + limit);
        try {
            DataLockService dataLockService = this.dataLockServiceTracker.getService();
            SearchResponse searchResponse = dataLockService.getAllItems(start, limit);
            String jsonString = searchResponse.toString();
            return Response.ok((Object)jsonString, (String)"application/json").build();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "get all items failed", e);
            return ErrorResponse.forException(e).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/{itemId}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response getItem(@PathParam(value="itemId") String itemId) {
        LOG.info("getItem itemId=" + itemId);
        try {
            DataLockService dataLockService = this.dataLockServiceTracker.getService();
            GetResponse response = dataLockService.getItem(itemId);
            String jsonString = response.getSourceAsString();
            return Response.ok((Object)jsonString, (String)"application/json").build();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "get item failed", e);
            return ErrorResponse.forException(e).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @POST
    @Path(value="/{itemId}")
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response createItem(@PathParam(value="itemId") String itemId, String jsonData) {
        LOG.info("createItem itemId=" + itemId);
        try {
            DataLockService dataLockService = this.dataLockServiceTracker.getService();
            dataLockService.createItem(itemId, jsonData);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "create item failed", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @PUT
    @Path(value="/{itemId}")
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response updateItem(@PathParam(value="itemId") String itemId, String jsonData) {
        LOG.info("updateItem itemId=" + itemId);
        try {
            DataLockService dataLockService = this.dataLockServiceTracker.getService();
            dataLockService.updateItem(itemId, jsonData);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "update item failed", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/{itemId}")
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response deleteItem(@PathParam(value="itemId") String itemId) {
        LOG.info("deleteItem itemId=" + itemId);
        try {
            DataLockService dataLockService = this.dataLockServiceTracker.getService();
            dataLockService.deleteItem(itemId);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "delete item failed", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

