/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deployment;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingValidator;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class DeploymentSystemSettingsValidator
implements SettingValidator {
    private static final Logger LOG = Logger.getLogger(DeploymentSystemSettingsValidator.class.getName());

    public DeploymentSystemSettingsValidator(BundleContext bundleContext) {
    }

    @Override
    public void destroy() {
        LOG.info("destroy");
    }

    @Override
    public boolean canValidate(String moduleId, String moduleInstanceId, String instanceType) {
        return "backendconnection".equalsIgnoreCase(moduleId) && "deployment_system".equalsIgnoreCase(instanceType);
    }

    @Override
    public boolean canValidate(Setting setting) {
        if ("deployment_system".equalsIgnoreCase(setting.getInstanceType())) {
            List<String> settingsToValidate = Arrays.asList("url", "api_key");
            return settingsToValidate.contains(setting.getName());
        }
        return false;
    }

    @Override
    public List<FrontendWarningException> validate(Setting setting) throws ValidationException {
        LOG.info("validate setting:" + setting);
        if (setting.getName().equalsIgnoreCase("url") && StringUtil.isNullOrEmpty((String)setting.getValue())) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "URL must be set", MapUtil.mapOf("field", "url"));
        }
        if (setting.getName().equalsIgnoreCase("api_key") && StringUtil.isNullOrEmpty((String)setting.getValue())) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "API key must be set", MapUtil.mapOf("field", "api_key"));
        }
        return null;
    }

    @Override
    public List<FrontendWarningException> validate(String moduleId, String moduleInstanceId, String instanceType, Map<String, Setting> settings) throws ValidationException {
        LOG.info("validate moduleId=" + moduleId + ", moduleInstanceId=" + moduleInstanceId + ", instanceType=" + instanceType + ", settings:...");
        return null;
    }
}

