/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.fewrapper;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.fewrapper.FeWrapperModule;
import de.virtimo.bpc.core.fewrapper.FeWrapperService;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class FeWrapperServiceImpl
implements FeWrapperService,
BpcService,
BundleListener {
    private static final Logger LOG = Logger.getLogger(FeWrapperServiceImpl.class.getName());
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ModuleManager> moduleManagerServiceTracker;
    private final Map<Bundle, Module> bundleModuleMap;

    public FeWrapperServiceImpl(BundleContext bundleContext) {
        LOG.log(Level.FINEST, "FeWrapperServiceImpl");
        this.bundleContext = bundleContext;
        this.moduleManagerServiceTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.bundleModuleMap = this.getFeOnlyBundles();
        bundleContext.addBundleListener((BundleListener)this);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.log(Level.FINEST, "shutdownService");
        if (this.bundleContext != null) {
            this.bundleContext.removeBundleListener((BundleListener)this);
        }
        BpcServicesTracker.stopAll(this);
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        LOG.finest("bundleChanged bundleEvent=...");
        Bundle bundle = bundleEvent.getBundle();
        if (FeWrapperModule.isFeOnlyBundle(bundle).booleanValue()) {
            try {
                ModuleManager moduleManager = this.moduleManagerServiceTracker.getService();
                switch (bundleEvent.getType()) {
                    case 2: {
                        LOG.info("Found started FE only bundle, wrap in FeWrapperModule - " + bundle);
                        FeWrapperModule newModule = new FeWrapperModule(moduleManager, bundle);
                        this.bundleModuleMap.put(bundle, newModule);
                        moduleManager.loadModule(newModule);
                        break;
                    }
                    case 4: {
                        LOG.info("Found stopped FE only bundle, unload FeWrapperModule - " + bundle);
                        Module module = this.bundleModuleMap.get(bundle);
                        if (module == null) break;
                        this.bundleModuleMap.remove(bundle);
                        moduleManager.unloadModule(module);
                    }
                }
            }
            catch (SettingException | ServiceNotFoundException ex) {
                LOG.log(Level.SEVERE, "Error during bundleChanged", ex);
            }
        }
    }

    private Map<Bundle, Module> getFeOnlyBundles() {
        LOG.finest("getFeOnlyBundles");
        HashMap<Bundle, Module> bundleModuleMap = new HashMap<Bundle, Module>();
        try {
            ModuleManager moduleManager = this.moduleManagerServiceTracker.getService();
            for (Bundle bundle : this.bundleContext.getBundles()) {
                if (!FeWrapperModule.isFeOnlyBundle(bundle).booleanValue()) continue;
                if (bundle.getState() == 32) {
                    LOG.info("Active FE only bundle found, wrap in FeWrapperModule - " + bundle);
                    FeWrapperModule newModule = new FeWrapperModule(moduleManager, bundle);
                    bundleModuleMap.put(bundle, newModule);
                    moduleManager.loadModule(newModule);
                    continue;
                }
                LOG.info("Skipping not active FE only bundle for now. Gets loaded when started - " + bundle);
            }
        }
        catch (SettingException | ServiceNotFoundException ex) {
            LOG.log(Level.SEVERE, "Error during getFeOnlyBundles", ex);
        }
        return bundleModuleMap;
    }
}

