/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.frontendlogging.resource;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.frontendlogging.FrontendLoggingManager;
import de.virtimo.bpc.jaxrs.ApiResponse;
import de.virtimo.bpc.jaxrs.ApiResponses;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;

@Path(value="/frontendLogging")
public class FrontendLoggingEndpoint {
    private static final Logger LOG = Logger.getLogger(FrontendLoggingEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<FrontendLoggingManager> loggingManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public FrontendLoggingEndpoint(BundleContext bundleContext) {
        LOG.info("FrontendLoggingEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.loggingManagerTracker = new BpcServicesTracker<FrontendLoggingManager>(this.bundleContext, FrontendLoggingManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @POST
    @Path(value="/{sessionId}")
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public Response saveFrontendLogData(@PathParam(value="sessionId") String sessionId, @HeaderParam(value="user-agent") String userAgent, List<Map<String, String>> measurements) {
        try {
            this.loggingManagerTracker.getService().saveFrontendLogData(sessionId, userAgent, measurements);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to save frontend log", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

