/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch;

import de.virtimo.bpc.api.opensearch.ManagedIndexConfig;
import de.virtimo.bpc.core.utils.BpcBundleUtil;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.util.StringUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Bundle;

public class ManagedIndexConfigs
implements Iterable<ManagedIndexConfig> {
    private static final Logger LOG = Logger.getLogger(ManagedIndexConfigs.class.getName());
    private Map<String, ManagedIndexConfig> managedIndexConfigs;

    private ManagedIndexConfigs() {
    }

    public ManagedIndexConfigs(Bundle bundle) {
        this.managedIndexConfigs = this.loadAllManagedIndexConfigsFromBundle(bundle);
    }

    public ManagedIndexConfigs(Map<String, Object> managedIndicesConfigMap) {
        this.managedIndexConfigs = this.createManagedIndexConfigsFromJson(managedIndicesConfigMap);
    }

    public boolean isEmpty() {
        return this.managedIndexConfigs.isEmpty();
    }

    public int size() {
        return this.managedIndexConfigs.size();
    }

    public List<ManagedIndexConfig> getAll() {
        return new ArrayList<ManagedIndexConfig>(this.managedIndexConfigs.values());
    }

    private Map<String, ManagedIndexConfig> loadAllManagedIndexConfigsFromBundle(Bundle bundle) {
        HashMap<String, ManagedIndexConfig> managedIndexConfigsFromAllFilesInBundle = new HashMap<String, ManagedIndexConfig>();
        if (bundle == null) {
            return managedIndexConfigsFromAllFilesInBundle;
        }
        if (!BpcBundleUtil.isBpcBackendBundle(bundle)) {
            return managedIndexConfigsFromAllFilesInBundle;
        }
        Set<URL> urlsToManagedIndicesFiles = BpcBundleUtil.getFilesInBundle(bundle, "managed_indices.json");
        if (urlsToManagedIndicesFiles.isEmpty()) {
            return managedIndexConfigsFromAllFilesInBundle;
        }
        for (URL urlToManagedIndicesFile : urlsToManagedIndicesFiles) {
            String filePath = urlToManagedIndicesFile.getFile();
            Map<String, ManagedIndexConfig> managedIndexConfigsFromFile = this.loadManagedIndexConfigsFromBundleAtFilePath(bundle, filePath);
            if (managedIndexConfigsFromFile == null) continue;
            managedIndexConfigsFromAllFilesInBundle.putAll(managedIndexConfigsFromFile);
        }
        return managedIndexConfigsFromAllFilesInBundle;
    }

    private Map<String, ManagedIndexConfig> loadManagedIndexConfigsFromBundleAtFilePath(Bundle bundle, String filePath) {
        if (bundle == null || StringUtil.isNullOrEmpty(filePath)) {
            return null;
        }
        Map<String, Object> managedIndicesConfigMap = JsonDefaultsUtil.loadJsonFileAsMap(bundle, filePath);
        return this.createManagedIndexConfigsFromJson(managedIndicesConfigMap);
    }

    private Map<String, ManagedIndexConfig> createManagedIndexConfigsFromJson(Map<String, Object> managedIndicesConfigMap) {
        HashMap<String, ManagedIndexConfig> managedIndexConfigs = new HashMap<String, ManagedIndexConfig>();
        if (managedIndicesConfigMap == null || !managedIndicesConfigMap.containsKey("managedIndices")) {
            return managedIndexConfigs;
        }
        List managedIndices = (List)managedIndicesConfigMap.get("managedIndices");
        for (Map indexConfiguration : managedIndices) {
            ManagedIndexConfig managedIndexConfig = new ManagedIndexConfig(indexConfiguration);
            if (!managedIndexConfig.hasAliasName()) continue;
            managedIndexConfigs.put(managedIndexConfig.getAliasName(), managedIndexConfig);
        }
        return managedIndexConfigs;
    }

    @Override
    @NotNull
    public Iterator<ManagedIndexConfig> iterator() {
        return this.managedIndexConfigs.values().iterator();
    }
}

