/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch;

import de.virtimo.bpc.Destroyable;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.opensearch.ManagedIndexConfig;
import de.virtimo.bpc.api.opensearch.ManagedIndicesHandler;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.ManagedIndexConfigs;
import de.virtimo.bpc.core.utils.BpcBundleUtil;
import de.virtimo.bpc.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class ManagedIndicesHandlerImpl
implements ManagedIndicesHandler,
Destroyable,
BundleListener {
    private static final Logger LOG = Logger.getLogger(ManagedIndicesHandlerImpl.class.getName());
    private final BundleContext bundleContext;
    private OpenSearchService oss;
    private final Map<String, ManagedIndexConfigs> bundleSymbolicNameAndManagedIndexConfigs;
    private static final Object MANAGED_INDEX_CONFIGS_CONTAINER_LOCK = new Object();

    public ManagedIndicesHandlerImpl(BundleContext bundleContext, OpenSearchService oss) {
        this.bundleContext = bundleContext;
        this.oss = oss;
        this.bundleSymbolicNameAndManagedIndexConfigs = new HashMap<String, ManagedIndexConfigs>();
        if (bundleContext == null) {
            LOG.warning("Failed to add bundle listener due to missing BundleContext. Maybe a unit or integration test?");
        } else {
            bundleContext.addBundleListener((BundleListener)this);
        }
        if (bundleContext == null) {
            LOG.warning("Failed to prepare the managed indices of all registered BPC bundles due to missing BundleContext. Maybe a unit or integration test?");
        } else {
            this.prepareManagedIndicesOfAllBpcBackendBundles();
        }
    }

    @Override
    public void destroy() {
        LOG.log(Level.FINEST, "destroy");
        if (this.bundleContext != null) {
            this.bundleContext.removeBundleListener((BundleListener)this);
        }
        this.oss = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedIndexConfig getManagedIndexConfig(String indexAliasName) {
        LOG.info("getManagedIndexConfigFromAllBpcBackendBundles indexAliasName=" + indexAliasName);
        if (StringUtil.isNullOrEmpty(indexAliasName)) {
            return null;
        }
        Object object = MANAGED_INDEX_CONFIGS_CONTAINER_LOCK;
        synchronized (object) {
            return this._getManagedIndexConfig(indexAliasName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIndexWithHiddenFlag(Set<String> aliases) {
        Object object = MANAGED_INDEX_CONFIGS_CONTAINER_LOCK;
        synchronized (object) {
            for (String indexAlias : aliases) {
                ManagedIndexConfig managedIndexConfig = this._getManagedIndexConfig(indexAlias);
                if (managedIndexConfig == null || !managedIndexConfig.isHidden()) continue;
                return true;
            }
        }
        return false;
    }

    private ManagedIndexConfig _getManagedIndexConfig(String indexAliasName) {
        LOG.info("_getManagedIndexConfig indexAliasName=" + indexAliasName);
        for (ManagedIndexConfigs manageIndexConfigsOfBundle : this.bundleSymbolicNameAndManagedIndexConfigs.values()) {
            for (ManagedIndexConfig managedIndexConfig : manageIndexConfigsOfBundle) {
                if (!managedIndexConfig.canBeUsedForExactAliasName(indexAliasName)) continue;
                return managedIndexConfig;
            }
        }
        for (ManagedIndexConfigs manageIndexConfigsOfBundle : this.bundleSymbolicNameAndManagedIndexConfigs.values()) {
            for (ManagedIndexConfig managedIndexConfig : manageIndexConfigsOfBundle) {
                if (!managedIndexConfig.canBeUsedMatchingWildcard(indexAliasName)) continue;
                return managedIndexConfig;
            }
        }
        return null;
    }

    @Override
    public boolean isManagedIndex(String indexAliasName) {
        return this.getManagedIndexConfig(indexAliasName) != null;
    }

    @Override
    public String createManagedIndex(String indexAliasName) throws OpenSearchRelatedException {
        LOG.info("createManagedIndex indexAliasName=" + indexAliasName);
        return this.createManagedIndex(indexAliasName, null, true);
    }

    @Override
    public Map<String, String> createManagedIndices(Set<String> indexAliasNames) throws OpenSearchRelatedException {
        LOG.info("createManagedIndices indexAliasNames=" + indexAliasNames);
        HashMap<String, String> aliasAndCreatedIndexNames = new HashMap<String, String>();
        if (indexAliasNames != null && !indexAliasNames.isEmpty()) {
            for (String indexAliasName : indexAliasNames) {
                String nameOfCreatedIndex = this.createManagedIndex(indexAliasName, null, true);
                aliasAndCreatedIndexNames.put(indexAliasName, nameOfCreatedIndex);
            }
        }
        return aliasAndCreatedIndexNames;
    }

    @Override
    public String createManagedIndex(String indexAliasName, String indexName, boolean addAlias) throws OpenSearchRelatedException {
        LOG.info("createManagedIndex indexAliasName=" + indexAliasName + ", indexName=" + indexName + ", addAlias=" + addAlias);
        ManagedIndexConfig indexConfiguration = this.getManagedIndexConfig(indexAliasName);
        Map<String, Object> settings = null;
        if (indexConfiguration != null && indexConfiguration.hasSettings()) {
            settings = indexConfiguration.getSettings();
        }
        if (settings == null) {
            settings = this.oss.getDefaultIndexCreationSettings();
        }
        Map<String, Object> mappings = null;
        if (indexConfiguration != null && indexConfiguration.hasMappings()) {
            mappings = indexConfiguration.getMappings();
        }
        return this.oss.createIndex(addAlias ? indexAliasName : null, indexName, settings, mappings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareManagedIndicesOfAllBpcBackendBundles() {
        LOG.info("prepareManagedIndicesOfAllBpcBackendBundles");
        Object object = MANAGED_INDEX_CONFIGS_CONTAINER_LOCK;
        synchronized (object) {
            for (Bundle bundle : this.bundleContext.getBundles()) {
                if (bundle.getState() != 32 || !BpcBundleUtil.isBpcBackendBundle(bundle)) continue;
                ManagedIndexConfigs managedIndexConfigs = this._cacheManageIndexConfigsFromBundle(bundle);
                try {
                    this._prepareManagedIndices(managedIndexConfigs);
                }
                catch (OpenSearchRelatedException ex) {
                    LOG.log(Level.SEVERE, "Error while preparing managed indices of bundle: " + bundle.getSymbolicName(), ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareManagedIndices(Bundle bundle) throws OpenSearchRelatedException {
        LOG.info("prepareManagedIndices bundle=...");
        Object object = MANAGED_INDEX_CONFIGS_CONTAINER_LOCK;
        synchronized (object) {
            ManagedIndexConfigs managedIndexConfigs = this._cacheManageIndexConfigsFromBundle(bundle);
            this._prepareManagedIndices(managedIndexConfigs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareManagedIndices(Map<String, Object> managedIndicesConfigMap) throws OpenSearchRelatedException {
        LOG.info("prepareManagedIndices managedIndicesConfigMap=...");
        Object object = MANAGED_INDEX_CONFIGS_CONTAINER_LOCK;
        synchronized (object) {
            ManagedIndexConfigs managedIndexConfigs = new ManagedIndexConfigs(managedIndicesConfigMap);
            this._prepareManagedIndices(managedIndexConfigs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareManagedIndices(String bundleSymbolicName, Map<String, Object> managedIndicesConfigMap) throws OpenSearchRelatedException {
        LOG.info("prepareManagedIndices bundleSymbolicName=" + bundleSymbolicName + "+, managedIndicesConfigMap=...");
        Object object = MANAGED_INDEX_CONFIGS_CONTAINER_LOCK;
        synchronized (object) {
            ManagedIndexConfigs managedIndexConfigs = new ManagedIndexConfigs(managedIndicesConfigMap);
            if (!managedIndexConfigs.isEmpty()) {
                this.bundleSymbolicNameAndManagedIndexConfigs.put(bundleSymbolicName, managedIndexConfigs);
                this._prepareManagedIndices(managedIndexConfigs);
            }
        }
    }

    private void _prepareManagedIndices(ManagedIndexConfigs managedIndexConfigs) throws OpenSearchRelatedException {
        LOG.info("_prepareManagedIndices managedIndexConfigs=...");
        if (managedIndexConfigs != null) {
            for (ManagedIndexConfig managedIndexConfig : managedIndexConfigs) {
                if (!managedIndexConfig.isCreateOnStart()) continue;
                String aliasName = managedIndexConfig.getAliasName();
                if (aliasName != null && !this.oss.existsIndex(aliasName) && this.oss.getIndexNamesWithAlias(aliasName).isEmpty()) {
                    LOG.finest("No index or alias with name " + aliasName + " found. Create index now.");
                    this.oss.createIndex(aliasName, managedIndexConfig.getSettings(), managedIndexConfig.getMappings());
                    continue;
                }
                LOG.info("Skip creation of existing index or alias " + aliasName);
            }
        }
    }

    private ManagedIndexConfigs _cacheManageIndexConfigsFromBundle(Bundle bundle) {
        LOG.info("_cacheManageIndexConfigsFromBundle bundle=" + bundle);
        ManagedIndexConfigs managedIndexConfigs = new ManagedIndexConfigs(bundle);
        if (!managedIndexConfigs.isEmpty()) {
            this.bundleSymbolicNameAndManagedIndexConfigs.put(bundle.getSymbolicName(), managedIndexConfigs);
        }
        return managedIndexConfigs;
    }

    private void _uncacheManageIndexConfigsOfBundle(String moduleBundleSymbolicName) {
        LOG.info("_uncacheManageIndexConfigsOfBundle moduleBundleSymbolicName=" + moduleBundleSymbolicName);
        this.bundleSymbolicNameAndManagedIndexConfigs.remove(moduleBundleSymbolicName);
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        LOG.finest("bundleChanged bundleEvent=...");
        Bundle bundle = bundleEvent.getBundle();
        if (!BpcBundleUtil.isBpcBackendBundle(bundle)) {
            return;
        }
        if (BpcBundleUtil.isBpcBackendCoreBundle(bundle)) {
            return;
        }
        switch (bundleEvent.getType()) {
            case 2: {
                LOG.info("Found started backend bundle, caching and preparing managed indices of bundle: " + bundle);
                this.processBpcBundleStartedEvent(bundle);
                break;
            }
            case 4: 
            case 16: {
                LOG.info("Found stopped backend bundle, removing cached managed indices of bundle: " + bundle);
                this.processBpcBundleStoppedEvent(bundle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBpcBundleStartedEvent(Bundle bundle) {
        LOG.info("processBpcBundleStartedEvent bundle=" + bundle);
        Object object = MANAGED_INDEX_CONFIGS_CONTAINER_LOCK;
        synchronized (object) {
            try {
                ManagedIndexConfigs managedIndexConfigs = this._cacheManageIndexConfigsFromBundle(bundle);
                this._prepareManagedIndices(managedIndexConfigs);
            }
            catch (OpenSearchRelatedException ex) {
                LOG.log(Level.SEVERE, "Error while preparing managed indices of bundle: " + bundle.getSymbolicName(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBpcBundleStoppedEvent(Bundle bundle) {
        LOG.info("processBpcBundleStoppedEvent bundle=" + bundle);
        Object object = MANAGED_INDEX_CONFIGS_CONTAINER_LOCK;
        synchronized (object) {
            this._uncacheManageIndexConfigsOfBundle(bundle.getSymbolicName());
        }
    }
}

