/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.StorageServiceSupport;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.response.ModuleConfig;
import de.virtimo.bpc.api.service.StorageService;
import de.virtimo.bpc.api.storage.DeploymentInstruction;
import de.virtimo.bpc.api.storage.StoreItem;
import de.virtimo.bpc.api.storage.StoreItems;
import de.virtimo.bpc.api.storage.exception.StoreNotFoundException;
import de.virtimo.bpc.core.auth.AbstractUserSession;
import de.virtimo.bpc.core.resource.response.SettingValueFilter;
import de.virtimo.bpc.core.resource.response.SimpleModuleInstanceConfigImpl;
import de.virtimo.bpc.core.storage.StoreItemSettingName;
import de.virtimo.bpc.module.simple.CustomFieldsImpl;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class UserSessionBasedModuleInstanceConfigImpl
extends SimpleModuleInstanceConfigImpl {
    private static final Logger LOG = Logger.getLogger(UserSessionBasedModuleInstanceConfigImpl.class.getName());
    protected UserSession userSession;
    protected SettingValueFilter settingValueFilter;
    protected boolean onlySettingsMandatoryForFrontend;
    protected boolean embedStorageServiceData;

    public UserSessionBasedModuleInstanceConfigImpl(ModuleInstance moduleInstance, UserSession userSession, boolean onlySettingsMandatoryForFrontend, boolean embedStorageServiceData) {
        super(moduleInstance);
        this.userSession = userSession;
        this.settingValueFilter = new SettingValueFilter(userSession);
        this.onlySettingsMandatoryForFrontend = onlySettingsMandatoryForFrontend;
        this.embedStorageServiceData = embedStorageServiceData;
    }

    @Override
    public List<Setting> getSettings() {
        ArrayList<Setting> result = new ArrayList<Setting>();
        List<Setting> settings = this.settingValueFilter.filter(super.getSettings());
        if (settings != null) {
            Map<String, Setting> moduleInstanceDefaultSettings = AbstractUserSession.getModuleDefaultSettings(this.moduleInstance);
            for (Setting setting : settings) {
                if (!this.userSession.hasReadAccessToSetting(this.moduleInstance, moduleInstanceDefaultSettings, setting)) continue;
                if (this.onlySettingsMandatoryForFrontend) {
                    if (!setting.getCustomFields().getBooleanValue("_mandatoryForFrontend", false)) continue;
                    result.add(setting);
                    continue;
                }
                result.add(setting);
            }
        }
        if (this.embedStorageServiceData && this.moduleInstance instanceof StorageServiceSupport) {
            try {
                List<DeploymentInstruction> deploymentInstructions = ((StorageServiceSupport)((Object)this.moduleInstance)).getDeploymentInstructionsOfStorageServiceData();
                if (deploymentInstructions != null) {
                    for (DeploymentInstruction deploymentInstruction : deploymentInstructions) {
                        StoreItems storeItems = this.fetchStorageServiceItems(deploymentInstruction);
                        if (storeItems.isEmpty()) continue;
                        for (StoreItem storeItem : storeItems) {
                            CustomFieldsImpl customFields = new CustomFieldsImpl();
                            customFields.setStringValue("BelongsTo", "StorageService");
                            customFields.setStringValue("storeId", storeItems.getStoreId());
                            customFields.setStringValue("storeItemId", storeItem.getId());
                            SimpleSettingImpl storageServiceSetting = new SimpleSettingImpl(storeItem.asJsonMap(), StoreItemSettingName.create(storeItems.getStoreId(), storeItem.getId()), "json", this.moduleInstance.getParentModule().getModuleId(), this.moduleInstance.getModuleId(), this.moduleInstance.getInstanceType(), customFields);
                            result.add(storageServiceSetting);
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to get storage service data.", ex);
            }
        }
        return result;
    }

    private StoreItems fetchStorageServiceItems(DeploymentInstruction deploymentInstruction) throws ServiceNotFoundException, StoreNotFoundException, OpenSearchRelatedException {
        LOG.fine("fetchStorageServiceItems deploymentInstruction=" + deploymentInstruction);
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        try (BpcServicesTracker<StorageService> storageServiceTracker = new BpcServicesTracker<StorageService>(bundleContext, StorageService.class);){
            StorageService storageService = storageServiceTracker.getService();
            StoreItems storeItems = storageService.getItems(deploymentInstruction.getStoreId(), (Integer)0, (Integer)10000, null, deploymentInstruction.getFilters(), deploymentInstruction.getSorters(), null, this.userSession);
            return storeItems;
        }
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Object getDefaultConfiguration() throws SettingException {
        return super.getDefaultConfiguration();
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Object getInstancesDefaultConfiguration() throws SettingException {
        return super.getInstancesDefaultConfiguration();
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<ModuleConfig> getInstances() {
        return null;
    }
}

