/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.service;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexState;
import de.virtimo.bpc.api.service.ExtOpenSearchService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class ExtOpenSearchServiceImpl
implements ExtOpenSearchService,
BpcService {
    private static final Logger LOG = Logger.getLogger(ExtOpenSearchServiceImpl.class.getName());
    private final BundleContext bundleContext;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private final BpcServicesTracker<ReplicationManager> replicationManagerTracker;

    public ExtOpenSearchServiceImpl(BundleContext bundleContext) {
        LOG.info("ExtOpenSearchServiceImpl bundleContext=...");
        this.bundleContext = bundleContext;
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.replicationManagerTracker = new BpcServicesTracker<ReplicationManager>(bundleContext, ReplicationManager.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteIndex(String indexName, Object initiator) throws ServiceNotFoundException, OpenSearchRelatedException, ModuleNotFoundException, OpenSearchIndexNotFoundException {
        block13: {
            boolean mustStopRelatedReplicationJobs;
            LOG.info("deleteIndex indexName=" + indexName + ", initiator=...");
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            ReplicationManager replicationManager = this.replicationManagerTracker.getService();
            CoreModule coreModule = moduleManager.getModuleByClass(CoreModule.class);
            Set<String> aliasesOfIndexName = oss.getAliasesForIndexName(indexName);
            List<ReplicationJob> relatedReplicationJobs = replicationManager.getJobsUsingTargetIndexAliases(aliasesOfIndexName);
            boolean bl = mustStopRelatedReplicationJobs = !coreModule.isMaintenanceModeEnabled() && coreModule.isMasterServer();
            if (mustStopRelatedReplicationJobs) {
                for (ReplicationJob relatedReplicationJob : relatedReplicationJobs) {
                    replicationManager.stopReplicationJob(relatedReplicationJob.getId());
                    SystemAuditLog.info("ReplicationJobStopped", "Replication job '" + relatedReplicationJob.getId() + "' stopped. Caused by deletion of index '" + indexName + "'.");
                }
            }
            try {
                String alias;
                oss.deleteIndexWithException(indexName);
                if (initiator instanceof String) {
                    UserAuditLog.info((String)initiator, "OpenSearchIndexDeleted", "OpenSearch index '" + indexName + "' deleted.");
                } else if (initiator instanceof UserSession) {
                    UserAuditLog.info((UserSession)initiator, "OpenSearchIndexDeleted", "OpenSearch index '" + indexName + "' deleted.");
                }
                if (aliasesOfIndexName.size() == 1 && oss.existsAttachmentsPipeline(alias = aliasesOfIndexName.iterator().next())) {
                    oss.deleteAttachmentsPipeline(alias);
                }
                if (aliasesOfIndexName.size() >= 1) {
                    for (String aliasOfIndexName : aliasesOfIndexName) {
                        if (!oss.hasIndexState(aliasOfIndexName)) continue;
                        BpcIndexState indexState = oss.getIndexState(aliasOfIndexName);
                        indexState.handleDeletedIndex(indexName);
                    }
                }
                if (!mustStopRelatedReplicationJobs) break block13;
            }
            catch (Throwable throwable) {
                if (mustStopRelatedReplicationJobs) {
                    for (ReplicationJob relatedReplicationJob : relatedReplicationJobs) {
                        replicationManager.startReplicationJob(relatedReplicationJob);
                        SystemAuditLog.info("ReplicationJobRestarted", "Replication job '" + relatedReplicationJob.getId() + "' restarted. Caused by deletion of index '" + indexName + "'.");
                    }
                }
                throw throwable;
            }
            for (ReplicationJob relatedReplicationJob : relatedReplicationJobs) {
                replicationManager.startReplicationJob(relatedReplicationJob);
                SystemAuditLog.info("ReplicationJobRestarted", "Replication job '" + relatedReplicationJob.getId() + "' restarted. Caused by deletion of index '" + indexName + "'.");
            }
        }
    }
}

