/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.service;

import de.virtimo.bpc.util.StringUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OpenSearchSettingsCleaner {
    public static Map<String, Object> clearSettingsMapFromKnownPrivateSettings(Map<String, Object> settingsMap) {
        Set<String> knownPrivateSettingPaths = Set.of("creation_date", "provided_name", "search.throttled", "uuid", "version.created", "version.upgraded");
        HashMap<String, Object> result = new HashMap<String, Object>(settingsMap);
        for (String knownPrivateSettingPath : knownPrivateSettingPaths) {
            OpenSearchSettingsCleaner.removeSettingPath(result, knownPrivateSettingPath);
        }
        OpenSearchSettingsCleaner.removeEmptyMaps(result);
        return result;
    }

    private static boolean removeSettingPath(Map<String, Object> settingsMap, String settingPath) {
        if (OpenSearchSettingsCleaner.containsValueAtPath(settingsMap, settingPath)) {
            List<String> pathEntries = StringUtil.explode(settingPath, ".");
            for (int i = 0; i < pathEntries.size(); ++i) {
                String pathEntry = pathEntries.get(i);
                if (i == pathEntries.size() - 1) {
                    settingsMap.remove(pathEntry);
                    return true;
                }
                Object value = settingsMap.get(pathEntry);
                if (!(value instanceof Map)) {
                    return false;
                }
                settingsMap = (Map)value;
            }
        }
        return false;
    }

    private static void removeEmptyMaps(Map<String, Object> settingsMap) {
        HashSet<String> keys = new HashSet<String>(settingsMap.keySet());
        for (String key : keys) {
            Object value = settingsMap.get(key);
            if (!(value instanceof Map)) continue;
            Map map = (Map)value;
            OpenSearchSettingsCleaner.removeEmptyMaps(map);
            if (!map.isEmpty()) continue;
            settingsMap.remove(key);
        }
    }

    public static boolean containsValueAtPath(Map<String, Object> settingsMap, String settingPath) {
        List<String> pathEntries;
        if (settingsMap != null && settingPath != null && !(pathEntries = StringUtil.explode(settingPath, ".")).isEmpty()) {
            for (int i = 0; i < pathEntries.size(); ++i) {
                Object value;
                String pathEntry = pathEntries.get(i);
                if (settingsMap.containsKey(pathEntry)) {
                    if (i == pathEntries.size() - 1) {
                        return true;
                    }
                    value = settingsMap.get(pathEntry);
                    if (!(value instanceof Map)) {
                        return false;
                    }
                } else {
                    return false;
                }
                settingsMap = (Map)value;
            }
        }
        return false;
    }
}

