/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.utils;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.core.BpcActivator;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.karaf.bundle.core.BundleService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BpcBundleUtil {
    private static final Logger LOG = Logger.getLogger(BpcBundleUtil.class.getName());

    public static String getBundleFilename(Bundle bundle) {
        String bundleFileLocation;
        LOG.finest("getBundleFilename bundle=" + bundle);
        if (bundle != null && (bundleFileLocation = bundle.getLocation()) != null && bundleFileLocation.startsWith("file:")) {
            try {
                return Paths.get(new URI(bundleFileLocation)).getFileName().toString();
            }
            catch (URISyntaxException ex) {
                LOG.log(Level.SEVERE, "Failed to extract the bundle filename from: " + bundleFileLocation, ex);
            }
        }
        return null;
    }

    public static Bundle getBundleByFilename(BundleContext bundleContext, String bundleFilename) {
        LOG.finest("getBundleByFilename bundleContext=..., bundleFilename=" + bundleFilename);
        if (bundleContext != null && bundleFilename != null) {
            for (Bundle bundle : bundleContext.getBundles()) {
                if (!bundleFilename.equals(BpcBundleUtil.getBundleFilename(bundle))) continue;
                return bundle;
            }
        }
        return null;
    }

    public static Bundle getBundleBySymbolicName(BundleContext bundleContext, String bundleSymbolicName) {
        LOG.finest("getBundleBySymbolicName bundleContext=..., bundleSymbolicName=" + bundleSymbolicName);
        if (bundleContext != null && bundleSymbolicName != null) {
            for (Bundle bundle : bundleContext.getBundles()) {
                if (!bundleSymbolicName.equals(bundle.getSymbolicName())) continue;
                return bundle;
            }
        }
        return null;
    }

    public static void checkIfBundleWithBadSymbolicName(Bundle bundle) {
        LOG.finest("checkIfBundleWithBadSymbolicName bundle=" + bundle);
        if (bundle != null) {
            List<String> exploded;
            Dictionary headers = bundle.getHeaders();
            String bundleName = (String)headers.get("Bundle-Name");
            String bundleSymbolicName = (String)headers.get("Bundle-SymbolicName");
            if (!StringUtil.isNullOrEmpty(bundleSymbolicName) && (exploded = StringUtil.explode(bundleSymbolicName, ";")).size() > 1) {
                String errorMessage = "The bundle '" + bundleName + "' = " + bundle + " uses an problematic symbolic name in the META-INF/MANIFEST.MF file. Please let the developer of the module/bundle know that he should remove everything after the semicolon (including): " + bundleSymbolicName;
                System.out.println(errorMessage);
                LOG.severe(errorMessage);
            }
        }
    }

    public static boolean isBpcBackendBundle(Bundle bundle) {
        LOG.finest("isBpcBackendBundle bundle=" + bundle);
        if (!BpcBundleUtil.isBpcBundle(bundle)) {
            return false;
        }
        String bundleActivatorClassName = BpcBundleUtil.getBundleActivatorClassName(bundle);
        return bundleActivatorClassName != null;
    }

    public static boolean isBpcBackendCoreBundle(Bundle bundle) {
        LOG.finest("isBpcBackendCoreBundle bundle=" + bundle);
        if (!BpcBundleUtil.isBpcBundle(bundle)) {
            return false;
        }
        String bundleActivatorClassName = BpcBundleUtil.getBundleActivatorClassName(bundle);
        return bundleActivatorClassName != null && bundleActivatorClassName.equals(BpcActivator.class.getName());
    }

    public static boolean isBpcBundle(Bundle bundle) {
        LOG.finest("isBpcBundle bundle=" + bundle);
        if (bundle == null) {
            return false;
        }
        Dictionary headers = bundle.getHeaders();
        LOG.finest("Bundle: " + bundle.getBundleId() + " - Bundle-Name: " + (String)headers.get("Bundle-Name") + " - BPC-Bundle: " + (String)headers.get("BPC-Bundle"));
        return headers.get("BPC-Bundle") != null;
    }

    public static String getBundleActivatorClassName(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        return (String)bundle.getHeaders().get("Bundle-Activator");
    }

    private static String getKarafSpecificCombinedBundleState(BundleContext bundleContext, Bundle bundle) {
        String result = null;
        try (BpcServicesTracker<BundleService> bundleServiceTracker = new BpcServicesTracker<BundleService>(bundleContext, BundleService.class);){
            BundleService bundleService = bundleServiceTracker.getService();
            result = bundleService.getInfo(bundle).getState().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getBundleState(BundleContext bundleContext, Bundle bundle) {
        String karafSpecificCombinedBundleState = BpcBundleUtil.getKarafSpecificCombinedBundleState(bundleContext, bundle);
        if (karafSpecificCombinedBundleState != null) {
            return karafSpecificCombinedBundleState.toUpperCase();
        }
        return switch (bundle.getState()) {
            case 1 -> "UNINSTALLED";
            case 2 -> "INSTALLED";
            case 4 -> "RESOLVED";
            case 8 -> "STARTING";
            case 16 -> "STOPPING";
            case 32 -> "ACTIVE";
            default -> "UNKNOWN";
        };
    }

    public static boolean isBundleInSomeKindOfErrorState(BundleContext bundleContext, Bundle bundle) {
        String state = BpcBundleUtil.getBundleState(bundleContext, bundle);
        return SetUtil.setOf("RESOLVED", "FAILURE").contains(state.toUpperCase());
    }

    public static boolean areAllBpcBundlesInWorkingState(BundleContext bundleContext) {
        for (Bundle bundle : bundleContext.getBundles()) {
            if (!BpcBundleUtil.isBpcBundle(bundle) || !BpcBundleUtil.isBundleInSomeKindOfErrorState(bundleContext, bundle)) continue;
            return false;
        }
        return true;
    }

    public static URL getFileInBundleAtSpecificFolder(Bundle bundle, String folderToLookForFile, String fileName) {
        LOG.info("getFileInBundleAtSpecificFolder bundle=" + bundle + ", folderToLookForFile=" + folderToLookForFile + ", fileName=" + fileName);
        Set<URL> entries = BpcBundleUtil.getFilesInBundleAtSpecificFolders(bundle, SetUtil.setOf(folderToLookForFile), fileName);
        return entries.isEmpty() ? null : entries.iterator().next();
    }

    public static Set<URL> getFilesInBundleAtSpecificFolders(Bundle bundle, Set<String> foldersToLookForFiles, String filePattern) {
        LOG.info("getFilesInBundleAtSpecificFolders bundle=" + bundle + ", foldersToLookForFiles=" + foldersToLookForFiles + ", filePattern=" + filePattern);
        HashSet<URL> result = new HashSet<URL>();
        if (foldersToLookForFiles != null && !foldersToLookForFiles.isEmpty()) {
            for (String folderToLookForFiles : foldersToLookForFiles) {
                result.addAll(BpcBundleUtil.findEntries(bundle, folderToLookForFiles, filePattern, false));
            }
        }
        return result;
    }

    public static Set<URL> getFilesInBundle(Bundle bundle, String filePattern) {
        LOG.info("getFilesInBundle bundle=" + bundle + ", filePattern=" + filePattern);
        HashSet<URL> result = new HashSet<URL>();
        if (!StringUtil.isNullOrEmpty(filePattern)) {
            result.addAll(BpcBundleUtil.findEntries(bundle, "/", filePattern, true));
        }
        return result;
    }

    private static Set<URL> findEntries(Bundle bundle, String path, String filePattern, boolean recurse) {
        Enumeration entries;
        LOG.fine("findEntries bundle=" + bundle + ", path=" + path + ", filePattern=" + filePattern + ", recurse=" + recurse);
        HashSet<URL> result = new HashSet<URL>();
        if (bundle != null && (entries = bundle.findEntries(path, filePattern, recurse)) != null) {
            while (entries.hasMoreElements()) {
                URL fileUrl = (URL)entries.nextElement();
                result.add(fileUrl);
            }
        }
        return result;
    }
}

