/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.flow;

import de.virtimo.bpc.logservice.ExternalReferenceData;
import de.virtimo.bpc.util.StringUtil;
import java.util.logging.Logger;
import javax.ws.rs.core.HttpHeaders;

public class IguasuHelper {
    private static final Logger LOG = Logger.getLogger(IguasuHelper.class.getName());

    public static ExternalReferenceData extractIguasuSpecificHeaderValues(HttpHeaders httpHeaders) {
        LOG.fine("extractIguasuSpecificHeaderValues httpHeaders=" + httpHeaders);
        if (httpHeaders == null) {
            return null;
        }
        String iguasuSystemId = httpHeaders.getHeaderString("IGUASU-System-ID");
        String iguasuInstanceId = httpHeaders.getHeaderString("IGUASU-Instance-ID");
        String iguasuProcessorId = httpHeaders.getHeaderString("IGUASU-Processor-ID");
        String iguasuServiceId = httpHeaders.getHeaderString("IGUASU-Service-ID");
        if (StringUtil.isNullOrEmpty(iguasuSystemId)) {
            return null;
        }
        return new ExternalReferenceData("iguasu").add("system", iguasuSystemId).add("instance", iguasuInstanceId).add("processor", iguasuProcessorId).add("service", iguasuServiceId);
    }
}

