/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.AbstractRestoreBackupDoneEventHandler;
import de.virtimo.bpc.api.AbstractRestoreBackupStartEventHandler;
import de.virtimo.bpc.api.AbstractSettingUpdatedEventHandler;
import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.BackupSettingFactory;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.LogServiceException;
import de.virtimo.bpc.api.exception.LogServiceSettingsException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.logservice.ExternalReferenceData;
import de.virtimo.bpc.logservice.LogDataResult;
import de.virtimo.bpc.logservice.LogService;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.logservice.db.DatabaseLogService;
import de.virtimo.bpc.logservice.opensearch.OpenSearchLogService;
import de.virtimo.bpc.logservice.resource.LogData;
import de.virtimo.bpc.logservice.resource.LogDataEntries;
import de.virtimo.bpc.module.AbstractInstantiableModule;
import de.virtimo.bpc.module.ModuleConfigurationBuilder;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class LogServiceModule
extends AbstractInstantiableModule {
    private static final Logger LOG = Logger.getLogger(LogServiceModule.class.getName());
    public static final String MODULE_ID = "logservice";
    private static final String BACKUP_JOB_PREFIX = "core:logservice:";
    public static final String DEFAULT_LOG_SERVICE_INDICES_BACKUP_SETTING_NAME = "defaultLogServiceIndicesBackup";
    public static final String CLIENT_CERTIFICATE_AUTH_MANDATORY = "clientCertificateAuthMandatory";
    public static final String MAX_RESULT_WINDOW = "es_data_view_limit";
    public static final String MAX_DATA_COUNT = "es_data_count_limit";
    private final ExecutorService loggingExecutorService;
    private final Set<String> indicesTemporaryUnavailable;
    private static final Object INDICES_TEMPORARY_UNAVAILABLE_LOCK = new Object();
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private BpcServicesTracker<BackupManager> backupManagerTracker;
    private BpcServicesTracker<DatabaseManager> databaseManagerTracker;
    private final EventRegistration eventRegistration;
    private Setting defaultLogServiceIndicesBackupSetting;

    public LogServiceModule(ModuleManager moduleManager, Setting defaultLogServiceIndicesBackupSetting) {
        super(moduleManager);
        this.defaultLogServiceIndicesBackupSetting = defaultLogServiceIndicesBackupSetting;
        this.loggingExecutorService = Executors.newFixedThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-logservice"));
        this.indicesTemporaryUnavailable = new HashSet<String>();
        this.eventRegistration = new EventRegistration(null);
    }

    @Override
    public void setModuleBundle(Bundle moduleBundle) {
        super.setModuleBundle(moduleBundle);
        BundleContext bundleContext = moduleBundle.getBundleContext();
        BpcServicesTracker.stopAll(this);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.backupManagerTracker = new BpcServicesTracker<BackupManager>(bundleContext, BackupManager.class);
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
        this.eventRegistration.setBundleContext(bundleContext);
        this.eventRegistration.forModuleUpdatedEvents("_core", DEFAULT_LOG_SERVICE_INDICES_BACKUP_SETTING_NAME, new DefaultLogServiceIndicesBackupSettingUpdatedEventHandler());
        this.eventRegistration.forBackendModuleLoadedEvents(MODULE_ID, new LogServiceModuleLoadedEventHandler());
        this.eventRegistration.forRestoreBackupStartEvents(new RestoreBackupStartEventHandler());
        this.eventRegistration.forRestoreBackupDoneEvents(new RestoreBackupDoneEventHandler());
    }

    @Override
    public void destroy() {
        LOG.info("destroy");
        super.destroy();
        if (this.loggingExecutorService != null) {
            this.loggingExecutorService.shutdown();
        }
        BpcServicesTracker.stopAll(this);
        this.eventRegistration.unregisterAllEventHandler();
    }

    @Override
    public ModuleConfiguration getDefaultConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/logservice/default_module_settings.json").build();
    }

    @Override
    public String getModuleId() {
        return MODULE_ID;
    }

    @Override
    public String getModuleName() {
        return "Log Service";
    }

    @Override
    public ModuleConfiguration getDefaultInstanceConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).withInstanceId(null).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/logservice/default_instance_settings.json").build();
    }

    @Override
    public Class<? extends ModuleInstance> getModuleInstanceClass() {
        return LogServiceModuleInstance.class;
    }

    public synchronized void restartBackupJobs() {
        LOG.info("restartBackupJobs");
        Map<String, ModuleInstance> logServiceModuleInstances = this.getModuleInstances();
        for (ModuleInstance moduleInstance : logServiceModuleInstances.values()) {
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
            this.restartBackupJob(logServiceModuleInstance);
        }
    }

    public synchronized void restartBackupJob(LogServiceModuleInstance logServiceModuleInstance) {
        try {
            LogServiceModuleInstance.OpenSearchConfig openSearchConfig = logServiceModuleInstance.getOpenSearchConfig();
            if (openSearchConfig != null) {
                boolean childProcessingEnabled = openSearchConfig.child != null;
                BackupSetting backupSetting = BackupSettingFactory.createFrom(this.defaultLogServiceIndicesBackupSetting, childProcessingEnabled ? SetUtil.setOf(openSearchConfig.parent.index, openSearchConfig.child.index) : SetUtil.setOf(openSearchConfig.parent.index));
                this.backupManagerTracker.getService().scheduleBackupJobWithSettings(BACKUP_JOB_PREFIX + backupSetting.getIndicesToBackupNamesAsKey(), backupSetting);
            }
        }
        catch (LogServiceSettingsException e) {
            LOG.log(Level.WARNING, "Ignoring log service backup exception.", e);
        }
        catch (ServiceNotFoundException ex) {
            LOG.log(Level.SEVERE, "Cannot schedule a log service backup job without the BackupManager");
        }
    }

    private DatabaseLogService createDatabaseLogService(LogServiceModuleInstance moduleInstance) throws LogServiceException {
        try {
            return new DatabaseLogService(this.databaseManagerTracker.getService(), moduleInstance.getDatabaseTableDataCache());
        }
        catch (ServiceNotFoundException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MISSING_SERVICE, "The DatabaseManager service is missing.", ex);
        }
    }

    private OpenSearchLogService createOpenSearchLogService() throws LogServiceException {
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            Map<String, Object> defaultIndexCreationSettings = oss.getDefaultIndexCreationSettings();
            List defaultDynamicTemplates = oss.getDefaultDynamicTemplates();
            return new OpenSearchLogService(oss, this.percolatorsManagerTracker.getService(), defaultIndexCreationSettings, defaultDynamicTemplates);
        }
        catch (ServiceNotFoundException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MISSING_SERVICE, "Either the OpenSearch or the PercolatorsManager service is missing.", ex);
        }
    }

    public void deleteChildEntries(LogServiceModuleInstance moduleInstance, String parentId, String timeZoneId, String childQuery, String childFilter) throws LogServiceException {
        OpenSearchLogService logService;
        FutureTask<Exception> informClientsFutureTask;
        LOG.info("deleteChildEntries moduleInstance=" + moduleInstance + ", parentId=" + parentId + ", timeZoneId=" + timeZoneId + ", childQuery=" + childQuery + ", childFilter=" + childFilter);
        if (moduleInstance.isDatabaseLoggingEnabled()) {
            // empty if block
        }
        if (moduleInstance.isOpenSearchLoggingEnabled() && (informClientsFutureTask = (logService = this.createOpenSearchLogService()).deleteChildData(moduleInstance, parentId, timeZoneId, childQuery, childFilter)) != null) {
            this.loggingExecutorService.execute(informClientsFutureTask);
        }
    }

    public void deleteChildEntries(LogServiceModuleInstance moduleInstance, String timeZoneId, String childQuery, String childFilter) throws LogServiceException {
        OpenSearchLogService logService;
        FutureTask<Exception> informClientsFutureTask;
        LOG.info("deleteChildEntries moduleInstance=" + moduleInstance + ", timeZoneId=" + timeZoneId + ", childQuery=" + childQuery + ", childFilter=" + childFilter);
        if (moduleInstance.isDatabaseLoggingEnabled()) {
            // empty if block
        }
        if (moduleInstance.isOpenSearchLoggingEnabled() && (informClientsFutureTask = (logService = this.createOpenSearchLogService()).deleteChildData(moduleInstance, timeZoneId, childQuery, childFilter)) != null) {
            this.loggingExecutorService.execute(informClientsFutureTask);
        }
    }

    public void deleteEntries(LogServiceModuleInstance moduleInstance, String timeZoneId, String parentQuery, String parentFilter) throws LogServiceException {
        OpenSearchLogService logService;
        FutureTask<Exception> informClientsFutureTask;
        LOG.info("deleteEntries moduleInstance=" + moduleInstance + ", timeZoneId=" + timeZoneId + ", parentQuery=" + parentQuery + ", parentFilter=" + parentFilter);
        if (moduleInstance.isDatabaseLoggingEnabled()) {
            // empty if block
        }
        if (moduleInstance.isOpenSearchLoggingEnabled() && (informClientsFutureTask = (logService = this.createOpenSearchLogService()).deleteData(moduleInstance, timeZoneId, parentQuery, parentFilter)) != null) {
            this.loggingExecutorService.execute(informClientsFutureTask);
        }
    }

    public void deleteEntries(LogServiceModuleInstance moduleInstance, List<String> parentIDs) throws LogServiceException {
        FutureTask<Exception> informClientsFutureTask;
        LogService logService;
        LOG.info("deleteEntries moduleInstance=" + moduleInstance + ", parentIDs=" + parentIDs);
        if (moduleInstance.isDatabaseLoggingEnabled()) {
            logService = this.createDatabaseLogService(moduleInstance);
            logService.deleteData(moduleInstance, parentIDs);
        }
        if (moduleInstance.isOpenSearchLoggingEnabled() && (informClientsFutureTask = (logService = this.createOpenSearchLogService()).deleteData(moduleInstance, parentIDs)) != null) {
            this.loggingExecutorService.execute(informClientsFutureTask);
        }
    }

    public void deleteChildEntries(LogServiceModuleInstance moduleInstance, String parentId, List<String> childIDs) throws LogServiceException {
        FutureTask<Exception> informClientsFutureTask;
        LogService logService;
        LOG.info("deleteChildEntries moduleInstance=" + moduleInstance + ", parentId=" + parentId + ", childIDs=" + childIDs);
        if (moduleInstance.isDatabaseLoggingEnabled()) {
            logService = this.createDatabaseLogService(moduleInstance);
            logService.deleteChildData(moduleInstance, parentId, childIDs);
        }
        if (moduleInstance.isOpenSearchLoggingEnabled() && (informClientsFutureTask = (logService = this.createOpenSearchLogService()).deleteChildData(moduleInstance, parentId, childIDs)) != null) {
            this.loggingExecutorService.execute(informClientsFutureTask);
        }
    }

    public void log(boolean async, final LogServiceModuleInstance moduleInstance, final LogData logData, final ExternalReferenceData externalReferenceData) throws LogServiceException {
        LOG.info("log async=" + async + ", moduleInstance=" + moduleInstance + ", logData=..., externalReferenceData=...");
        if (logData == null || logData.isEmpty()) {
            throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No data to log given");
        }
        if (async) {
            FutureTask<LogDataResult> logDataFutureTask = new FutureTask<LogDataResult>(new Callable<LogDataResult>(){

                @Override
                public LogDataResult call() {
                    try {
                        return LogServiceModule.this.logData(moduleInstance, logData, externalReferenceData);
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, ex.getMessage(), ex);
                        return null;
                    }
                }
            });
            this.loggingExecutorService.execute(logDataFutureTask);
        } else {
            this.logData(moduleInstance, logData, externalReferenceData);
        }
    }

    private LogDataResult logData(LogServiceModuleInstance moduleInstance, LogData logData, ExternalReferenceData externalReferenceData) throws LogServiceException {
        FutureTask<Exception> informClientsFutureTask;
        LogService logService;
        LOG.info("logData moduleInstance=" + moduleInstance + ", logData=..., externalReferenceData=...");
        LOG.fine("OS logging enabled:" + moduleInstance.isOpenSearchLoggingEnabled());
        LOG.fine("DB logging enabled:" + moduleInstance.isDatabaseLoggingEnabled());
        ZonedDateTime currentDateTime = ZonedDateTime.now();
        if (moduleInstance.isDatabaseLoggingEnabled()) {
            logService = this.createDatabaseLogService(moduleInstance);
            logService.logData(moduleInstance, currentDateTime, logData, externalReferenceData);
        }
        if (moduleInstance.isOpenSearchLoggingEnabled() && (informClientsFutureTask = (logService = this.createOpenSearchLogService()).logData(moduleInstance, currentDateTime, logData, externalReferenceData)) != null) {
            this.loggingExecutorService.execute(informClientsFutureTask);
        }
        return new LogDataResult();
    }

    public List<LogServiceModuleInstance> getLogServicesUsingTargetIndexAliases(Set<String> aliases) throws LogServiceSettingsException {
        ArrayList<LogServiceModuleInstance> result = new ArrayList<LogServiceModuleInstance>();
        for (ModuleInstance moduleInstance : this.getModuleInstances().values()) {
            LogServiceModuleInstance.OpenSearchConfig openSearchConfig;
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
            if (!logServiceModuleInstance.isOpenSearchLoggingEnabled() || (openSearchConfig = logServiceModuleInstance.getOpenSearchConfig()) == null) continue;
            boolean found = false;
            if (openSearchConfig.parent != null && !StringUtil.isNullOrEmpty(openSearchConfig.parent.index) && aliases.contains(openSearchConfig.parent.index)) {
                found = true;
            }
            if (openSearchConfig.child != null && !StringUtil.isNullOrEmpty(openSearchConfig.child.index) && aliases.contains(openSearchConfig.child.index)) {
                found = true;
            }
            if (!found) continue;
            result.add(logServiceModuleInstance);
        }
        return result;
    }

    public void updateOpenSearchIndexMappings(LogServiceModuleInstance logServiceModuleInstance) {
        LOG.info("updateOpenSearchIndexMappings logServiceModuleInstance=...");
        try {
            OpenSearchLogService openSearchLogService = this.createOpenSearchLogService();
            openSearchLogService.updateOpenSearchIndexMappings(logServiceModuleInstance);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to update the OpenSearch index mapping of the log service module instance: " + logServiceModuleInstance, ex);
        }
    }

    public LogDataEntries getLogDataEntries(LogServiceModuleInstance logServiceModuleInstance, String timeZoneId, Integer start, Integer limit, String parentQuery, String parentFilter, String parentSort, String childSort, boolean addChilds) throws LogServiceException {
        LOG.info("getLogDataEntries logServiceModuleInstance=..., timeZoneId=" + timeZoneId + ", start=" + start + ", limit=" + limit + ", parentQuery=" + parentQuery + ", parentFilter=" + parentFilter + ", parentSort=" + parentSort + ", childSort=" + childSort + ", addChilds=" + addChilds);
        if (logServiceModuleInstance.isOpenSearchLoggingEnabled()) {
            OpenSearchLogService logService = this.createOpenSearchLogService();
            return logService.getLogDataEntries(this, logServiceModuleInstance, timeZoneId, start, limit, parentQuery, parentFilter, parentSort, childSort, addChilds);
        }
        if (logServiceModuleInstance.isDatabaseLoggingEnabled()) {
            DatabaseLogService logService = this.createDatabaseLogService(logServiceModuleInstance);
            return logService.getLogDataEntries(this, logServiceModuleInstance, timeZoneId, start, limit, parentQuery, parentFilter, parentSort, childSort, addChilds);
        }
        return null;
    }

    public LogDataEntries getLogDataEntries(LogServiceModuleInstance logServiceModuleInstance, String parentId) throws LogServiceException {
        LOG.info("getLogDataEntries logServiceModuleInstance=..., parentId=" + parentId);
        if (logServiceModuleInstance.isOpenSearchLoggingEnabled()) {
            OpenSearchLogService logService = this.createOpenSearchLogService();
            return logService.getLogDataEntries(logServiceModuleInstance, parentId);
        }
        if (logServiceModuleInstance.isDatabaseLoggingEnabled()) {
            DatabaseLogService logService = this.createDatabaseLogService(logServiceModuleInstance);
            return logService.getLogDataEntries(logServiceModuleInstance, parentId);
        }
        return null;
    }

    public LogDataEntries getLogDataEntries(LogServiceModuleInstance logServiceModuleInstance, String parentId, String timeZoneId, String childQuery, String childFilter) throws LogServiceException {
        LOG.info("getLogDataEntries logServiceModuleInstance=..., parentId=" + parentId + ", timeZoneId=" + timeZoneId + ", childQuery=" + childQuery + ", childFilter=" + childFilter);
        if (logServiceModuleInstance.isOpenSearchLoggingEnabled()) {
            OpenSearchLogService logService = this.createOpenSearchLogService();
            return logService.getLogDataEntries(logServiceModuleInstance, parentId, timeZoneId, childQuery, childFilter);
        }
        if (logServiceModuleInstance.isDatabaseLoggingEnabled()) {
            DatabaseLogService logService = this.createDatabaseLogService(logServiceModuleInstance);
            return logService.getLogDataEntries(logServiceModuleInstance, parentId, timeZoneId, childQuery, childFilter);
        }
        return null;
    }

    public LogDataEntries getLogDataEntries(LogServiceModuleInstance logServiceModuleInstance, String parentId, String childId) throws LogServiceException {
        LOG.info("getLogDataEntries logServiceModuleInstance=..., parentId=" + parentId + ", childId=" + childId);
        if (logServiceModuleInstance.isOpenSearchLoggingEnabled()) {
            OpenSearchLogService logService = this.createOpenSearchLogService();
            return logService.getLogDataEntries(logServiceModuleInstance, parentId, childId);
        }
        if (logServiceModuleInstance.isDatabaseLoggingEnabled()) {
            DatabaseLogService logService = this.createDatabaseLogService(logServiceModuleInstance);
            return logService.getLogDataEntries(logServiceModuleInstance, parentId, childId);
        }
        return null;
    }

    public void dropIndices(LogServiceModuleInstance moduleInstance) throws LogServiceException, OpenSearchRelatedException {
        LOG.info("dropIndices moduleInstance=...");
        if (moduleInstance != null) {
            OpenSearchLogService openSearchLogService = this.createOpenSearchLogService();
            openSearchLogService.dropIndices(moduleInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areUsedIndicesTemporaryUnavailable(LogServiceModuleInstance logServiceModuleInstance) throws LogServiceSettingsException {
        if (logServiceModuleInstance != null && logServiceModuleInstance.isOpenSearchLoggingEnabled()) {
            LogServiceModuleInstance.OpenSearchConfig openSearchConfig = logServiceModuleInstance.getOpenSearchConfig();
            Object object = INDICES_TEMPORARY_UNAVAILABLE_LOCK;
            synchronized (object) {
                if (openSearchConfig.parent != null && this.indicesTemporaryUnavailable.contains(openSearchConfig.parent.index)) {
                    return true;
                }
                if (openSearchConfig.child != null && this.indicesTemporaryUnavailable.contains(openSearchConfig.child.index)) {
                    return true;
                }
            }
        }
        return false;
    }

    private class DefaultLogServiceIndicesBackupSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private DefaultLogServiceIndicesBackupSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting setting) {
            LOG.info(this.getClass().getSimpleName() + ".processSetting setting=...");
            LogServiceModule.this.defaultLogServiceIndicesBackupSetting = setting;
        }
    }

    private class LogServiceModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private LogServiceModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOG.info(this.getClass().getSimpleName() + ".processLoadedModule module=...");
            LogServiceModule.this.restartBackupJobs();
        }
    }

    private class RestoreBackupStartEventHandler
    extends AbstractRestoreBackupStartEventHandler {
        private RestoreBackupStartEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processRestoreBackupStartEvent(AbstractRestoreBackupStartEventHandler.RestoreBackupStartEvent restoreBackupStartEvent) {
            LOG.info(this.getClass().getSimpleName() + ".processRestoreBackupStartEvent restoreBackupStartEvent=...");
            Object object = INDICES_TEMPORARY_UNAVAILABLE_LOCK;
            synchronized (object) {
                LogServiceModule.this.indicesTemporaryUnavailable.addAll(restoreBackupStartEvent.getAliasesOfBackupIndices());
            }
        }
    }

    private class RestoreBackupDoneEventHandler
    extends AbstractRestoreBackupDoneEventHandler {
        private RestoreBackupDoneEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processRestoreBackupDoneEvent(AbstractRestoreBackupDoneEventHandler.RestoreBackupDoneEvent restoreBackupDoneEvent) {
            LOG.info(this.getClass().getSimpleName() + ".processRestoreBackupDoneEvent restoreBackupDoneEvent=...");
            Object object = INDICES_TEMPORARY_UNAVAILABLE_LOCK;
            synchronized (object) {
                LogServiceModule.this.indicesTemporaryUnavailable.removeAll(restoreBackupDoneEvent.getAliasesOfBackupIndices());
            }
        }
    }
}

