/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice.db;

import de.virtimo.bpc.core.replicator.DatabaseProduct;
import de.virtimo.bpc.core.replicator.DbQueryBuilder;
import de.virtimo.bpc.logservice.db.PreparedStatementData;
import de.virtimo.bpc.util.MapUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class PreparedStatementBuilder {
    private static final Logger LOG = Logger.getLogger(PreparedStatementBuilder.class.getName());
    private DatabaseProduct.Identifier dbIdentifier;

    private PreparedStatementBuilder() {
    }

    public PreparedStatementBuilder(Connection dbConnection) {
        this.dbIdentifier = DatabaseProduct.getIdentifier(dbConnection);
    }

    public PreparedStatementBuilder(DatabaseProduct.Identifier dbIdentifier) {
        this.dbIdentifier = dbIdentifier;
    }

    public PreparedStatementData createInsertStatement(String tableName, Map<String, Object> columnData) {
        LOG.fine("createInsertStatement tableName=" + tableName + ", columnData=...");
        LinkedHashMap<String, Object> orderedColumnData = new LinkedHashMap<String, Object>();
        for (String column : columnData.keySet()) {
            orderedColumnData.put(column, columnData.get(column));
        }
        String sql = new DbQueryBuilder(this.dbIdentifier).withQuery("INSERT INTO $TABLE ($COLUMN[, ]) VALUES ($?[])").withPlaceHolders(MapUtil.mapOf("$TABLE", tableName, "$COLUMN[, ]", columnData.keySet(), "$?[]", columnData.size())).build();
        return new PreparedStatementData(sql, orderedColumnData);
    }

    public PreparedStatementData createUpdateStatement(String tableName, Map<String, Object> columnData, List<String> keys) {
        LOG.fine("createUpdateStatement tableName=" + tableName + ", columnData=..., keys=" + keys);
        HashSet<String> lowerCaseKeys = new HashSet<String>();
        for (String string : keys) {
            lowerCaseKeys.add(string.toLowerCase());
        }
        ArrayList<String> columnsToUpdate = new ArrayList<String>();
        for (String column : columnData.keySet()) {
            if (lowerCaseKeys.contains(column.toLowerCase())) continue;
            columnsToUpdate.add(column);
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        treeMap.putAll(columnData);
        String sql = new DbQueryBuilder(this.dbIdentifier).withQuery("UPDATE $TABLE SET $COLUMN=?[, ] WHERE $COLUMN=?[ AND ]").withPlaceHolders(MapUtil.mapOf("$TABLE", tableName, "$COLUMN=?[, ]", columnsToUpdate, "$COLUMN=?[ AND ]", keys)).build();
        LinkedHashMap<String, Object> orderedColumnData = new LinkedHashMap<String, Object>();
        for (String columnToUpdate : columnsToUpdate) {
            orderedColumnData.put(columnToUpdate, columnData.get(columnToUpdate));
        }
        for (String key : keys) {
            orderedColumnData.put(key, treeMap.get(key));
        }
        return new PreparedStatementData(sql, orderedColumnData);
    }

    public PreparedStatementData createDeleteStatement(String tableName, Map<String, Object> columnData, List<String> keys) {
        LOG.fine("createDeleteStatement tableName=" + tableName + ", columnData=..., keys=" + keys);
        String sql = new DbQueryBuilder(this.dbIdentifier).withQuery("DELETE FROM $TABLE WHERE $COLUMN=?[ AND ]").withPlaceHolders(MapUtil.mapOf("$TABLE", tableName, "$COLUMN=?[ AND ]", keys)).build();
        TreeMap<String, Object> columnDataWithCaseInsensitiveKeys = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        columnDataWithCaseInsensitiveKeys.putAll(columnData);
        LinkedHashMap<String, Object> orderedColumnData = new LinkedHashMap<String, Object>();
        for (String key : keys) {
            orderedColumnData.put(key, columnDataWithCaseInsensitiveKeys.get(key));
        }
        return new PreparedStatementData(sql, orderedColumnData);
    }
}

