/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module;

import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.module.AbstractInstantiableModule;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;

public abstract class AbstractModuleInstance
implements ModuleInstance,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(AbstractModuleInstance.class.getName());
    private InstantiableModule parentModule;
    private String moduleId;
    private String instanceType;
    private ModuleConfiguration moduleConfiguration;
    private Bundle moduleBundle;

    public AbstractModuleInstance(InstantiableModule pm) {
        this(pm, null, "none", "none");
    }

    public AbstractModuleInstance(InstantiableModule pm, ModuleConfiguration mc) {
        this(pm, mc, "noinstance", "none");
    }

    public AbstractModuleInstance(InstantiableModule pm, ModuleConfiguration mc, String instanceId) {
        this(pm, mc, instanceId, "none");
    }

    public AbstractModuleInstance(InstantiableModule pm, ModuleConfiguration mc, String instanceId, String instanceType) {
        this.parentModule = pm;
        this.moduleId = instanceId;
        this.instanceType = instanceType;
        if (mc == null) {
            this.setConfiguration(this.getDefaultConfiguration());
        } else {
            this.setConfiguration(mc);
        }
        LOG.info(this.getClass().getSimpleName() + " (" + this.moduleId + "): New module instance of type '" + instanceType + "' created");
    }

    @Override
    public void destroy() {
        LOG.info(this.getClass().getSimpleName() + ": destroy");
        ModuleConfiguration currentModuleConfiguration = this.moduleConfiguration;
        if (currentModuleConfiguration != null) {
            currentModuleConfiguration.removePropertyChangeListener(this);
            currentModuleConfiguration.destroy();
        }
        this.moduleConfiguration = null;
        this.parentModule = null;
    }

    @Override
    public Bundle getModuleBundle() {
        if (this.moduleBundle == null) {
            return this.parentModule.getModuleBundle();
        }
        return this.moduleBundle;
    }

    @Override
    public void setModuleBundle(Bundle moduleBundle) {
        this.moduleBundle = moduleBundle;
    }

    @Override
    public ModuleConfiguration getDefaultConfiguration() {
        if (this.parentModule instanceof AbstractInstantiableModule) {
            return ((AbstractInstantiableModule)this.parentModule).getCachedDefaultInstanceConfiguration(this.instanceType);
        }
        return this.parentModule.getDefaultInstanceConfiguration(this.instanceType);
    }

    @Override
    public String getModuleId() {
        return this.moduleId;
    }

    @Override
    public String getModuleName() {
        return this.parentModule.getModuleName();
    }

    @Override
    public String getInstanceType() {
        return this.instanceType;
    }

    @Override
    public void setConfiguration(ModuleConfiguration moduleConfiguration) {
        LOG.info(this.getClass().getSimpleName() + " (" + this.getModuleId() + "): setConfiguration");
        moduleConfiguration.setOwnerModule(this);
        ModuleConfiguration oldModuleConfiguration = this.moduleConfiguration;
        if (oldModuleConfiguration != null) {
            oldModuleConfiguration.removePropertyChangeListener(this);
        }
        moduleConfiguration.addPropertyChangeListener(this);
        this.moduleConfiguration = moduleConfiguration;
        this.applyUpdatedConfiguration();
    }

    @Override
    public ModuleConfiguration getConfiguration() {
        return this.moduleConfiguration;
    }

    public String toString() {
        return this.moduleId;
    }

    @Override
    public InstantiableModule getParentModule() {
        return this.parentModule;
    }

    @Override
    public ModuleManager getModuleManager() {
        return this.parentModule.getModuleManager();
    }

    @Override
    public void deleteInstance() {
        LOG.info(this.getClass().getSimpleName() + " (" + this.getModuleId() + "): deleteInstance");
        this.parentModule.deleteModuleInstance(this.getModuleId());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LOG.info(this.getClass().getSimpleName() + " (" + this.getModuleId() + "): Got a property change event: " + evt);
        if (evt.getSource() instanceof ModuleConfiguration) {
            this.applyUpdatedConfiguration();
        }
    }

    protected void applyUpdatedConfiguration() {
        LOG.info(this.getClass().getSimpleName() + " (" + this.getModuleId() + "): applyUpdatedConfiguration");
    }

    public String loadJsonFileAsString(String fileName) {
        return JsonDefaultsUtil.loadJsonFileAsString(this.getModuleBundle(), fileName);
    }
}

