/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.simple;

import de.virtimo.bpc.api.CustomFields;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.MapUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;

public class CustomFieldsImpl
implements CustomFields {
    private static final Logger LOG = Logger.getLogger(CustomFieldsImpl.class.getName());
    public static final String ProtectedFieldNamePrefix = "_";
    private final Map<String, Object> fields;

    public CustomFieldsImpl() {
        this.fields = new HashMap<String, Object>();
    }

    public CustomFieldsImpl(CustomFields otherCustomFields) {
        this.fields = otherCustomFields instanceof CustomFieldsImpl ? this.cleanedFields(((CustomFieldsImpl)otherCustomFields).fields) : new HashMap<String, Object>();
    }

    public CustomFieldsImpl(Map<String, Object> map) {
        this.fields = map != null ? this.cleanedFields(map) : new HashMap<String, Object>();
    }

    private Map<String, Object> cleanedFields(Map<String, Object> map) {
        LOG.fine("cleanedFields map=" + map);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (map != null) {
            for (String fieldName : map.keySet()) {
                Object fieldValue;
                if ("customFields".equals(fieldName)) {
                    fieldValue = map.get(fieldName);
                    if (!(fieldValue instanceof Map)) continue;
                    Map m = (Map)fieldValue;
                    result.putAll(this.cleanedFields(m));
                    continue;
                }
                if (!this.isValidField(fieldName)) continue;
                fieldValue = map.get(fieldName);
                result.put(fieldName, fieldValue);
            }
        }
        return result;
    }

    private boolean isValidField(String fieldName) {
        if (fieldName == null) {
            return false;
        }
        return !SimpleSettingImpl.ReservedFieldNames.contains(fieldName);
    }

    @Override
    public void clear() {
        if (this.fields != null) {
            this.fields.clear();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.fields == null || this.fields.isEmpty();
    }

    @Override
    public boolean existsField(String field) {
        return this.fields != null && this.fields.containsKey(field);
    }

    @Override
    public Set<String> getFieldNames() {
        if (this.fields == null) {
            return new HashSet<String>();
        }
        return new HashSet<String>(this.fields.keySet());
    }

    @Override
    public Object removeField(String fieldName) {
        if (this.fields != null) {
            return this.fields.remove(fieldName);
        }
        return null;
    }

    @Override
    public void overwriteProtectedFieldsWith(CustomFields otherCustomFields) {
        LOG.fine("overwriteProtectedFieldsWith otherCustomFields=" + otherCustomFields);
        Set<String> thisFieldNames = this.getFieldNames();
        Set<String> otherFieldNames = otherCustomFields.getFieldNames();
        for (String thisFieldName : thisFieldNames) {
            if (!thisFieldName.startsWith(ProtectedFieldNamePrefix) || otherFieldNames.contains(thisFieldName)) continue;
            this.removeField(thisFieldName);
        }
        for (String otherFieldName : otherFieldNames) {
            if (!otherFieldName.startsWith(ProtectedFieldNamePrefix)) continue;
            Object otherCustomFieldValue = otherCustomFields.getObjectValue(otherFieldName);
            this.setObjectValue(otherFieldName, otherCustomFieldValue);
        }
    }

    @Override
    public void overwriteProtectedFieldsWith(CustomFields otherCustomFields, Set<String> onlyForThisFieldNames) {
        LOG.fine("overwriteProtectedFieldsWith otherCustomFields=" + otherCustomFields + ", onlyForThisFieldNames=" + onlyForThisFieldNames);
        if (!(this.isEmpty() || otherCustomFields.isEmpty() || onlyForThisFieldNames.isEmpty())) {
            for (String fieldName : onlyForThisFieldNames) {
                Object otherCustomFieldValue;
                if (!fieldName.startsWith(ProtectedFieldNamePrefix) || (otherCustomFieldValue = otherCustomFields.getObjectValue(fieldName)) == null) continue;
                this.setObjectValue(fieldName, otherCustomFieldValue);
            }
        }
    }

    @Override
    public Object getObjectValue(String fieldName) {
        return this.getObjectValue(fieldName, null);
    }

    @Override
    public Object getObjectValue(String fieldName, Object defaultValue) {
        Object result = this.fields.get(fieldName);
        return result == null ? defaultValue : result;
    }

    @Override
    public String getStringValue(String fieldName) {
        return this.getStringValue(fieldName, null);
    }

    @Override
    public String getStringValue(String fieldName, String defaultValue) {
        return MapUtil.getValueAsString(this.fields, fieldName, defaultValue);
    }

    @Override
    public int getIntValue(String fieldName) {
        return this.getIntValue(fieldName, Integer.MIN_VALUE);
    }

    @Override
    public int getIntValue(String fieldName, int defaultValue) {
        return MapUtil.getValueAsInt(this.fields, fieldName, defaultValue);
    }

    @Override
    public long getLongValue(String fieldName) {
        return this.getLongValue(fieldName, Long.MIN_VALUE);
    }

    @Override
    public long getLongValue(String fieldName, long defaultValue) {
        return MapUtil.getValueAsLong(this.fields, fieldName, defaultValue);
    }

    @Override
    public boolean getBooleanValue(String fieldName) {
        return this.getBooleanValue(fieldName, false);
    }

    @Override
    public boolean getBooleanValue(String fieldName, boolean defaultValue) {
        return MapUtil.getValueAsBoolean(this.fields, fieldName, defaultValue);
    }

    @Override
    public void setObjectValue(String fieldName, Object value) {
        if (this.isValidField(fieldName)) {
            this.fields.put(fieldName, value);
        }
    }

    @Override
    public void setStringValue(String fieldName, String value) {
        if (this.isValidField(fieldName)) {
            this.fields.put(fieldName, value);
        }
    }

    @Override
    public void setIntValue(String fieldName, int value) {
        if (this.isValidField(fieldName)) {
            this.fields.put(fieldName, value);
        }
    }

    @Override
    public void setLongValue(String fieldName, long value) {
        if (this.isValidField(fieldName)) {
            this.fields.put(fieldName, value);
        }
    }

    @Override
    public void setBooleanValue(String fieldName, boolean value) {
        if (this.isValidField(fieldName)) {
            this.fields.put(fieldName, value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomFieldsImpl that = (CustomFieldsImpl)o;
        return Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    public String toString() {
        return "CustomFields{fields=" + this.fields + "}";
    }
}

