/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.util;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class DictionaryUtil {
    public static Dictionary<String, Object> dictionaryOf(Object ... keyValuePairs) throws IllegalArgumentException {
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("keyValuePairs must be given as pairs of 2");
        }
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            Object key = keyValuePairs[i];
            Object value = keyValuePairs[i + 1];
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Keys must be of type String");
            }
            String keyAsString = (String)key;
            ((Dictionary)result).put(keyAsString, value);
        }
        return result;
    }

    public static <K, V> Map<K, V> convertToMap(Dictionary<K, V> dictionary) {
        if (dictionary == null) {
            return null;
        }
        HashMap<K, V> map = new HashMap<K, V>(dictionary.size());
        Enumeration<K> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            K key = keys.nextElement();
            map.put(key, dictionary.get(key));
        }
        return map;
    }
}

