/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.shards;

import java.util.List;
import java.util.Objects;
import org.opensearch.action.admin.cluster.shards.CatShardsRequest;
import org.opensearch.action.admin.cluster.shards.CatShardsResponse;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.action.pagination.PageParams;
import org.opensearch.action.pagination.ShardPaginationStrategy;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.TimeoutTaskCancellationUtility;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.breaker.ResponseLimitBreachedException;
import org.opensearch.common.breaker.ResponseLimitSettings;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.NotifyOnceListener;
import org.opensearch.tasks.CancellableTask;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportCatShardsAction
extends HandledTransportAction<CatShardsRequest, CatShardsResponse> {
    private final NodeClient client;
    private final ResponseLimitSettings responseLimitSettings;

    @Inject
    public TransportCatShardsAction(NodeClient client, TransportService transportService, ActionFilters actionFilters, ResponseLimitSettings responseLimitSettings) {
        super("cluster:monitor/shards", transportService, actionFilters, CatShardsRequest::new);
        this.client = client;
        this.responseLimitSettings = responseLimitSettings;
    }

    @Override
    public void doExecute(final Task parentTask, final CatShardsRequest shardsRequest, final ActionListener<CatShardsResponse> listener) {
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.setShouldCancelOnTimeout(true);
        clusterStateRequest.local(shardsRequest.local());
        clusterStateRequest.clusterManagerNodeTimeout(shardsRequest.clusterManagerNodeTimeout());
        if (Objects.isNull(shardsRequest.getPageParams())) {
            clusterStateRequest.clear().nodes(true).routingTable(true).indices(shardsRequest.getIndices());
        } else {
            clusterStateRequest.clear().nodes(true).routingTable(true).indices(shardsRequest.getIndices()).metadata(true);
        }
        assert (parentTask instanceof CancellableTask);
        clusterStateRequest.setParentTask(this.client.getLocalNodeId(), parentTask.getId());
        NotifyOnceListener<CatShardsResponse> originalListener = new NotifyOnceListener<CatShardsResponse>(){

            @Override
            protected void innerOnResponse(CatShardsResponse catShardsResponse) {
                listener.onResponse(catShardsResponse);
            }

            @Override
            protected void innerOnFailure(Exception e) {
                listener.onFailure(e);
            }
        };
        final ActionListener<CatShardsResponse> cancellableListener = TimeoutTaskCancellationUtility.wrapWithCancellationListener(this.client, (CancellableTask)parentTask, ((CancellableTask)parentTask).getCancellationTimeout(), originalListener, e -> originalListener.onFailure(e));
        final CatShardsResponse catShardsResponse = new CatShardsResponse();
        try {
            this.client.admin().cluster().state(clusterStateRequest, new ActionListener<ClusterStateResponse>(){

                @Override
                public void onResponse(ClusterStateResponse clusterStateResponse) {
                    TransportCatShardsAction.this.validateRequestLimit(shardsRequest, clusterStateResponse, cancellableListener);
                    try {
                        String[] indices;
                        ShardPaginationStrategy paginationStrategy = TransportCatShardsAction.this.getPaginationStrategy(shardsRequest.getPageParams(), clusterStateResponse);
                        catShardsResponse.setNodes(clusterStateResponse.getState().getNodes());
                        catShardsResponse.setResponseShards(Objects.isNull(paginationStrategy) ? clusterStateResponse.getState().routingTable().allShards() : paginationStrategy.getRequestedEntities());
                        catShardsResponse.setPageToken(Objects.isNull(paginationStrategy) ? null : paginationStrategy.getResponseToken());
                        String[] stringArray = indices = Objects.isNull(paginationStrategy) ? shardsRequest.getIndices() : TransportCatShardsAction.this.filterClosedIndices(clusterStateResponse.getState(), paginationStrategy.getRequestedIndices());
                        if (TransportCatShardsAction.this.shouldSkipIndicesStatsRequest(paginationStrategy, indices)) {
                            catShardsResponse.setIndicesStatsResponse(IndicesStatsResponse.getEmptyResponse());
                            cancellableListener.onResponse(catShardsResponse);
                            return;
                        }
                        IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
                        indicesStatsRequest.setShouldCancelOnTimeout(true);
                        indicesStatsRequest.all();
                        indicesStatsRequest.indices(indices);
                        indicesStatsRequest.setParentTask(TransportCatShardsAction.this.client.getLocalNodeId(), parentTask.getId());
                        TransportCatShardsAction.this.client.admin().indices().stats(indicesStatsRequest, new ActionListener<IndicesStatsResponse>(){

                            @Override
                            public void onResponse(IndicesStatsResponse indicesStatsResponse) {
                                catShardsResponse.setIndicesStatsResponse(indicesStatsResponse);
                                cancellableListener.onResponse(catShardsResponse);
                            }

                            @Override
                            public void onFailure(Exception e) {
                                cancellableListener.onFailure(e);
                            }
                        });
                    }
                    catch (Exception e) {
                        cancellableListener.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    cancellableListener.onFailure(e);
                }
            });
        }
        catch (Exception e2) {
            cancellableListener.onFailure(e2);
        }
    }

    private ShardPaginationStrategy getPaginationStrategy(PageParams pageParams, ClusterStateResponse clusterStateResponse) {
        return Objects.isNull(pageParams) ? null : new ShardPaginationStrategy(pageParams, clusterStateResponse.getState());
    }

    private void validateRequestLimit(CatShardsRequest shardsRequest, ClusterStateResponse clusterStateResponse, ActionListener<CatShardsResponse> listener) {
        if (shardsRequest.isRequestLimitCheckSupported() && Objects.nonNull(clusterStateResponse) && Objects.nonNull(clusterStateResponse.getState())) {
            int limit = this.responseLimitSettings.getCatShardsResponseLimit();
            if (ResponseLimitSettings.isResponseLimitBreached(clusterStateResponse.getState().getRoutingTable(), ResponseLimitSettings.LimitEntity.SHARDS, limit)) {
                listener.onFailure(new ResponseLimitBreachedException("Too many shards requested.", limit, ResponseLimitSettings.LimitEntity.SHARDS));
            }
        }
    }

    private boolean shouldSkipIndicesStatsRequest(ShardPaginationStrategy paginationStrategy, String[] indices) {
        return Objects.nonNull(paginationStrategy) && (indices == null || indices.length == 0);
    }

    private String[] filterClosedIndices(ClusterState clusterState, List<String> strategyIndices) {
        return (String[])strategyIndices.stream().filter(index -> {
            IndexMetadata metadata = clusterState.metadata().indices().get(index);
            return metadata != null && !metadata.getState().equals((Object)IndexMetadata.State.CLOSE);
        }).toArray(String[]::new);
    }
}

