/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.PlainShardIterator;
import org.opensearch.cluster.routing.RotationShardShuffler;
import org.opensearch.cluster.routing.ShardIterator;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardRoutingState;
import org.opensearch.cluster.routing.ShardShuffler;
import org.opensearch.cluster.routing.WeightedRoundRobin;
import org.opensearch.cluster.routing.WeightedRouting;
import org.opensearch.common.Nullable;
import org.opensearch.common.Randomness;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.translog.BufferedChecksumStreamOutput;
import org.opensearch.node.ResponseCollectorService;

@PublicApi(since="1.0.0")
public class IndexShardRoutingTable
extends AbstractDiffable<IndexShardRoutingTable>
implements Iterable<ShardRouting> {
    final ShardShuffler shuffler;
    final ShardShuffler shufflerForWeightedRouting;
    final ShardId shardId;
    final ShardRouting primary;
    final List<ShardRouting> replicas;
    final List<ShardRouting> shards;
    final List<ShardRouting> activeShards;
    final List<ShardRouting> assignedShards;
    final Set<String> allAllocationIds;
    final boolean allShardsStarted;
    private volatile Map<AttributesKey, AttributesRoutings> activeShardsByAttributes = Collections.emptyMap();
    private volatile Map<AttributesKey, AttributesRoutings> initializingShardsByAttributes = Collections.emptyMap();
    private final Object shardsByAttributeMutex = new Object();
    private final Object shardsByWeightMutex = new Object();
    private volatile Map<WeightedRoutingKey, WeightedShardRoutings> activeShardsByWeight = Collections.emptyMap();
    private volatile Map<WeightedRoutingKey, WeightedShardRoutings> initializingShardsByWeight = Collections.emptyMap();
    private static final Logger logger = LogManager.getLogger(IndexShardRoutingTable.class);
    final List<ShardRouting> allInitializingShards;

    IndexShardRoutingTable(ShardId shardId, List<ShardRouting> shards) {
        this.shardId = shardId;
        this.shuffler = new RotationShardShuffler(Randomness.get().nextInt());
        this.shufflerForWeightedRouting = new RotationShardShuffler(Randomness.get().nextInt());
        this.shards = Collections.unmodifiableList(shards);
        ShardRouting primary = null;
        ArrayList<ShardRouting> replicas = new ArrayList<ShardRouting>();
        ArrayList<ShardRouting> activeShards = new ArrayList<ShardRouting>();
        ArrayList<ShardRouting> assignedShards = new ArrayList<ShardRouting>();
        ArrayList<ShardRouting> allInitializingShards = new ArrayList<ShardRouting>();
        HashSet<String> allAllocationIds = new HashSet<String>();
        boolean allShardsStarted = true;
        for (ShardRouting shard : shards) {
            if (shard.primary()) {
                primary = shard;
            } else {
                replicas.add(shard);
            }
            if (shard.active()) {
                activeShards.add(shard);
            }
            if (shard.initializing()) {
                allInitializingShards.add(shard);
            }
            if (shard.isSearchOnly()) {
                if (shard.relocating()) {
                    allInitializingShards.add(shard.getTargetRelocatingShard());
                    assignedShards.add(shard.getTargetRelocatingShard());
                }
                if (shard.assignedToNode()) {
                    assignedShards.add(shard);
                }
                assert (shard.allocationId() == null || !allAllocationIds.contains(shard.allocationId().getId())) : "Search replicas should not be part of the allAllocationId set";
                continue;
            }
            if (shard.relocating()) {
                allInitializingShards.add(shard.getTargetRelocatingShard());
                allAllocationIds.add(shard.getTargetRelocatingShard().allocationId().getId());
                assert (shard.assignedToNode()) : "relocating from unassigned " + String.valueOf(shard);
                assert (shard.getTargetRelocatingShard().assignedToNode()) : "relocating to unassigned " + String.valueOf(shard.getTargetRelocatingShard());
                assignedShards.add(shard.getTargetRelocatingShard());
            }
            if (shard.assignedToNode()) {
                assignedShards.add(shard);
                allAllocationIds.add(shard.allocationId().getId());
            }
            if (shard.state() == ShardRoutingState.STARTED) continue;
            allShardsStarted = false;
        }
        this.allShardsStarted = allShardsStarted;
        this.primary = primary;
        this.replicas = Collections.unmodifiableList(replicas);
        this.activeShards = Collections.unmodifiableList(activeShards);
        this.assignedShards = Collections.unmodifiableList(assignedShards);
        this.allInitializingShards = Collections.unmodifiableList(allInitializingShards);
        this.allAllocationIds = Collections.unmodifiableSet(allAllocationIds);
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public ShardId getShardId() {
        return this.shardId();
    }

    @Override
    public Iterator<ShardRouting> iterator() {
        return this.shards.iterator();
    }

    public int size() {
        return this.shards.size();
    }

    public int getSize() {
        return this.size();
    }

    public List<ShardRouting> shards() {
        return this.shards;
    }

    public List<ShardRouting> getShards() {
        return this.shards();
    }

    public List<ShardRouting> searchOnlyReplicas() {
        return this.replicas.stream().filter(ShardRouting::isSearchOnly).collect(Collectors.toList());
    }

    public List<ShardRouting> writerReplicas() {
        return this.replicas.stream().filter(r -> !r.isSearchOnly()).collect(Collectors.toList());
    }

    public List<ShardRouting> activeShards() {
        return this.activeShards;
    }

    public List<ShardRouting> getAllInitializingShards() {
        return this.allInitializingShards;
    }

    public List<ShardRouting> getActiveShards() {
        return this.activeShards();
    }

    public List<ShardRouting> assignedShards() {
        return this.assignedShards;
    }

    public Map<WeightedRoutingKey, WeightedShardRoutings> getActiveShardsByWeight() {
        return this.activeShardsByWeight;
    }

    public ShardIterator shardsRandomIt() {
        return new PlainShardIterator(this.shardId, this.shuffler.shuffle(this.shards));
    }

    public ShardIterator shardsIt() {
        return new PlainShardIterator(this.shardId, this.shards);
    }

    public ShardIterator shardsIt(int seed) {
        return new PlainShardIterator(this.shardId, this.shuffler.shuffle(this.shards, seed));
    }

    public ShardIterator activeInitializingShardsRandomIt() {
        return this.activeInitializingShardsIt(this.shuffler.nextSeed());
    }

    public ShardIterator activeInitializingShardsIt(int seed) {
        if (this.allInitializingShards.isEmpty()) {
            return new PlainShardIterator(this.shardId, this.shuffler.shuffle(this.activeShards, seed));
        }
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        ordered.addAll(this.shuffler.shuffle(this.activeShards, seed));
        ordered.addAll(this.allInitializingShards);
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardIterator activeInitializingShardsRankedIt(@Nullable ResponseCollectorService collector, @Nullable Map<String, Long> nodeSearchCounts) {
        int seed = this.shuffler.nextSeed();
        if (this.allInitializingShards.isEmpty()) {
            return new PlainShardIterator(this.shardId, IndexShardRoutingTable.rankShardsAndUpdateStats(this.shuffler.shuffle(this.activeShards, seed), collector, nodeSearchCounts));
        }
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        List<ShardRouting> rankedActiveShards = IndexShardRoutingTable.rankShardsAndUpdateStats(this.shuffler.shuffle(this.activeShards, seed), collector, nodeSearchCounts);
        ordered.addAll(rankedActiveShards);
        List<ShardRouting> rankedInitializingShards = IndexShardRoutingTable.rankShardsAndUpdateStats(this.allInitializingShards, collector, nodeSearchCounts);
        ordered.addAll(rankedInitializingShards);
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardIterator activeInitializingShardsWeightedIt(WeightedRouting weightedRouting, DiscoveryNodes nodes, double defaultWeight, boolean isFailOpenEnabled, @Nullable Integer seed) {
        if (seed == null) {
            seed = this.shufflerForWeightedRouting.nextSeed();
        }
        List<ShardRouting> ordered = this.activeInitializingShardsWithWeights(weightedRouting, nodes, defaultWeight, seed);
        if (isFailOpenEnabled) {
            ordered.addAll(this.activeInitializingShardsWithoutWeights(weightedRouting, nodes, defaultWeight));
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    private List<ShardRouting> activeInitializingShardsWithWeights(WeightedRouting weightedRouting, DiscoveryNodes nodes, double defaultWeight, int seed) {
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>();
        List<ShardRouting> orderedActiveShards = this.getActiveShardsByWeight(weightedRouting, nodes, defaultWeight);
        ordered.addAll(this.shufflerForWeightedRouting.shuffle(orderedActiveShards, seed));
        if (!this.allInitializingShards.isEmpty()) {
            List<ShardRouting> orderedInitializingShards = this.getInitializingShardsByWeight(weightedRouting, nodes, defaultWeight);
            ordered.addAll(orderedInitializingShards);
        }
        List<ShardRouting> orderedListWithDistinctShards = ordered.stream().distinct().collect(Collectors.toList());
        return orderedListWithDistinctShards;
    }

    private List<ShardRouting> activeInitializingShardsWithoutWeights(WeightedRouting weightedRouting, DiscoveryNodes nodes, double defaultWeight) {
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.getActiveShardsWithoutWeight(weightedRouting, nodes, defaultWeight));
        if (!this.allInitializingShards.isEmpty()) {
            ordered.addAll(this.getInitializingShardsWithoutWeight(weightedRouting, nodes, defaultWeight));
        }
        return ordered.stream().distinct().collect(Collectors.toList());
    }

    private List<ShardRouting> shardsOrderedByWeight(List<ShardRouting> shards, WeightedRouting weightedRouting, DiscoveryNodes nodes, double defaultWeight) {
        WeightedRoundRobin weightedRoundRobin = new WeightedRoundRobin(this.calculateShardWeight(shards, weightedRouting, nodes, defaultWeight));
        List shardsOrderedbyWeight = weightedRoundRobin.orderEntities();
        ArrayList<ShardRouting> orderedShardRouting = new ArrayList<ShardRouting>(this.activeShards.size());
        if (shardsOrderedbyWeight != null) {
            for (WeightedRoundRobin.Entity shardRouting : shardsOrderedbyWeight) {
                orderedShardRouting.add((ShardRouting)shardRouting.getTarget());
            }
        }
        return orderedShardRouting;
    }

    private List<WeightedRoundRobin.Entity<ShardRouting>> calculateShardWeight(List<ShardRouting> shards, WeightedRouting weightedRouting, DiscoveryNodes nodes, double defaultWeight) {
        ArrayList<WeightedRoundRobin.Entity<ShardRouting>> shardsWithWeights = new ArrayList<WeightedRoundRobin.Entity<ShardRouting>>();
        for (ShardRouting shard : shards) {
            DiscoveryNode node = nodes.get(shard.currentNodeId());
            if (node == null) continue;
            String attVal = node.getAttributes().get(weightedRouting.attributeName());
            Double weight = weightedRouting.weights().getOrDefault(attVal, defaultWeight);
            shardsWithWeights.add(new WeightedRoundRobin.Entity<ShardRouting>(weight, shard));
        }
        return shardsWithWeights;
    }

    private static Set<String> getAllNodeIds(List<ShardRouting> shards) {
        HashSet<String> nodeIds = new HashSet<String>();
        for (ShardRouting shard : shards) {
            nodeIds.add(shard.currentNodeId());
        }
        return nodeIds;
    }

    private static Map<String, Optional<ResponseCollectorService.ComputedNodeStats>> getNodeStats(Set<String> nodeIds, ResponseCollectorService collector) {
        HashMap<String, Optional<ResponseCollectorService.ComputedNodeStats>> nodeStats = new HashMap<String, Optional<ResponseCollectorService.ComputedNodeStats>>(nodeIds.size());
        for (String nodeId : nodeIds) {
            nodeStats.put(nodeId, collector.getNodeStatistics(nodeId));
        }
        return nodeStats;
    }

    private static Map<String, Double> rankNodes(Map<String, Optional<ResponseCollectorService.ComputedNodeStats>> nodeStats, Map<String, Long> nodeSearchCounts) {
        HashMap<String, Double> nodeRanks = new HashMap<String, Double>(nodeStats.size());
        for (Map.Entry<String, Optional<ResponseCollectorService.ComputedNodeStats>> entry : nodeStats.entrySet()) {
            Optional<ResponseCollectorService.ComputedNodeStats> maybeStats = entry.getValue();
            maybeStats.ifPresent(stats -> {
                String nodeId = (String)entry.getKey();
                nodeRanks.put(nodeId, stats.rank(nodeSearchCounts.getOrDefault(nodeId, 1L)));
            });
        }
        return nodeRanks;
    }

    private static void adjustStats(ResponseCollectorService collector, Map<String, Optional<ResponseCollectorService.ComputedNodeStats>> nodeStats, String minNodeId, ResponseCollectorService.ComputedNodeStats minStats) {
        if (minNodeId != null) {
            for (Map.Entry<String, Optional<ResponseCollectorService.ComputedNodeStats>> entry : nodeStats.entrySet()) {
                String nodeId = entry.getKey();
                Optional<ResponseCollectorService.ComputedNodeStats> maybeStats = entry.getValue();
                if (nodeId.equals(minNodeId) || !maybeStats.isPresent()) continue;
                ResponseCollectorService.ComputedNodeStats stats = maybeStats.get();
                int updatedQueue = (minStats.queueSize + stats.queueSize) / 2;
                long updatedResponse = (long)(minStats.responseTime + stats.responseTime) / 2L;
                long updatedService = (long)(minStats.serviceTime + stats.serviceTime) / 2L;
                collector.addNodeStatistics(nodeId, updatedQueue, updatedResponse, updatedService);
            }
        }
    }

    private static List<ShardRouting> rankShardsAndUpdateStats(List<ShardRouting> shards, ResponseCollectorService collector, Map<String, Long> nodeSearchCounts) {
        String minNodeId;
        Optional<ResponseCollectorService.ComputedNodeStats> maybeMinStats;
        ShardRouting minShard;
        if (collector == null || nodeSearchCounts == null || shards.size() <= 1) {
            return shards;
        }
        Set<String> nodeIds = IndexShardRoutingTable.getAllNodeIds(shards);
        Map<String, Optional<ResponseCollectorService.ComputedNodeStats>> nodeStats = IndexShardRoutingTable.getNodeStats(nodeIds, collector);
        Map<String, Double> nodeRanks = IndexShardRoutingTable.rankNodes(nodeStats, nodeSearchCounts);
        ArrayList<ShardRouting> sortedShards = new ArrayList<ShardRouting>(shards);
        Collections.sort(sortedShards, new NodeRankComparator(nodeRanks));
        if (sortedShards.size() > 1 && (minShard = sortedShards.get(0)).started() && (maybeMinStats = nodeStats.get(minNodeId = minShard.currentNodeId())).isPresent()) {
            IndexShardRoutingTable.adjustStats(collector, nodeStats, minNodeId, maybeMinStats.get());
            nodeSearchCounts.compute(minNodeId, (id, conns) -> conns == null ? 1L : conns + 1L);
        }
        return sortedShards;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardId().getIndex().writeTo(out);
        Builder.writeToThin(this, out);
    }

    public ShardIterator primaryShardIt() {
        if (this.primary != null) {
            return new PlainShardIterator(this.shardId, Collections.singletonList(this.primary));
        }
        return new PlainShardIterator(this.shardId, Collections.emptyList());
    }

    private boolean noPrimariesActive() {
        return this.primary != null && !this.primary.active() && !this.primary.initializing();
    }

    public ShardIterator primaryActiveInitializingShardIt() {
        if (this.noPrimariesActive()) {
            return new PlainShardIterator(this.shardId, Collections.emptyList());
        }
        return this.primaryShardIt();
    }

    public ShardIterator primaryFirstActiveInitializingShardsIt() {
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        for (ShardRouting shardRouting : this.shuffler.shuffle(this.activeShards)) {
            ordered.add(shardRouting);
            if (!shardRouting.primary()) continue;
            ordered.set(ordered.size() - 1, ordered.get(0));
            ordered.set(0, shardRouting);
        }
        if (!this.allInitializingShards.isEmpty()) {
            ordered.addAll(this.allInitializingShards);
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardIterator replicaActiveInitializingShardIt() {
        if (this.noPrimariesActive()) {
            return new PlainShardIterator(this.shardId, Collections.emptyList());
        }
        return this.filterAndOrderShards(replica -> true);
    }

    public ShardIterator searchReplicaActiveInitializingShardIt() {
        return this.filterAndOrderShards(ShardRouting::isSearchOnly);
    }

    public ShardIterator replicaFirstActiveInitializingShardsIt() {
        if (this.noPrimariesActive()) {
            return new PlainShardIterator(this.shardId, Collections.emptyList());
        }
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        for (ShardRouting replica : this.shuffler.shuffle(this.replicas)) {
            if (!replica.active()) continue;
            ordered.add(replica);
        }
        ordered.add(this.primary);
        if (!this.allInitializingShards.isEmpty()) {
            ordered.addAll(this.allInitializingShards);
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    private ShardIterator filterAndOrderShards(Predicate<ShardRouting> filter) {
        LinkedList<ShardRouting> ordered = new LinkedList<ShardRouting>();
        for (ShardRouting replica : this.shuffler.shuffle(this.replicas)) {
            if (!filter.test(replica)) continue;
            if (replica.active()) {
                ordered.addFirst(replica);
                continue;
            }
            if (!replica.initializing()) continue;
            ordered.addLast(replica);
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardIterator onlyNodeActiveInitializingShardsIt(String nodeId) {
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        int seed = this.shuffler.nextSeed();
        for (ShardRouting shardRouting : this.shuffler.shuffle(this.activeShards, seed)) {
            if (!nodeId.equals(shardRouting.currentNodeId())) continue;
            ordered.add(shardRouting);
        }
        for (ShardRouting shardRouting : this.shuffler.shuffle(this.allInitializingShards, seed)) {
            if (!nodeId.equals(shardRouting.currentNodeId())) continue;
            ordered.add(shardRouting);
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardIterator onlyNodeSelectorActiveInitializingShardsIt(String nodeAttributes, DiscoveryNodes discoveryNodes) {
        return this.onlyNodeSelectorActiveInitializingShardsIt(new String[]{nodeAttributes}, discoveryNodes);
    }

    public ShardIterator onlyNodeSelectorActiveInitializingShardsIt(String[] nodeAttributes, DiscoveryNodes discoveryNodes) {
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        HashSet<String> selectedNodes = Sets.newHashSet(discoveryNodes.resolveNodes(nodeAttributes));
        int seed = this.shuffler.nextSeed();
        for (ShardRouting shardRouting : this.shuffler.shuffle(this.activeShards, seed)) {
            if (!selectedNodes.contains(shardRouting.currentNodeId())) continue;
            ordered.add(shardRouting);
        }
        for (ShardRouting shardRouting : this.shuffler.shuffle(this.allInitializingShards, seed)) {
            if (!selectedNodes.contains(shardRouting.currentNodeId())) continue;
            ordered.add(shardRouting);
        }
        if (ordered.isEmpty()) {
            String message = String.format(Locale.ROOT, "no data nodes with %s [%s] found for shard: %s", nodeAttributes.length == 1 ? "criteria" : "criterion", String.join((CharSequence)",", nodeAttributes), this.shardId());
            throw new IllegalArgumentException(message);
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardIterator preferNodeActiveInitializingShardsIt(Set<String> nodeIds) {
        ArrayList<ShardRouting> preferred = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        ArrayList<ShardRouting> notPreferred = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        for (ShardRouting shardRouting : this.shuffler.shuffle(this.activeShards)) {
            if (nodeIds.contains(shardRouting.currentNodeId())) {
                preferred.add(shardRouting);
                continue;
            }
            notPreferred.add(shardRouting);
        }
        preferred.addAll(notPreferred);
        if (!this.allInitializingShards.isEmpty()) {
            preferred.addAll(this.allInitializingShards);
        }
        return new PlainShardIterator(this.shardId, preferred);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexShardRoutingTable that = (IndexShardRoutingTable)o;
        if (!this.shardId.equals(that.shardId)) {
            return false;
        }
        return this.shards.size() == that.shards.size() && this.shards.containsAll(that.shards) && that.shards.containsAll(this.shards);
    }

    public int hashCode() {
        int result = this.shardId.hashCode();
        result = 31 * result + this.shards.hashCode();
        return result;
    }

    public boolean allShardsStarted() {
        return this.allShardsStarted;
    }

    @Nullable
    public ShardRouting getByAllocationId(String allocationId) {
        for (ShardRouting shardRouting : this.assignedShards()) {
            if (!shardRouting.allocationId().getId().equals(allocationId)) continue;
            return shardRouting;
        }
        return null;
    }

    public Set<String> getAllAllocationIds() {
        return this.allAllocationIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributesRoutings getActiveAttribute(AttributesKey key, DiscoveryNodes nodes) {
        AttributesRoutings shardRoutings = this.activeShardsByAttributes.get(key);
        if (shardRoutings == null) {
            Object object = this.shardsByAttributeMutex;
            synchronized (object) {
                ArrayList<ShardRouting> from = new ArrayList<ShardRouting>(this.activeShards);
                List<ShardRouting> to = IndexShardRoutingTable.collectAttributeShards(key, nodes, from);
                shardRoutings = new AttributesRoutings(to, Collections.unmodifiableList(from));
                this.activeShardsByAttributes = MapBuilder.newMapBuilder(this.activeShardsByAttributes).put(key, shardRoutings).immutableMap();
            }
        }
        return shardRoutings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributesRoutings getInitializingAttribute(AttributesKey key, DiscoveryNodes nodes) {
        AttributesRoutings shardRoutings = this.initializingShardsByAttributes.get(key);
        if (shardRoutings == null) {
            Object object = this.shardsByAttributeMutex;
            synchronized (object) {
                ArrayList<ShardRouting> from = new ArrayList<ShardRouting>(this.allInitializingShards);
                List<ShardRouting> to = IndexShardRoutingTable.collectAttributeShards(key, nodes, from);
                shardRoutings = new AttributesRoutings(to, Collections.unmodifiableList(from));
                this.initializingShardsByAttributes = MapBuilder.newMapBuilder(this.initializingShardsByAttributes).put(key, shardRoutings).immutableMap();
            }
        }
        return shardRoutings;
    }

    private static List<ShardRouting> collectAttributeShards(AttributesKey key, DiscoveryNodes nodes, ArrayList<ShardRouting> from) {
        ArrayList<ShardRouting> to = new ArrayList<ShardRouting>();
        for (String attribute : key.attributes) {
            String localAttributeValue = nodes.getLocalNode().getAttributes().get(attribute);
            if (localAttributeValue == null) continue;
            Iterator<ShardRouting> iterator = from.iterator();
            while (iterator.hasNext()) {
                ShardRouting fromShard = iterator.next();
                DiscoveryNode discoveryNode = nodes.get(fromShard.currentNodeId());
                if (discoveryNode == null) {
                    iterator.remove();
                    continue;
                }
                if (!localAttributeValue.equals(discoveryNode.getAttributes().get(attribute))) continue;
                iterator.remove();
                to.add(fromShard);
            }
        }
        return Collections.unmodifiableList(to);
    }

    public ShardIterator preferAttributesActiveInitializingShardsIt(List<String> attributes, DiscoveryNodes nodes) {
        return this.preferAttributesActiveInitializingShardsIt(attributes, nodes, this.shuffler.nextSeed());
    }

    public ShardIterator preferAttributesActiveInitializingShardsIt(List<String> attributes, DiscoveryNodes nodes, int seed) {
        AttributesKey key = new AttributesKey(attributes);
        AttributesRoutings activeRoutings = this.getActiveAttribute(key, nodes);
        AttributesRoutings initializingRoutings = this.getInitializingAttribute(key, nodes);
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(activeRoutings.totalSize + initializingRoutings.totalSize);
        ordered.addAll(this.shuffler.shuffle(activeRoutings.withSameAttribute, seed));
        ordered.addAll(this.shuffler.shuffle(activeRoutings.withoutSameAttribute, seed));
        ordered.addAll(this.shuffler.shuffle(initializingRoutings.withSameAttribute, seed));
        ordered.addAll(this.shuffler.shuffle(initializingRoutings.withoutSameAttribute, seed));
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardRouting primaryShard() {
        return this.primary;
    }

    public List<ShardRouting> replicaShards() {
        return this.replicas;
    }

    public List<ShardRouting> replicaShardsWithState(ShardRoutingState ... states) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (ShardRouting shardEntry : this.replicas) {
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState state) {
        if (state == ShardRoutingState.INITIALIZING) {
            return this.allInitializingShards;
        }
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (ShardRouting shardEntry : this) {
            if (shardEntry.state() != state) continue;
            shards.add(shardEntry);
        }
        return shards;
    }

    public List<ShardRouting> shardsMatchingPredicate(Predicate<ShardRouting> predicate) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (ShardRouting shardEntry : this) {
            if (!predicate.test(shardEntry)) continue;
            shards.add(shardEntry);
        }
        return shards;
    }

    public int shardsMatchingPredicateCount(Predicate<ShardRouting> predicate) {
        int count = 0;
        for (ShardRouting shardEntry : this) {
            if (!predicate.test(shardEntry)) continue;
            ++count;
        }
        return count;
    }

    private List<ShardRouting> getActiveShardsByWeight(WeightedRouting weightedRouting, DiscoveryNodes nodes, double defaultWeight) {
        WeightedRoutingKey key = new WeightedRoutingKey(weightedRouting);
        if (this.activeShardsByWeight.get(key) == null) {
            this.populateActiveShardWeightsMap(weightedRouting, nodes, defaultWeight);
        }
        return this.activeShardsByWeight.get(key).getShardRoutingsWithWeight();
    }

    private List<ShardRouting> getActiveShardsWithoutWeight(WeightedRouting weightedRouting, DiscoveryNodes nodes, double defaultWeight) {
        WeightedRoutingKey key = new WeightedRoutingKey(weightedRouting);
        if (this.activeShardsByWeight.get(key) == null) {
            this.populateActiveShardWeightsMap(weightedRouting, nodes, defaultWeight);
        }
        return this.activeShardsByWeight.get(key).getShardRoutingWithoutWeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateActiveShardWeightsMap(WeightedRouting weightedRouting, DiscoveryNodes nodes, double defaultWeight) {
        WeightedRoutingKey key = new WeightedRoutingKey(weightedRouting);
        List<ShardRouting> weightedRoutings = this.shardsOrderedByWeight(this.activeShards, weightedRouting, nodes, defaultWeight);
        List<ShardRouting> nonWeightedRoutings = this.activeShards.stream().filter(shard -> !weightedRoutings.contains(shard)).collect(Collectors.toUnmodifiableList());
        Object object = this.shardsByWeightMutex;
        synchronized (object) {
            this.activeShardsByWeight = new MapBuilder<WeightedRoutingKey, WeightedShardRoutings>().put(key, new WeightedShardRoutings(weightedRoutings, nonWeightedRoutings)).immutableMap();
        }
    }

    private List<ShardRouting> getInitializingShardsByWeight(WeightedRouting weightedRouting, DiscoveryNodes nodes, double defaultWeight) {
        WeightedRoutingKey key = new WeightedRoutingKey(weightedRouting);
        if (this.initializingShardsByWeight.get(key) == null) {
            this.populateInitializingShardWeightsMap(weightedRouting, nodes, defaultWeight);
        }
        return this.initializingShardsByWeight.get(key).getShardRoutingsWithWeight();
    }

    private List<ShardRouting> getInitializingShardsWithoutWeight(WeightedRouting weightedRouting, DiscoveryNodes nodes, double defaultWeight) {
        WeightedRoutingKey key = new WeightedRoutingKey(weightedRouting);
        if (this.initializingShardsByWeight.get(key) == null) {
            this.populateInitializingShardWeightsMap(weightedRouting, nodes, defaultWeight);
        }
        return this.initializingShardsByWeight.get(key).getShardRoutingWithoutWeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateInitializingShardWeightsMap(WeightedRouting weightedRouting, DiscoveryNodes nodes, double defaultWeight) {
        WeightedRoutingKey key = new WeightedRoutingKey(weightedRouting);
        List<ShardRouting> weightedRoutings = this.shardsOrderedByWeight(this.allInitializingShards, weightedRouting, nodes, defaultWeight);
        List<ShardRouting> nonWeightedRoutings = this.allInitializingShards.stream().filter(shard -> !weightedRoutings.contains(shard)).collect(Collectors.toUnmodifiableList());
        Object object = this.shardsByWeightMutex;
        synchronized (object) {
            this.initializingShardsByWeight = new MapBuilder<WeightedRoutingKey, WeightedShardRoutings>().put(key, new WeightedShardRoutings(weightedRoutings, nonWeightedRoutings)).immutableMap();
        }
    }

    public static IndexShardRoutingTable readFrom(StreamInput in) throws IOException {
        return Builder.readFrom(in);
    }

    public static Diff<IndexShardRoutingTable> readDiffFrom(StreamInput in) throws IOException {
        return IndexShardRoutingTable.readDiffFrom(IndexShardRoutingTable::readFrom, in);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IndexShardRoutingTable(").append(this.shardId()).append("){");
        int numShards = this.shards.size();
        for (int i = 0; i < numShards; ++i) {
            sb.append(this.shards.get(i).shortSummary());
            if (i >= numShards - 1) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    private static class NodeRankComparator
    implements Comparator<ShardRouting> {
        private final Map<String, Double> nodeRanks;

        NodeRankComparator(Map<String, Double> nodeRanks) {
            this.nodeRanks = nodeRanks;
        }

        @Override
        public int compare(ShardRouting s1, ShardRouting s2) {
            if (s1.currentNodeId().equals(s2.currentNodeId())) {
                return 0;
            }
            Double shard1rank = this.nodeRanks.get(s1.currentNodeId());
            Double shard2rank = this.nodeRanks.get(s2.currentNodeId());
            if (shard1rank != null) {
                if (shard2rank != null) {
                    return shard1rank.compareTo(shard2rank);
                }
                return 1;
            }
            if (shard2rank != null) {
                return -1;
            }
            return 0;
        }
    }

    public static class Builder {
        private ShardId shardId;
        private final List<ShardRouting> shards;

        public Builder(IndexShardRoutingTable indexShard) {
            this.shardId = indexShard.shardId;
            this.shards = new ArrayList<ShardRouting>(indexShard.shards);
        }

        public Builder(ShardId shardId) {
            this.shardId = shardId;
            this.shards = new ArrayList<ShardRouting>();
        }

        public Builder addShard(ShardRouting shardEntry) {
            this.shards.add(shardEntry);
            return this;
        }

        public Builder removeShard(ShardRouting shardEntry) {
            this.shards.remove(shardEntry);
            return this;
        }

        public IndexShardRoutingTable build() {
            assert (Builder.distinctNodes(this.shards)) : "more than one shard with same id assigned to same node (shards: " + String.valueOf(this.shards) + ")";
            return new IndexShardRoutingTable(this.shardId, Collections.unmodifiableList(new ArrayList<ShardRouting>(this.shards)));
        }

        static boolean distinctNodes(List<ShardRouting> shards) {
            HashSet<String> nodes = new HashSet<String>();
            for (ShardRouting shard : shards) {
                if (!shard.assignedToNode()) continue;
                if (!nodes.add(shard.currentNodeId())) {
                    return false;
                }
                if (!shard.relocating() || nodes.add(shard.relocatingNodeId())) continue;
                return false;
            }
            return true;
        }

        public static IndexShardRoutingTable readFrom(StreamInput in) throws IOException {
            Index index = new Index(in);
            return Builder.readFromThin(in, index);
        }

        public static IndexShardRoutingTable readFromThin(StreamInput in, Index index) throws IOException {
            int iShardId = in.readVInt();
            ShardId shardId = new ShardId(index, iShardId);
            Builder builder = new Builder(shardId);
            int size = in.readVInt();
            for (int i = 0; i < size; ++i) {
                ShardRouting shard = new ShardRouting(shardId, in);
                builder.addShard(shard);
            }
            return builder.build();
        }

        public static void writeTo(IndexShardRoutingTable indexShard, StreamOutput out) throws IOException {
            indexShard.shardId().getIndex().writeTo(out);
            Builder.writeToThin(indexShard, out);
        }

        public static void writeToThin(IndexShardRoutingTable indexShard, StreamOutput out) throws IOException {
            out.writeVInt(indexShard.shardId.id());
            out.writeVInt(indexShard.shards.size());
            for (ShardRouting entry : indexShard) {
                entry.writeToThin(out);
            }
        }

        public static void writeVerifiableTo(IndexShardRoutingTable indexShard, BufferedChecksumStreamOutput out) throws IOException {
            out.writeVInt(indexShard.shardId.id());
            out.writeVInt(indexShard.shards.size());
            AtomicInteger assignedShardCount = new AtomicInteger();
            indexShard.shards.stream().filter(shardRouting -> shardRouting.allocationId() != null).sorted(Comparator.comparing(o -> o.allocationId().getId())).forEach(shardRouting -> {
                try {
                    assignedShardCount.getAndIncrement();
                    shardRouting.writeToThin(out);
                }
                catch (IOException e) {
                    logger.error(() -> new ParameterizedMessage("Failed to write shard {}. Exception {}", (Object)indexShard, (Object)e));
                    throw new RuntimeException("Failed to write IndexShardRoutingTable", e);
                }
            });
            out.writeBoolean(indexShard.primaryShard().allocationId() != null);
            out.writeVInt(indexShard.shards.size() - assignedShardCount.get());
        }
    }

    static class AttributesRoutings {
        public final List<ShardRouting> withSameAttribute;
        public final List<ShardRouting> withoutSameAttribute;
        public final int totalSize;

        AttributesRoutings(List<ShardRouting> withSameAttribute, List<ShardRouting> withoutSameAttribute) {
            this.withSameAttribute = withSameAttribute;
            this.withoutSameAttribute = withoutSameAttribute;
            this.totalSize = withoutSameAttribute.size() + withSameAttribute.size();
        }
    }

    static class AttributesKey {
        final List<String> attributes;

        AttributesKey(List<String> attributes) {
            this.attributes = attributes;
        }

        public int hashCode() {
            return this.attributes.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof AttributesKey && this.attributes.equals(((AttributesKey)obj).attributes);
        }
    }

    @PublicApi(since="2.4.0")
    public static class WeightedRoutingKey {
        private final WeightedRouting weightedRouting;

        public WeightedRoutingKey(WeightedRouting weightedRouting) {
            this.weightedRouting = weightedRouting;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WeightedRoutingKey key = (WeightedRoutingKey)o;
            return this.weightedRouting.equals(key.weightedRouting);
        }

        public int hashCode() {
            int result = this.weightedRouting.hashCode();
            return result;
        }
    }

    @PublicApi(since="2.14.0")
    public static class WeightedShardRoutings {
        private final List<ShardRouting> shardRoutingsWithWeight;
        private final List<ShardRouting> shardRoutingWithoutWeight;

        public WeightedShardRoutings(List<ShardRouting> shardRoutingsWithWeight, List<ShardRouting> shardRoutingWithoutWeight) {
            this.shardRoutingsWithWeight = Collections.unmodifiableList(shardRoutingsWithWeight);
            this.shardRoutingWithoutWeight = Collections.unmodifiableList(shardRoutingWithoutWeight);
        }

        public List<ShardRouting> getShardRoutingsWithWeight() {
            return this.shardRoutingsWithWeight;
        }

        public List<ShardRouting> getShardRoutingWithoutWeight() {
            return this.shardRoutingWithoutWeight;
        }
    }
}

