/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.common.CheckedBiConsumer;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.DeleteResult;
import org.opensearch.common.blobstore.EncryptedBlobMetadata;
import org.opensearch.common.blobstore.InputStreamWithMetadata;
import org.opensearch.common.crypto.CryptoHandler;
import org.opensearch.common.crypto.DecryptedRangedStreamProvider;
import org.opensearch.common.crypto.EncryptedHeaderContentSupplier;
import org.opensearch.common.io.InputStreamContainer;
import org.opensearch.core.action.ActionListener;

public class EncryptedBlobContainer<T, U>
implements BlobContainer {
    private final BlobContainer blobContainer;
    private final CryptoHandler<T, U> cryptoHandler;

    public EncryptedBlobContainer(BlobContainer blobContainer, CryptoHandler<T, U> cryptoHandler) {
        this.blobContainer = blobContainer;
        this.cryptoHandler = cryptoHandler;
    }

    @Override
    public BlobPath path() {
        return this.blobContainer.path();
    }

    @Override
    public boolean blobExists(String blobName) throws IOException {
        return this.blobContainer.blobExists(blobName);
    }

    @Override
    public InputStream readBlob(String blobName) throws IOException {
        InputStream inputStream = this.blobContainer.readBlob(blobName);
        return this.cryptoHandler.createDecryptingStream(inputStream);
    }

    @Override
    @ExperimentalApi
    public InputStreamWithMetadata readBlobWithMetadata(String blobName) throws IOException {
        InputStreamWithMetadata inputStreamWithMetadata = this.blobContainer.readBlobWithMetadata(blobName);
        InputStream decryptInputStream = this.cryptoHandler.createDecryptingStream(inputStreamWithMetadata.getInputStream());
        return new InputStreamWithMetadata(decryptInputStream, inputStreamWithMetadata.getMetadata());
    }

    EncryptedHeaderContentSupplier getEncryptedHeaderContentSupplier(String blobName) {
        return (start, end) -> {
            byte[] buffer;
            int length = (int)(end - start + 1L);
            try (InputStream inputStream = this.blobContainer.readBlob(blobName, start, length);){
                buffer = new byte[length];
                inputStream.readNBytes(buffer, (int)start, buffer.length);
            }
            return buffer;
        };
    }

    @Override
    public InputStream readBlob(String blobName, long position, long length) throws IOException {
        U encryptionMetadata = this.cryptoHandler.loadEncryptionMetadata(this.getEncryptedHeaderContentSupplier(blobName));
        DecryptedRangedStreamProvider decryptedStreamProvider = this.cryptoHandler.createDecryptingStreamOfRange(encryptionMetadata, position, position + length - 1L);
        long adjustedPos = decryptedStreamProvider.getAdjustedRange()[0];
        long adjustedLength = decryptedStreamProvider.getAdjustedRange()[1] - adjustedPos + 1L;
        InputStream encryptedStream = this.blobContainer.readBlob(blobName, adjustedPos, adjustedLength);
        return (InputStream)decryptedStreamProvider.getDecryptedStreamProvider().apply(encryptedStream);
    }

    @Override
    public long readBlobPreferredLength() {
        return this.blobContainer.readBlobPreferredLength();
    }

    private void executeWrite(InputStream inputStream, long blobSize, CheckedBiConsumer<InputStream, Long, IOException> writeConsumer) throws IOException {
        T cryptoContext = this.cryptoHandler.initEncryptionMetadata();
        InputStreamContainer streamContainer = new InputStreamContainer(inputStream, blobSize, 0L);
        InputStreamContainer encryptedStream = this.cryptoHandler.createEncryptingStream(cryptoContext, streamContainer);
        long cryptoLength = this.cryptoHandler.estimateEncryptedLengthOfEntireContent(cryptoContext, blobSize);
        writeConsumer.accept(encryptedStream.getInputStream(), cryptoLength);
    }

    @Override
    public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.executeWrite(inputStream, blobSize, (encryptedStream, encryptedLength) -> this.blobContainer.writeBlob(blobName, (InputStream)encryptedStream, (long)encryptedLength, failIfAlreadyExists));
    }

    @Override
    public void writeBlobAtomic(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.executeWrite(inputStream, blobSize, (encryptedStream, encryptedLength) -> this.blobContainer.writeBlobAtomic(blobName, (InputStream)encryptedStream, (long)encryptedLength, failIfAlreadyExists));
    }

    @Override
    public DeleteResult delete() throws IOException {
        return this.blobContainer.delete();
    }

    @Override
    public void deleteBlobsIgnoringIfNotExists(List<String> blobNames) throws IOException {
        this.blobContainer.deleteBlobsIgnoringIfNotExists(blobNames);
    }

    @Override
    public Map<String, BlobMetadata> listBlobs() throws IOException {
        Map<String, BlobMetadata> blobMetadataMap = this.blobContainer.listBlobs();
        return this.convertToEncryptedMetadataMap(blobMetadataMap);
    }

    @Override
    public Map<String, BlobContainer> children() throws IOException {
        Map<String, BlobContainer> children = this.blobContainer.children();
        if (children != null) {
            return children.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new EncryptedBlobContainer<T, U>((BlobContainer)entry.getValue(), this.cryptoHandler)));
        }
        return null;
    }

    @Override
    public Map<String, BlobMetadata> listBlobsByPrefix(String blobNamePrefix) throws IOException {
        Map<String, BlobMetadata> blobMetadataMap = this.blobContainer.listBlobsByPrefix(blobNamePrefix);
        return this.convertToEncryptedMetadataMap(blobMetadataMap);
    }

    private Map<String, BlobMetadata> convertToEncryptedMetadataMap(Map<String, BlobMetadata> blobMetadataMap) {
        if (blobMetadataMap == null) {
            return null;
        }
        return blobMetadataMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new EncryptedBlobMetadata<T, U>((BlobMetadata)entry.getValue(), this.cryptoHandler, this.getEncryptedHeaderContentSupplier((String)entry.getKey()))));
    }

    @Override
    public void listBlobsByPrefixInSortedOrder(String blobNamePrefix, int limit, BlobContainer.BlobNameSortOrder blobNameSortOrder, ActionListener<List<BlobMetadata>> listener) {
        ActionListener<List<BlobMetadata>> encryptedMetadataListener = ActionListener.delegateFailure(listener, (delegatedListener, metadataList) -> {
            if (metadataList != null) {
                List encryptedMetadata = metadataList.stream().map(blobMetadata -> new EncryptedBlobMetadata<T, U>((BlobMetadata)blobMetadata, this.cryptoHandler, this.getEncryptedHeaderContentSupplier(blobMetadata.name()))).collect(Collectors.toList());
                delegatedListener.onResponse(encryptedMetadata);
            } else {
                delegatedListener.onResponse(null);
            }
        });
        this.blobContainer.listBlobsByPrefixInSortedOrder(blobNamePrefix, limit, blobNameSortOrder, encryptedMetadataListener);
    }
}

