/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote;

import java.util.concurrent.atomic.AtomicReference;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.coordination.ClusterStateTermVersion;
import org.opensearch.common.collect.Tuple;
import org.opensearch.gateway.remote.ClusterMetadataManifest;

public class RemoteClusterStateCache {
    private final AtomicReference<Tuple<ClusterStateTermVersion, ClusterState>> clusterStateFromCache = new AtomicReference();

    public ClusterState getState(String clusterName, ClusterMetadataManifest manifest) {
        Tuple<ClusterStateTermVersion, ClusterState> cache = this.clusterStateFromCache.get();
        if (cache != null) {
            ClusterStateTermVersion manifestStateTermVersion = new ClusterStateTermVersion(new ClusterName(clusterName), manifest.getClusterUUID(), manifest.getClusterTerm(), manifest.getStateVersion());
            if (cache.v1().equals(manifestStateTermVersion)) {
                return cache.v2();
            }
        }
        return null;
    }

    public void putState(ClusterState newState) {
        if (newState.metadata() == null || newState.coordinationMetadata() == null) {
            return;
        }
        ClusterStateTermVersion cacheStateTermVersion = new ClusterStateTermVersion(new ClusterName(newState.getClusterName().value()), newState.metadata().clusterUUID(), newState.term(), newState.version());
        this.clusterStateFromCache.set(new Tuple<ClusterStateTermVersion, ClusterState>(cacheStateTermVersion, newState));
    }
}

