/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.exc.InputCoercionException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.sandbox.document.BigIntegerPoint;
import org.apache.lucene.sandbox.document.HalfFloatPoint;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.IndexSortSortedNumericDocValuesRangeQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.opensearch.common.Explicit;
import org.opensearch.common.Numbers;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.lucene.search.Queries;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.compositeindex.datacube.DimensionType;
import org.opensearch.index.document.SortedUnsignedLongDocValuesRangeQuery;
import org.opensearch.index.document.SortedUnsignedLongDocValuesSetQuery;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexNumericFieldData;
import org.opensearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.FieldValueConverter;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.NumericPointEncoder;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.SimpleMappedFieldType;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.lookup.SearchLookup;
import org.opensearch.search.query.BitmapDocValuesQuery;
import org.opensearch.search.query.BitmapIndexQuery;
import org.roaringbitmap.RoaringBitmap;

public class NumberFieldMapper
extends ParametrizedFieldMapper {
    public static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", true, Setting.Property.IndexScope);
    private final NumberType type;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final Explicit<Boolean> ignoreMalformed;
    private final Explicit<Boolean> coerce;
    private final Number nullValue;
    private final boolean ignoreMalformedByDefault;
    private final boolean coerceByDefault;

    private static NumberFieldMapper toType(FieldMapper in) {
        return (NumberFieldMapper)in;
    }

    private NumberFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.type = builder.type;
        this.indexed = builder.indexed.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
        this.stored = builder.stored.getValue();
        this.ignoreMalformed = builder.ignoreMalformed.getValue();
        this.coerce = builder.coerce.getValue();
        this.nullValue = builder.nullValue.getValue();
        this.ignoreMalformedByDefault = builder.ignoreMalformed.getDefaultValue().value();
        this.coerceByDefault = builder.coerce.getDefaultValue().value();
    }

    boolean coerce() {
        return this.coerce.value();
    }

    boolean ignoreMalformed() {
        return this.ignoreMalformed.value();
    }

    @Override
    public NumberFieldType fieldType() {
        return (NumberFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().type.typeName();
    }

    @Override
    protected NumberFieldMapper clone() {
        return (NumberFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        Object value;
        XContentParser parser = context.parser();
        Number numericValue = null;
        if (context.externalValueSet()) {
            value = context.externalValue();
        } else if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            value = null;
        } else if (this.coerce.value().booleanValue() && parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
            value = null;
        } else {
            try {
                numericValue = this.fieldType().type.parse(parser, (boolean)this.coerce.value());
            }
            catch (JsonParseException | InputCoercionException | IllegalArgumentException e) {
                if (this.ignoreMalformed.value().booleanValue() && parser.currentToken().isValue()) {
                    context.addIgnoredField(this.mappedFieldType.name());
                    return;
                }
                throw e;
            }
            value = numericValue;
        }
        if (value == null) {
            value = this.nullValue;
        }
        if (value == null) {
            return;
        }
        if (numericValue == null) {
            numericValue = this.fieldType().type.parse(value, (boolean)this.coerce.value());
        }
        context.doc().addAll(this.fieldType().type.createFields(this.fieldType().name(), numericValue, this.indexed, this.hasDocValues, this.stored));
        if (!this.hasDocValues && (this.stored || this.indexed)) {
            this.createFieldNamesField(context);
        }
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.type, this.ignoreMalformedByDefault, this.coerceByDefault).init(this);
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> indexed = ParametrizedFieldMapper.Parameter.indexParam(m -> NumberFieldMapper.toType((FieldMapper)m).indexed, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> NumberFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.storeParam(m -> NumberFieldMapper.toType((FieldMapper)m).stored, false);
        private final ParametrizedFieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        private final ParametrizedFieldMapper.Parameter<Explicit<Boolean>> coerce;
        private final ParametrizedFieldMapper.Parameter<Number> nullValue;
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();
        private final NumberType type;

        public Builder(String name, NumberType type, Settings settings) {
            this(name, type, FieldMapper.IGNORE_MALFORMED_SETTING.get(settings), COERCE_SETTING.get(settings));
        }

        public static Builder docValuesOnly(String name, NumberType type) {
            Builder builder = new Builder(name, type, false, false);
            builder.indexed.setValue(false);
            return builder;
        }

        public Builder(String name, NumberType type, boolean ignoreMalformedByDefault, boolean coerceByDefault) {
            super(name);
            this.type = type;
            this.ignoreMalformed = ParametrizedFieldMapper.Parameter.explicitBoolParam("ignore_malformed", true, m -> NumberFieldMapper.toType((FieldMapper)m).ignoreMalformed, ignoreMalformedByDefault);
            this.coerce = ParametrizedFieldMapper.Parameter.explicitBoolParam("coerce", true, m -> NumberFieldMapper.toType((FieldMapper)m).coerce, coerceByDefault);
            this.nullValue = new ParametrizedFieldMapper.Parameter<Number>("null_value", false, () -> null, (n, c, o) -> o == null ? (Number)null : (Number)type.parse(o, false), m -> NumberFieldMapper.toType((FieldMapper)m).nullValue).acceptsNull();
        }

        Builder nullValue(Number number) {
            this.nullValue.setValue(number);
            return this;
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
            return this;
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.coerce, this.nullValue, this.meta);
        }

        @Override
        public NumberFieldMapper build(Mapper.BuilderContext context) {
            NumberFieldType ft = new NumberFieldType(this.buildFullName(context), this);
            return new NumberFieldMapper(this.name, ft, this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }

        @Override
        public Optional<DimensionType> getSupportedDataCubeDimensionType() {
            return this.type.numericType.equals((Object)IndexNumericFieldData.NumericType.UNSIGNED_LONG) ? Optional.of(DimensionType.UNSIGNED_LONG) : Optional.of(DimensionType.NUMERIC);
        }

        @Override
        public boolean isDataCubeMetricSupported() {
            return true;
        }
    }

    public static enum NumberType implements NumericPointEncoder,
    FieldValueConverter
    {
        HALF_FLOAT("half_float", IndexNumericFieldData.NumericType.HALF_FLOAT){

            @Override
            public Float parse(Object value, boolean coerce) {
                float result;
                if (value instanceof Number) {
                    result = ((Number)value).floatValue();
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    result = Float.parseFloat(value.toString());
                }
                this.validateParsed(result);
                return Float.valueOf(result);
            }

            @Override
            public Number parsePoint(byte[] value) {
                return Float.valueOf(HalfFloatPoint.decodeDimension(value, 0));
            }

            @Override
            public byte[] encodePoint(Number value) {
                byte[] point = new byte[2];
                HalfFloatPoint.encodeDimension(value.floatValue(), point, 0);
                return point;
            }

            @Override
            public double toDoubleValue(long value) {
                return HalfFloatPoint.sortableShortToHalfFloat((short)value);
            }

            @Override
            public Float parse(XContentParser parser, boolean coerce) throws IOException {
                float parsed = parser.floatValue(coerce);
                this.validateParsed(parsed);
                return Float.valueOf(parsed);
            }

            @Override
            public Query termQuery(String field, Object value, boolean hasDocValues, boolean isSearchable) {
                float v = this.parse(value, false).floatValue();
                if (isSearchable && hasDocValues) {
                    Query query = HalfFloatPoint.newExactQuery(field, v);
                    Query dvQuery = SortedNumericDocValuesField.newSlowExactQuery(field, HalfFloatPoint.halfFloatToSortableShort(v));
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowExactQuery(field, HalfFloatPoint.halfFloatToSortableShort(v));
                }
                return HalfFloatPoint.newExactQuery(field, v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values, boolean hasDocValues, boolean isSearchable) {
                float[] v = new float[values.size()];
                long[] points = new long[v.length];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i), false).floatValue();
                    if (!hasDocValues) continue;
                    points[i] = HalfFloatPoint.halfFloatToSortableShort(v[i]);
                }
                if (isSearchable && hasDocValues) {
                    Query query = HalfFloatPoint.newSetQuery(field, v);
                    Query dvQuery = SortedNumericDocValuesField.newSlowSetQuery(field, points);
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowSetQuery(field, points);
                }
                return HalfFloatPoint.newSetQuery(field, v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isSearchable, QueryShardContext context) {
                float l = Float.NEGATIVE_INFINITY;
                float u = Float.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, false).floatValue();
                    if (includeLower) {
                        l = HalfFloatPoint.nextDown(l);
                    }
                    l = HalfFloatPoint.nextUp(l);
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, false).floatValue();
                    if (includeUpper) {
                        u = HalfFloatPoint.nextUp(u);
                    }
                    u = HalfFloatPoint.nextDown(u);
                }
                if (isSearchable && hasDocValues) {
                    Query query = HalfFloatPoint.newRangeQuery(field, l, u);
                    Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery(field, HalfFloatPoint.halfFloatToSortableShort(l), HalfFloatPoint.halfFloatToSortableShort(u));
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowRangeQuery(field, HalfFloatPoint.halfFloatToSortableShort(l), HalfFloatPoint.halfFloatToSortableShort(u));
                }
                return HalfFloatPoint.newRangeQuery(field, l, u);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add(new HalfFloatPoint(name, value.floatValue()));
                }
                if (docValued) {
                    fields.add(new SortedNumericDocValuesField(name, HalfFloatPoint.halfFloatToSortableShort(value.floatValue())));
                }
                if (stored) {
                    fields.add(new StoredField(name, value.floatValue()));
                }
                return fields;
            }

            @Override
            Number valueForSearch(String value) {
                return Float.valueOf(Float.parseFloat(value));
            }

            private void validateParsed(float value) {
                if (!Float.isFinite(HalfFloatPoint.sortableShortToHalfFloat(HalfFloatPoint.halfFloatToSortableShort(value)))) {
                    throw new IllegalArgumentException("[half_float] supports only finite values, but got [" + value + "]");
                }
            }
        }
        ,
        FLOAT("float", IndexNumericFieldData.NumericType.FLOAT){

            @Override
            public Float parse(Object value, boolean coerce) {
                float result;
                if (value instanceof Number) {
                    result = ((Number)value).floatValue();
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    result = Float.parseFloat(value.toString());
                }
                this.validateParsed(result);
                return Float.valueOf(result);
            }

            @Override
            public Number parsePoint(byte[] value) {
                return Float.valueOf(FloatPoint.decodeDimension(value, 0));
            }

            @Override
            public byte[] encodePoint(Number value) {
                byte[] point = new byte[4];
                FloatPoint.encodeDimension(value.floatValue(), point, 0);
                return point;
            }

            @Override
            public double toDoubleValue(long value) {
                return NumericUtils.sortableIntToFloat((int)value);
            }

            @Override
            public Float parse(XContentParser parser, boolean coerce) throws IOException {
                float parsed = parser.floatValue(coerce);
                this.validateParsed(parsed);
                return Float.valueOf(parsed);
            }

            @Override
            public Query termQuery(String field, Object value, boolean hasDocValues, boolean isSearchable) {
                float v = this.parse(value, false).floatValue();
                if (isSearchable && hasDocValues) {
                    Query query = FloatPoint.newExactQuery(field, v);
                    Query dvQuery = SortedNumericDocValuesField.newSlowExactQuery(field, NumericUtils.floatToSortableInt(v));
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowExactQuery(field, NumericUtils.floatToSortableInt(v));
                }
                return FloatPoint.newExactQuery(field, v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values, boolean hasDocValues, boolean isSearchable) {
                float[] v = new float[values.size()];
                long[] points = new long[v.length];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i), false).floatValue();
                    if (!hasDocValues) continue;
                    points[i] = NumericUtils.floatToSortableInt(v[i]);
                }
                if (isSearchable && hasDocValues) {
                    return new IndexOrDocValuesQuery(FloatPoint.newSetQuery(field, v), SortedNumericDocValuesField.newSlowSetQuery(field, points));
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowSetQuery(field, points);
                }
                return FloatPoint.newSetQuery(field, v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isSearchable, QueryShardContext context) {
                float l = Float.NEGATIVE_INFINITY;
                float u = Float.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, false).floatValue();
                    if (!includeLower) {
                        l = FloatPoint.nextUp(l);
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, false).floatValue();
                    if (!includeUpper) {
                        u = FloatPoint.nextDown(u);
                    }
                }
                if (isSearchable && hasDocValues) {
                    Query query = FloatPoint.newRangeQuery(field, l, u);
                    Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery(field, NumericUtils.floatToSortableInt(l), NumericUtils.floatToSortableInt(u));
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowRangeQuery(field, NumericUtils.floatToSortableInt(l), NumericUtils.floatToSortableInt(u));
                }
                return FloatPoint.newRangeQuery(field, l, u);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add(new FloatPoint(name, value.floatValue()));
                }
                if (docValued) {
                    fields.add(new SortedNumericDocValuesField(name, NumericUtils.floatToSortableInt(value.floatValue())));
                }
                if (stored) {
                    fields.add(new StoredField(name, value.floatValue()));
                }
                return fields;
            }

            @Override
            Number valueForSearch(String value) {
                return Float.valueOf(Float.parseFloat(value));
            }

            private void validateParsed(float value) {
                if (!Float.isFinite(value)) {
                    throw new IllegalArgumentException("[float] supports only finite values, but got [" + value + "]");
                }
            }
        }
        ,
        DOUBLE("double", IndexNumericFieldData.NumericType.DOUBLE){

            @Override
            public Double parse(Object value, boolean coerce) {
                double parsed = 3.objectToDouble(value);
                this.validateParsed(parsed);
                return parsed;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return DoublePoint.decodeDimension(value, 0);
            }

            @Override
            public byte[] encodePoint(Number value) {
                byte[] point = new byte[8];
                DoublePoint.encodeDimension(value.doubleValue(), point, 0);
                return point;
            }

            @Override
            public double toDoubleValue(long value) {
                return NumericUtils.sortableLongToDouble(value);
            }

            @Override
            public Double parse(XContentParser parser, boolean coerce) throws IOException {
                double parsed = parser.doubleValue(coerce);
                this.validateParsed(parsed);
                return parsed;
            }

            @Override
            public Query termQuery(String field, Object value, boolean hasDocValues, boolean isSearchable) {
                double v = this.parse(value, false);
                if (isSearchable && hasDocValues) {
                    Query query = DoublePoint.newExactQuery(field, v);
                    Query dvQuery = SortedNumericDocValuesField.newSlowExactQuery(field, NumericUtils.doubleToSortableLong(v));
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowExactQuery(field, NumericUtils.doubleToSortableLong(v));
                }
                return DoublePoint.newExactQuery(field, v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values, boolean hasDocValues, boolean isSearchable) {
                double[] v = new double[values.size()];
                long[] points = new long[v.length];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i), false);
                    if (!hasDocValues) continue;
                    points[i] = NumericUtils.doubleToSortableLong(v[i]);
                }
                if (isSearchable && hasDocValues) {
                    return new IndexOrDocValuesQuery(DoublePoint.newSetQuery(field, v), SortedNumericDocValuesField.newSlowSetQuery(field, points));
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowSetQuery(field, points);
                }
                return DoublePoint.newSetQuery(field, v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isSearchable, QueryShardContext context) {
                return 3.doubleRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (l, u) -> {
                    if (isSearchable && hasDocValues) {
                        Query query = DoublePoint.newRangeQuery(field, l, u);
                        Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery(field, NumericUtils.doubleToSortableLong(l), NumericUtils.doubleToSortableLong(u));
                        return new IndexOrDocValuesQuery(query, dvQuery);
                    }
                    if (hasDocValues) {
                        return SortedNumericDocValuesField.newSlowRangeQuery(field, NumericUtils.doubleToSortableLong(l), NumericUtils.doubleToSortableLong(u));
                    }
                    return DoublePoint.newRangeQuery(field, l, u);
                });
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add(new DoublePoint(name, value.doubleValue()));
                }
                if (docValued) {
                    fields.add(new SortedNumericDocValuesField(name, NumericUtils.doubleToSortableLong(value.doubleValue())));
                }
                if (stored) {
                    fields.add(new StoredField(name, value.doubleValue()));
                }
                return fields;
            }

            @Override
            Number valueForSearch(String value) {
                return Double.parseDouble(value);
            }

            private void validateParsed(double value) {
                if (!Double.isFinite(value)) {
                    throw new IllegalArgumentException("[double] supports only finite values, but got [" + value + "]");
                }
            }
        }
        ,
        BYTE("byte", IndexNumericFieldData.NumericType.BYTE){

            @Override
            public Byte parse(Object value, boolean coerce) {
                double doubleValue = 4.objectToDouble(value);
                if (doubleValue < -128.0 || doubleValue > 127.0) {
                    throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] is out of range for a byte");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).byteValue();
                }
                return (byte)doubleValue;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return INTEGER.parsePoint(value).byteValue();
            }

            @Override
            public byte[] encodePoint(Number value) {
                byte[] point = new byte[4];
                IntPoint.encodeDimension(value.intValue(), point, 0);
                return point;
            }

            @Override
            public double toDoubleValue(long value) {
                return 4.objectToDouble(value);
            }

            @Override
            public Short parse(XContentParser parser, boolean coerce) throws IOException {
                int value = parser.intValue(coerce);
                if (value < -128 || value > 127) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a byte");
                }
                return (short)value;
            }

            @Override
            public Query termQuery(String field, Object value, boolean hasDocValues, boolean isSearchable) {
                return INTEGER.termQuery(field, value, hasDocValues, isSearchable);
            }

            @Override
            public Query termsQuery(String field, List<Object> values, boolean hasDocValues, boolean isSearchable) {
                return INTEGER.termsQuery(field, values, hasDocValues, isSearchable);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isSearchable, QueryShardContext context) {
                return INTEGER.rangeQuery(field, lowerTerm, upperTerm, includeLower, includeUpper, hasDocValues, isSearchable, context);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                return INTEGER.createFields(name, value, indexed, docValued, stored);
            }

            @Override
            Number valueForSearch(Number value) {
                return value.byteValue();
            }

            @Override
            Number valueForSearch(String value) {
                return Byte.parseByte(value);
            }
        }
        ,
        SHORT("short", IndexNumericFieldData.NumericType.SHORT){

            @Override
            public Short parse(Object value, boolean coerce) {
                double doubleValue = 5.objectToDouble(value);
                if (doubleValue < -32768.0 || doubleValue > 32767.0) {
                    throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] is out of range for a short");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).shortValue();
                }
                return (short)doubleValue;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return INTEGER.parsePoint(value).shortValue();
            }

            @Override
            public byte[] encodePoint(Number value) {
                byte[] point = new byte[4];
                IntPoint.encodeDimension(value.intValue(), point, 0);
                return point;
            }

            @Override
            public double toDoubleValue(long value) {
                return value;
            }

            @Override
            public Short parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.shortValue(coerce);
            }

            @Override
            public Query termQuery(String field, Object value, boolean hasDocValues, boolean isSearchable) {
                return INTEGER.termQuery(field, value, hasDocValues, isSearchable);
            }

            @Override
            public Query termsQuery(String field, List<Object> values, boolean hasDocValues, boolean isSearchable) {
                return INTEGER.termsQuery(field, values, hasDocValues, isSearchable);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isSearchable, QueryShardContext context) {
                return INTEGER.rangeQuery(field, lowerTerm, upperTerm, includeLower, includeUpper, hasDocValues, isSearchable, context);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                return INTEGER.createFields(name, value, indexed, docValued, stored);
            }

            @Override
            Number valueForSearch(Number value) {
                return value.shortValue();
            }

            @Override
            Number valueForSearch(String value) {
                return Short.parseShort(value);
            }
        }
        ,
        INTEGER("integer", IndexNumericFieldData.NumericType.INT){

            @Override
            public Integer parse(Object value, boolean coerce) {
                double doubleValue = 6.objectToDouble(value);
                if (doubleValue < -2.147483648E9 || doubleValue > 2.147483647E9) {
                    throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] is out of range for an integer");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                return (int)doubleValue;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return IntPoint.decodeDimension(value, 0);
            }

            @Override
            public byte[] encodePoint(Number value) {
                byte[] point = new byte[4];
                IntPoint.encodeDimension(value.intValue(), point, 0);
                return point;
            }

            @Override
            public double toDoubleValue(long value) {
                return value;
            }

            @Override
            public Integer parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.intValue(coerce);
            }

            @Override
            public Query termQuery(String field, Object value, boolean hasDocValues, boolean isSearchable) {
                if (6.hasDecimalPart(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + String.valueOf(value) + "] has a decimal part");
                }
                int v = this.parse(value, true);
                if (isSearchable && hasDocValues) {
                    Query query = IntPoint.newExactQuery(field, v);
                    Query dvQuery = SortedNumericDocValuesField.newSlowExactQuery(field, v);
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowExactQuery(field, v);
                }
                return IntPoint.newExactQuery(field, v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values, boolean hasDocValues, boolean isSearchable) {
                int[] v = new int[values.size()];
                int upTo = 0;
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (6.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value, true);
                }
                if (upTo == 0) {
                    return Queries.newMatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                long[] points = new long[v.length];
                if (hasDocValues) {
                    for (int i = 0; i < v.length; ++i) {
                        points[i] = v[i];
                    }
                }
                if (isSearchable && hasDocValues) {
                    return new IndexOrDocValuesQuery(IntPoint.newSetQuery(field, v), SortedNumericDocValuesField.newSlowSetQuery(field, points));
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowSetQuery(field, points);
                }
                return IntPoint.newSetQuery(field, v);
            }

            @Override
            public Query bitmapQuery(String field, BytesArray bitmapArray, boolean isSearchable, boolean hasDocValues) {
                RoaringBitmap bitmap = new RoaringBitmap();
                try {
                    bitmap.deserialize(ByteBuffer.wrap(bitmapArray.array()));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to deserialize the bitmap.", e);
                }
                if (isSearchable && hasDocValues) {
                    return new IndexOrDocValuesQuery(new BitmapIndexQuery(field, bitmap), new BitmapDocValuesQuery(field, bitmap));
                }
                if (isSearchable) {
                    return new BitmapIndexQuery(field, bitmap);
                }
                return new BitmapDocValuesQuery(field, bitmap);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isSearchable, QueryShardContext context) {
                int l = Integer.MIN_VALUE;
                int u = Integer.MAX_VALUE;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, true);
                    boolean lowerTermHasDecimalPart = 6.hasDecimalPart(lowerTerm);
                    if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && 6.signum(lowerTerm) > 0.0) {
                        if (l == Integer.MAX_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        ++l;
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, true);
                    boolean upperTermHasDecimalPart = 6.hasDecimalPart(upperTerm);
                    if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && 6.signum(upperTerm) < 0.0) {
                        if (u == Integer.MIN_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        --u;
                    }
                }
                if (isSearchable && hasDocValues) {
                    Query query = IntPoint.newRangeQuery(field, l, u);
                    Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery(field, l, u);
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                    if (context.indexSortedOnField(field)) {
                        query = new IndexSortSortedNumericDocValuesRangeQuery(field, l, u, query);
                    }
                    return query;
                }
                if (hasDocValues) {
                    Query query = SortedNumericDocValuesField.newSlowRangeQuery(field, l, u);
                    if (context.indexSortedOnField(field)) {
                        query = new IndexSortSortedNumericDocValuesRangeQuery(field, l, u, query);
                    }
                    return query;
                }
                return IntPoint.newRangeQuery(field, l, u);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add(new IntPoint(name, value.intValue()));
                }
                if (docValued) {
                    fields.add(new SortedNumericDocValuesField(name, value.intValue()));
                }
                if (stored) {
                    fields.add(new StoredField(name, value.intValue()));
                }
                return fields;
            }

            @Override
            Number valueForSearch(String value) {
                return Integer.parseInt(value);
            }
        }
        ,
        LONG("long", IndexNumericFieldData.NumericType.LONG){

            @Override
            public Long parse(Object value, boolean coerce) {
                return 7.objectToLong(value, coerce);
            }

            @Override
            public Number parsePoint(byte[] value) {
                return LongPoint.decodeDimension(value, 0);
            }

            @Override
            public byte[] encodePoint(Number value) {
                byte[] point = new byte[8];
                LongPoint.encodeDimension(value.longValue(), point, 0);
                return point;
            }

            @Override
            public double toDoubleValue(long value) {
                return value;
            }

            @Override
            public Long parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.longValue(coerce);
            }

            @Override
            public Query termQuery(String field, Object value, boolean hasDocValues, boolean isSearchable) {
                if (7.hasDecimalPart(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + String.valueOf(value) + "] has a decimal part");
                }
                long v = this.parse(value, true);
                if (isSearchable && hasDocValues) {
                    Query query = LongPoint.newExactQuery(field, v);
                    Query dvQuery = SortedNumericDocValuesField.newSlowExactQuery(field, v);
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowExactQuery(field, v);
                }
                return LongPoint.newExactQuery(field, v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values, boolean hasDocValues, boolean isSearchable) {
                long[] v = new long[values.size()];
                int upTo = 0;
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (7.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value, true);
                }
                if (upTo == 0) {
                    return Queries.newMatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                if (isSearchable && hasDocValues) {
                    return new IndexOrDocValuesQuery(LongPoint.newSetQuery(field, v), SortedNumericDocValuesField.newSlowSetQuery(field, v));
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowSetQuery(field, v);
                }
                return LongPoint.newSetQuery(field, v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isSearchable, QueryShardContext context) {
                return 7.longRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (l, u) -> {
                    if (isSearchable && hasDocValues) {
                        Query query = LongPoint.newRangeQuery(field, l, u);
                        Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery(field, l, u);
                        query = new IndexOrDocValuesQuery(query, dvQuery);
                        if (context.indexSortedOnField(field)) {
                            query = new IndexSortSortedNumericDocValuesRangeQuery(field, (long)l, (long)u, query);
                        }
                        return query;
                    }
                    if (hasDocValues) {
                        Query query = SortedNumericDocValuesField.newSlowRangeQuery(field, l, u);
                        if (context.indexSortedOnField(field)) {
                            query = new IndexSortSortedNumericDocValuesRangeQuery(field, (long)l, (long)u, query);
                        }
                        return query;
                    }
                    return LongPoint.newRangeQuery(field, l, u);
                });
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add(new LongPoint(name, value.longValue()));
                }
                if (docValued) {
                    fields.add(new SortedNumericDocValuesField(name, value.longValue()));
                }
                if (stored) {
                    fields.add(new StoredField(name, value.longValue()));
                }
                return fields;
            }

            @Override
            Number valueForSearch(String value) {
                return Long.parseLong(value);
            }
        }
        ,
        UNSIGNED_LONG("unsigned_long", IndexNumericFieldData.NumericType.UNSIGNED_LONG){

            @Override
            public BigInteger parse(Object value, boolean coerce) {
                return 8.objectToUnsignedLong(value, coerce);
            }

            @Override
            public Number parsePoint(byte[] value) {
                return BigIntegerPoint.decodeDimension(value, 0);
            }

            @Override
            public byte[] encodePoint(Number value) {
                byte[] point = new byte[16];
                BigIntegerPoint.encodeDimension(8.objectToUnsignedLong(value, false, true), point, 0);
                return point;
            }

            @Override
            public double toDoubleValue(long value) {
                return Numbers.unsignedLongToDouble(value);
            }

            @Override
            public BigInteger parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.bigIntegerValue(coerce);
            }

            @Override
            public Query termQuery(String field, Object value, boolean hasDocValues, boolean isSearchable) {
                if (8.hasDecimalPart(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + String.valueOf(value) + "] has a decimal part");
                }
                BigInteger v = this.parse(value, true);
                if (isSearchable && hasDocValues) {
                    Query query = BigIntegerPoint.newExactQuery(field, v);
                    Query dvQuery = SortedUnsignedLongDocValuesSetQuery.newSlowExactQuery(field, v);
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocValues) {
                    return SortedUnsignedLongDocValuesSetQuery.newSlowExactQuery(field, v);
                }
                return BigIntegerPoint.newExactQuery(field, v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values, boolean hasDocvalues, boolean isSearchable) {
                BigInteger[] v = new BigInteger[values.size()];
                int upTo = 0;
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (8.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value, true);
                }
                if (upTo == 0) {
                    return Queries.newMatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                if (isSearchable && hasDocvalues) {
                    Query query = BigIntegerPoint.newSetQuery(field, v);
                    Query dvQuery = SortedUnsignedLongDocValuesSetQuery.newSlowSetQuery(field, v);
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocvalues) {
                    return SortedUnsignedLongDocValuesSetQuery.newSlowSetQuery(field, v);
                }
                return BigIntegerPoint.newSetQuery(field, v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isSearchable, QueryShardContext context) {
                return 8.unsignedLongRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (l, u) -> {
                    if (isSearchable && hasDocValues) {
                        Query query = BigIntegerPoint.newRangeQuery(field, l, u);
                        Query dvQuery = SortedUnsignedLongDocValuesRangeQuery.newSlowRangeQuery(field, l, u);
                        return new IndexOrDocValuesQuery(query, dvQuery);
                    }
                    if (hasDocValues) {
                        return SortedUnsignedLongDocValuesRangeQuery.newSlowRangeQuery(field, l, u);
                    }
                    return BigIntegerPoint.newRangeQuery(field, l, u);
                });
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                BigInteger v = Numbers.toUnsignedLongExact(value);
                if (indexed) {
                    fields.add(new BigIntegerPoint(name, v));
                }
                if (docValued) {
                    fields.add(new SortedNumericDocValuesField(name, v.longValue()));
                }
                if (stored) {
                    fields.add(new StoredField(name, v.toString()));
                }
                return fields;
            }

            @Override
            Number valueForSearch(String value) {
                return new BigInteger(value);
            }
        };

        private final String name;
        private final IndexNumericFieldData.NumericType numericType;
        private final ParametrizedFieldMapper.TypeParser parser;

        private NumberType(String name, IndexNumericFieldData.NumericType numericType) {
            this.name = name;
            this.numericType = numericType;
            this.parser = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n, this, c.getSettings()));
        }

        public final String typeName() {
            return this.name;
        }

        public final IndexNumericFieldData.NumericType numericType() {
            return this.numericType;
        }

        public final ParametrizedFieldMapper.TypeParser parser() {
            return this.parser;
        }

        public abstract Query termQuery(String var1, Object var2, boolean var3, boolean var4);

        public abstract Query termsQuery(String var1, List<Object> var2, boolean var3, boolean var4);

        public Query bitmapQuery(String field, BytesArray bitmap, boolean isSearchable, boolean hasDocValues) {
            throw new IllegalArgumentException("Field [" + this.name + "] of type [" + this.typeName() + "] does not support bitmap queries");
        }

        public abstract Query rangeQuery(String var1, Object var2, Object var3, boolean var4, boolean var5, boolean var6, boolean var7, QueryShardContext var8);

        public abstract Number parse(XContentParser var1, boolean var2) throws IOException;

        public abstract Number parse(Object var1, boolean var2);

        public abstract Number parsePoint(byte[] var1);

        public abstract List<Field> createFields(String var1, Number var2, boolean var3, boolean var4, boolean var5);

        abstract Number valueForSearch(String var1);

        Number valueForSearch(Number value) {
            return value;
        }

        public static boolean hasDecimalPart(Object number) {
            if (number instanceof Number) {
                double doubleValue = ((Number)number).doubleValue();
                return doubleValue % 1.0 != 0.0;
            }
            if (number instanceof BytesRef) {
                number = ((BytesRef)number).utf8ToString();
            }
            if (number instanceof String) {
                return Double.parseDouble((String)number) % 1.0 != 0.0;
            }
            return false;
        }

        public static double signum(Object value) {
            if (value instanceof Number) {
                double doubleValue = ((Number)value).doubleValue();
                return Math.signum(doubleValue);
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return Math.signum(Double.parseDouble(value.toString()));
        }

        public static double objectToDouble(Object value) {
            double doubleValue = value instanceof Number ? ((Number)value).doubleValue() : (value instanceof BytesRef ? Double.parseDouble(((BytesRef)value).utf8ToString()) : Double.parseDouble(value.toString()));
            return doubleValue;
        }

        public static long objectToLong(Object value, boolean coerce) {
            if (value instanceof Long) {
                return (Long)value;
            }
            double doubleValue = NumberType.objectToDouble(value);
            if (doubleValue < -9.223372036854776E18 || doubleValue > 9.223372036854776E18) {
                throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] is out of range for a long");
            }
            if (!coerce && doubleValue % 1.0 != 0.0) {
                throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] has a decimal part");
            }
            String stringValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            return Numbers.toLong(stringValue, coerce);
        }

        public static BigInteger objectToUnsignedLong(Object value, boolean coerce) {
            return NumberType.objectToUnsignedLong(value, coerce, false);
        }

        public static BigInteger objectToUnsignedLong(Object value, boolean coerce, boolean lenientBound) {
            if (value instanceof Long) {
                return Numbers.toUnsignedBigInteger((Long)value);
            }
            double doubleValue = NumberType.objectToDouble(value);
            if (lenientBound) {
                if (doubleValue < Numbers.MIN_UNSIGNED_LONG_VALUE.doubleValue()) {
                    return Numbers.MIN_UNSIGNED_LONG_VALUE;
                }
                if (doubleValue > Numbers.MAX_UNSIGNED_LONG_VALUE.doubleValue()) {
                    return Numbers.MAX_UNSIGNED_LONG_VALUE;
                }
            }
            if (doubleValue < Numbers.MIN_UNSIGNED_LONG_VALUE.doubleValue() || doubleValue > Numbers.MAX_UNSIGNED_LONG_VALUE.doubleValue()) {
                throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] is out of range for an unsigned long");
            }
            if (!coerce && doubleValue % 1.0 != 0.0) {
                throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] has a decimal part");
            }
            String stringValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            return Numbers.toUnsignedLong(stringValue, coerce);
        }

        public static Query doubleRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, BiFunction<Double, Double, Query> builder) {
            double l = Double.NEGATIVE_INFINITY;
            double u = Double.POSITIVE_INFINITY;
            if (lowerTerm != null) {
                l = NumberType.objectToDouble(lowerTerm);
                if (!includeLower) {
                    l = DoublePoint.nextUp(l);
                }
            }
            if (upperTerm != null) {
                u = NumberType.objectToDouble(upperTerm);
                if (!includeUpper) {
                    u = DoublePoint.nextDown(u);
                }
            }
            return builder.apply(l, u);
        }

        public static Query longRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, BiFunction<Long, Long, Query> builder) {
            long l = Long.MIN_VALUE;
            long u = Long.MAX_VALUE;
            if (lowerTerm != null) {
                l = NumberType.objectToLong(lowerTerm, true);
                boolean lowerTermHasDecimalPart = NumberType.hasDecimalPart(lowerTerm);
                if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && NumberType.signum(lowerTerm) > 0.0) {
                    if (l == Long.MAX_VALUE) {
                        return new MatchNoDocsQuery();
                    }
                    ++l;
                }
            }
            if (upperTerm != null) {
                u = NumberType.objectToLong(upperTerm, true);
                boolean upperTermHasDecimalPart = NumberType.hasDecimalPart(upperTerm);
                if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && NumberType.signum(upperTerm) < 0.0) {
                    if (u == Long.MIN_VALUE) {
                        return new MatchNoDocsQuery();
                    }
                    --u;
                }
            }
            return builder.apply(l, u);
        }

        public static Query unsignedLongRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, BiFunction<BigInteger, BigInteger, Query> builder) {
            BigInteger l = Numbers.MIN_UNSIGNED_LONG_VALUE;
            BigInteger u = Numbers.MAX_UNSIGNED_LONG_VALUE;
            if (lowerTerm != null) {
                l = NumberType.objectToUnsignedLong(lowerTerm, true);
                boolean lowerTermHasDecimalPart = NumberType.hasDecimalPart(lowerTerm);
                if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && NumberType.signum(lowerTerm) > 0.0) {
                    if (l.compareTo(Numbers.MAX_UNSIGNED_LONG_VALUE) == 0) {
                        return new MatchNoDocsQuery();
                    }
                    l = l.add(BigInteger.ONE);
                }
            }
            if (upperTerm != null) {
                u = NumberType.objectToUnsignedLong(upperTerm, true);
                boolean upperTermHasDecimalPart = NumberType.hasDecimalPart(upperTerm);
                if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && NumberType.signum(upperTerm) < 0.0) {
                    if (u.compareTo(Numbers.MAX_UNSIGNED_LONG_VALUE) == 0) {
                        return new MatchNoDocsQuery();
                    }
                    u = u.subtract(BigInteger.ONE);
                }
            }
            if (l.compareTo(u) > 0) {
                return new MatchNoDocsQuery();
            }
            return builder.apply(l, u);
        }
    }

    public static class NumberFieldType
    extends SimpleMappedFieldType
    implements NumericPointEncoder,
    FieldValueConverter {
        private final NumberType type;
        private final boolean coerce;
        private final Number nullValue;

        public NumberFieldType(String name, NumberType type, boolean isSearchable, boolean isStored, boolean hasDocValues, boolean coerce, Number nullValue, Map<String, String> meta) {
            super(name, isSearchable, isStored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.type = Objects.requireNonNull(type);
            this.coerce = coerce;
            this.nullValue = nullValue;
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        NumberFieldType(String name, Builder builder) {
            this(name, builder.type, builder.indexed.getValue(), builder.stored.getValue(), builder.hasDocValues.getValue(), builder.coerce.getValue().value(), builder.nullValue.getValue(), builder.meta.getValue());
        }

        public NumberFieldType(String name, NumberType type) {
            this(name, type, true, false, true, true, null, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return this.type.name;
        }

        public NumberType numberType() {
            return this.type;
        }

        public IndexNumericFieldData.NumericType numericType() {
            return this.type.numericType();
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            Query query = this.type.termQuery(this.name(), value, this.hasDocValues(), this.isSearchable());
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        public Query termsQuery(List values, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            Query query = this.type.termsQuery(this.name(), values, this.hasDocValues(), this.isSearchable());
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        public Query bitmapQuery(BytesArray bitmap) {
            this.failIfNotIndexedAndNoDocValues();
            return this.type.bitmapQuery(this.name(), bitmap, this.isSearchable(), this.hasDocValues());
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            Query query = this.type.rangeQuery(this.name(), lowerTerm, upperTerm, includeLower, includeUpper, this.hasDocValues(), this.isSearchable(), context);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Function<byte[], Number> pointReaderIfPossible() {
            if (this.isSearchable()) {
                return this::parsePoint;
            }
            return null;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(this.name(), this.type.numericType());
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return this.type.valueForSearch((String)value);
            }
            return this.type.valueForSearch((Number)value);
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                protected Object parseSourceValue(Object value) {
                    if (value.equals("")) {
                        return nullValue;
                    }
                    return type.parse(value, coerce);
                }
            };
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            if (format == null) {
                if (this.type == NumberType.UNSIGNED_LONG) {
                    return DocValueFormat.UNSIGNED_LONG;
                }
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }

        public Number parsePoint(byte[] value) {
            return this.type.parsePoint(value);
        }

        @Override
        public byte[] encodePoint(Number value) {
            return this.type.encodePoint(value);
        }

        @Override
        public double toDoubleValue(long value) {
            return this.type.toDoubleValue(value);
        }
    }
}

