/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.ParsingException;
import org.opensearch.index.query.QueryRewriteContext;

@PublicApi(since="1.0.0")
public interface Rewriteable<T> {
    public static final int MAX_REWRITE_ROUNDS = 16;

    public T rewrite(QueryRewriteContext var1) throws IOException;

    public static <T extends Rewriteable<T>> T rewrite(T original, QueryRewriteContext context) throws IOException {
        return Rewriteable.rewrite(original, context, false);
    }

    public static <T extends Rewriteable<T>> T rewrite(T original, QueryRewriteContext context, boolean assertNoAsyncTasks) throws IOException {
        Object builder = original;
        int iteration = 0;
        Rewriteable rewrittenBuilder = (Rewriteable)builder.rewrite(context);
        while (rewrittenBuilder != builder) {
            if (assertNoAsyncTasks && context.hasAsyncActions()) {
                throw new IllegalStateException("async actions are left after rewrite");
            }
            builder = rewrittenBuilder;
            if (iteration++ >= 16) {
                throw new IllegalStateException("too many rewrite rounds, rewriteable might return new objects even if they are not rewritten");
            }
            rewrittenBuilder = (Rewriteable)builder.rewrite(context);
        }
        return (T)builder;
    }

    public static <T extends Rewriteable<T>> void rewriteAndFetch(T original, QueryRewriteContext context, ActionListener<T> rewriteResponse) {
        Rewriteable.rewriteAndFetch(original, context, rewriteResponse, 0);
    }

    public static <T extends Rewriteable<T>> void rewriteAndFetch(T original, QueryRewriteContext context, ActionListener<T> rewriteResponse, int iteration) {
        Object builder = original;
        try {
            Rewriteable rewrittenBuilder = (Rewriteable)builder.rewrite(context);
            while (rewrittenBuilder != builder) {
                builder = rewrittenBuilder;
                if (iteration++ >= 16) {
                    throw new IllegalStateException("too many rewrite rounds, rewriteable might return new objects even if they are not rewritten");
                }
                if (context.hasAsyncActions()) {
                    Object finalBuilder = builder;
                    int currentIterationNumber = iteration;
                    context.executeAsyncActions(ActionListener.wrap(arg_0 -> Rewriteable.lambda$rewriteAndFetch$0((Rewriteable)finalBuilder, context, rewriteResponse, currentIterationNumber, arg_0), rewriteResponse::onFailure));
                    return;
                }
                rewrittenBuilder = (Rewriteable)builder.rewrite(context);
            }
            rewriteResponse.onResponse(builder);
        }
        catch (IOException | IllegalArgumentException | ParsingException ex) {
            rewriteResponse.onFailure(ex);
        }
    }

    public static <T extends Rewriteable<T>> List<T> rewrite(List<T> rewritables, QueryRewriteContext context) throws IOException {
        List<T> list = rewritables;
        boolean changed = false;
        if (rewritables != null && !rewritables.isEmpty()) {
            list = new ArrayList<T>(rewritables.size());
            for (Rewriteable instance : rewritables) {
                Rewriteable rewrite;
                if (instance != (rewrite = Rewriteable.rewrite(instance, context))) {
                    changed = true;
                }
                list.add(rewrite);
            }
        }
        return changed ? list : rewritables;
    }

    private static /* synthetic */ void lambda$rewriteAndFetch$0(Rewriteable finalBuilder, QueryRewriteContext context, ActionListener rewriteResponse, int currentIterationNumber, Object n) throws Exception {
        Rewriteable.rewriteAndFetch(finalBuilder, context, rewriteResponse, currentIterationNumber);
    }
}

