/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.file;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.lang.ref.Cleaner;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;

abstract class OnDemandBlockIndexInput
extends IndexInput
implements RandomAccessInput {
    private static final Logger logger = LogManager.getLogger(OnDemandBlockIndexInput.class);
    public static final String CLEANER_THREAD_NAME_PREFIX = "index-input-cleaner";
    private static final Cleaner CLEANER = Cleaner.create(OpenSearchExecutors.daemonThreadFactory("index-input-cleaner"));
    protected final long offset;
    protected final long length;
    protected final boolean isClone;
    protected final int blockSizeShift;
    protected final int blockSize;
    protected final int blockMask;
    private int currentBlockId;
    private final BlockHolder blockHolder = new BlockHolder();

    OnDemandBlockIndexInput(Builder builder) {
        super(builder.resourceDescription);
        this.isClone = builder.isClone;
        this.offset = builder.offset;
        this.length = builder.length;
        this.blockSizeShift = builder.blockSizeShift;
        this.blockSize = builder.blockSize;
        this.blockMask = builder.blockMask;
        CLEANER.register(this, this.blockHolder);
    }

    protected abstract OnDemandBlockIndexInput buildSlice(String var1, long var2, long var4);

    protected abstract IndexInput fetchBlock(int var1) throws IOException;

    @Override
    public abstract OnDemandBlockIndexInput clone();

    @Override
    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        if (offset < 0L || length < 0L || offset + length > this.length()) {
            throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: offset=" + offset + ",length=" + length + ",fileLength=" + this.length() + ": " + String.valueOf(this));
        }
        return this.buildSlice(sliceDescription, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.blockHolder.close();
        this.currentBlockId = 0;
    }

    @Override
    public long getFilePointer() {
        if (this.blockHolder.block == null) {
            return 0L;
        }
        return this.currentBlockStart() + (long)this.currentBlockPosition() - this.offset;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.blockHolder.block == null) {
            this.seek(0L);
        } else if (this.currentBlockPosition() >= this.blockSize) {
            int blockId = this.currentBlockId + 1;
            this.demandBlock(blockId);
        }
        return this.blockHolder.block.readByte();
    }

    @Override
    public short readShort() throws IOException {
        if (this.blockHolder.block != null && 2 <= this.blockSize - this.currentBlockPosition()) {
            return this.blockHolder.block.readShort();
        }
        return super.readShort();
    }

    @Override
    public int readInt() throws IOException {
        if (this.blockHolder.block != null && 4 <= this.blockSize - this.currentBlockPosition()) {
            return this.blockHolder.block.readInt();
        }
        return super.readInt();
    }

    @Override
    public long readLong() throws IOException {
        if (this.blockHolder.block != null && 8 <= this.blockSize - this.currentBlockPosition()) {
            return this.blockHolder.block.readLong();
        }
        return super.readLong();
    }

    @Override
    public final int readVInt() throws IOException {
        if (this.blockHolder.block != null && 5 <= this.blockSize - this.currentBlockPosition()) {
            return this.blockHolder.block.readVInt();
        }
        return super.readVInt();
    }

    @Override
    public final long readVLong() throws IOException {
        if (this.blockHolder.block != null && 9 <= this.blockSize - this.currentBlockPosition()) {
            return this.blockHolder.block.readVLong();
        }
        return super.readVLong();
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos > this.length()) {
            throw new EOFException("read past EOF: pos=" + pos + " vs length=" + this.length() + ": " + String.valueOf(this));
        }
        this.seekInternal(pos + this.offset);
    }

    @Override
    public final byte readByte(long pos) throws IOException {
        if (this.blockHolder.block != null && this.isInCurrentBlockRange(pos += this.offset)) {
            return ((RandomAccessInput)((Object)this.blockHolder.block)).readByte(this.getBlockOffset(pos));
        }
        this.seekInternal(pos);
        return this.blockHolder.block.readByte();
    }

    @Override
    public short readShort(long pos) throws IOException {
        if (this.blockHolder.block != null && this.isInCurrentBlockRange(pos += this.offset, 2)) {
            return ((RandomAccessInput)((Object)this.blockHolder.block)).readShort(this.getBlockOffset(pos));
        }
        this.seekInternal(pos);
        return super.readShort();
    }

    @Override
    public int readInt(long pos) throws IOException {
        if (this.blockHolder.block != null && this.isInCurrentBlockRange(pos += this.offset, 4)) {
            return ((RandomAccessInput)((Object)this.blockHolder.block)).readInt(this.getBlockOffset(pos));
        }
        this.seekInternal(pos);
        return super.readInt();
    }

    @Override
    public long readLong(long pos) throws IOException {
        if (this.blockHolder.block != null && this.isInCurrentBlockRange(pos += this.offset, 8)) {
            return ((RandomAccessInput)((Object)this.blockHolder.block)).readLong(this.getBlockOffset(pos));
        }
        this.seekInternal(pos);
        return super.readLong();
    }

    @Override
    public final void readBytes(byte[] b, int offset, int len) throws IOException {
        int available;
        if (this.blockHolder.block == null) {
            this.seek(0L);
        }
        if (len <= (available = this.blockSize - this.currentBlockPosition())) {
            this.blockHolder.block.readBytes(b, offset, len);
        } else {
            if (available > 0) {
                this.blockHolder.block.readBytes(b, offset, available);
                offset += available;
                len -= available;
            }
            while (len > 0) {
                int blockId = this.currentBlockId + 1;
                int toRead = Math.min(len, this.blockSize);
                this.demandBlock(blockId);
                this.blockHolder.block.readBytes(b, offset, toRead);
                offset += toRead;
                len -= toRead;
            }
        }
    }

    private void seekInternal(long pos) throws IOException {
        if (this.blockHolder.block == null || !this.isInCurrentBlockRange(pos)) {
            this.demandBlock(this.getBlock(pos));
        }
        this.blockHolder.block.seek(this.getBlockOffset(pos));
    }

    private boolean isInCurrentBlockRange(long pos) {
        long offset = pos - this.currentBlockStart();
        return offset >= 0L && offset < (long)this.blockSize;
    }

    private boolean isInCurrentBlockRange(long pos, int len) {
        long offset = pos - this.currentBlockStart();
        return offset >= 0L && offset + (long)len <= (long)this.blockSize;
    }

    private void demandBlock(int blockId) throws IOException {
        if (this.blockHolder.block != null && this.currentBlockId == blockId) {
            return;
        }
        this.blockHolder.close();
        this.blockHolder.set(this.fetchBlock(blockId));
        this.currentBlockId = blockId;
    }

    protected void cloneBlock(OnDemandBlockIndexInput other) {
        if (other.blockHolder.block != null) {
            this.blockHolder.set(other.blockHolder.block.clone());
            this.currentBlockId = other.currentBlockId;
        }
    }

    protected int getBlock(long pos) {
        return (int)(pos >>> this.blockSizeShift);
    }

    protected int getBlockOffset(long pos) {
        return (int)(pos & (long)this.blockMask);
    }

    protected long getBlockStart(int blockId) {
        return (long)blockId << this.blockSizeShift;
    }

    protected long currentBlockStart() {
        return this.getBlockStart(this.currentBlockId);
    }

    protected int currentBlockPosition() {
        return (int)this.blockHolder.block.getFilePointer();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        public static final int DEFAULT_BLOCK_SIZE_SHIFT = 23;
        public static final int DEFAULT_BLOCK_SIZE = 0x800000;
        private String resourceDescription;
        private boolean isClone;
        private long offset;
        private long length;
        private int blockSizeShift = 23;
        private int blockSize = 1 << this.blockSizeShift;
        private int blockMask = this.blockSize - 1;

        private Builder() {
        }

        public Builder resourceDescription(String resourceDescription) {
            this.resourceDescription = resourceDescription;
            return this;
        }

        public Builder isClone(boolean clone) {
            this.isClone = clone;
            return this;
        }

        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder length(long length) {
            this.length = length;
            return this;
        }

        Builder blockSizeShift(int blockSizeShift) {
            assert (blockSizeShift < 31) : "blockSizeShift must be < 31";
            this.blockSizeShift = blockSizeShift;
            this.blockSize = 1 << blockSizeShift;
            this.blockMask = this.blockSize - 1;
            return this;
        }
    }

    private static class BlockHolder
    implements Closeable,
    Runnable {
        private volatile IndexInput block;

        private BlockHolder() {
        }

        private void set(IndexInput block) {
            if (this.block != null) {
                throw new IllegalStateException("Previous block was not closed!");
            }
            this.block = Objects.requireNonNull(block);
        }

        @Override
        public void close() throws IOException {
            if (this.block != null) {
                this.block.close();
                this.block = null;
            }
        }

        @Override
        public void run() {
            try {
                this.close();
            }
            catch (IOException e) {
                logger.info("Exception thrown while closing block owned by phantom reachable instance", (Throwable)e);
            }
        }
    }
}

