/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.termvectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.memory.MemoryIndex;
import org.opensearch.OpenSearchException;
import org.opensearch.action.termvectors.TermVectorsFilter;
import org.opensearch.action.termvectors.TermVectorsRequest;
import org.opensearch.action.termvectors.TermVectorsResponse;
import org.opensearch.common.Nullable;
import org.opensearch.common.document.DocumentField;
import org.opensearch.common.lucene.uid.VersionsAndSeqNoResolver;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.get.GetResult;
import org.opensearch.index.mapper.DocumentMapperForType;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.ParsedDocument;
import org.opensearch.index.mapper.SourceToParse;
import org.opensearch.index.mapper.StringFieldType;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.Uid;
import org.opensearch.index.shard.IndexShard;

public class TermVectorsService {
    private TermVectorsService() {
    }

    public static TermVectorsResponse getTermVectors(IndexShard indexShard, TermVectorsRequest request) {
        return TermVectorsService.getTermVectors(indexShard, request, System::nanoTime);
    }

    static TermVectorsResponse getTermVectors(IndexShard indexShard, TermVectorsRequest request, LongSupplier nanoTimeSupplier) {
        long startTime = nanoTimeSupplier.getAsLong();
        TermVectorsResponse termVectorsResponse = new TermVectorsResponse(indexShard.shardId().getIndex().getName(), request.id());
        Term uidTerm = new Term("_id", Uid.encodeId(request.id()));
        Fields termVectorsByField = null;
        TermVectorsFilter termVectorsFilter = null;
        if (request.selectedFields() != null) {
            TermVectorsService.handleFieldWildcards(indexShard, request);
        }
        try (Engine.GetResult get = indexShard.get(new Engine.Get(request.realtime(), false, request.id(), uidTerm).version(request.version()).versionType(request.versionType()));
             Engine.Searcher searcher = indexShard.acquireSearcher("term_vector");){
            Fields topLevelFields = TermVectorsService.fields(get.searcher() != null ? get.searcher().getIndexReader() : searcher.getIndexReader());
            VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion = get.docIdAndVersion();
            if (request.doc() != null) {
                termVectorsByField = TermVectorsService.generateTermVectorsFromDoc(indexShard, request);
                termVectorsResponse.setArtificial(true);
                termVectorsResponse.setExists(true);
            } else if (docIdAndVersion != null) {
                TermVectors termVectors = docIdAndVersion.reader.termVectors();
                termVectorsByField = termVectors.get(docIdAndVersion.docId);
                Set<String> selectedFields = request.selectedFields();
                if (selectedFields == null && request.perFieldAnalyzer() != null) {
                    selectedFields = TermVectorsService.getFieldsToGenerate(request.perFieldAnalyzer(), termVectorsByField);
                }
                if (selectedFields != null) {
                    termVectorsByField = TermVectorsService.addGeneratedTermVectors(indexShard, get, termVectorsByField, request, selectedFields);
                }
                termVectorsResponse.setDocVersion(docIdAndVersion.version);
                termVectorsResponse.setExists(true);
            } else {
                termVectorsResponse.setExists(false);
            }
            if (termVectorsByField != null) {
                if (request.filterSettings() != null) {
                    termVectorsFilter = new TermVectorsFilter(termVectorsByField, topLevelFields, request.selectedFields());
                    termVectorsFilter.setSettings(request.filterSettings());
                    try {
                        termVectorsFilter.selectBestTerms();
                    }
                    catch (IOException e) {
                        throw new OpenSearchException("failed to select best terms", (Throwable)e, new Object[0]);
                    }
                }
                termVectorsResponse.setFields(termVectorsByField, request.selectedFields(), request.getFlags(), topLevelFields, termVectorsFilter);
            }
            termVectorsResponse.setTookInMillis(TimeUnit.NANOSECONDS.toMillis(nanoTimeSupplier.getAsLong() - startTime));
        }
        catch (Exception ex) {
            throw new OpenSearchException("failed to execute term vector request", (Throwable)ex, new Object[0]);
        }
        return termVectorsResponse;
    }

    public static Fields fields(final IndexReader reader) {
        return new Fields(){

            @Override
            public Iterator<String> iterator() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Terms terms(String field) throws IOException {
                return MultiTerms.getTerms(reader, field);
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static void handleFieldWildcards(IndexShard indexShard, TermVectorsRequest request) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (String pattern : request.selectedFields()) {
            fieldNames.addAll(indexShard.mapperService().simpleMatchToFullName(pattern));
        }
        request.selectedFields(fieldNames.toArray(Strings.EMPTY_ARRAY));
    }

    private static boolean isValidField(MappedFieldType fieldType) {
        if (!(fieldType instanceof StringFieldType)) {
            return false;
        }
        return fieldType.isSearchable();
    }

    private static Fields addGeneratedTermVectors(IndexShard indexShard, Engine.GetResult get, Fields termVectorsByField, TermVectorsRequest request, Set<String> selectedFields) throws IOException {
        HashSet<String> validFields = new HashSet<String>();
        for (String field : selectedFields) {
            MappedFieldType fieldType = indexShard.mapperService().fieldType(field);
            if (!TermVectorsService.isValidField(fieldType) || fieldType.getTextSearchInfo().termVectors() != TextSearchInfo.TermVector.NONE && (request.perFieldAnalyzer() == null || !request.perFieldAnalyzer().containsKey(field))) continue;
            validFields.add(field);
        }
        if (validFields.isEmpty()) {
            return termVectorsByField;
        }
        String[] getFields = validFields.toArray(new String[validFields.size() + 1]);
        getFields[getFields.length - 1] = "_source";
        GetResult getResult = indexShard.getService().get(get, request.id(), getFields, null);
        Fields generatedTermVectors = TermVectorsService.generateTermVectors(indexShard, getResult.sourceAsMap(), getResult.getFields().values(), request.offsets(), request.perFieldAnalyzer(), validFields);
        if (termVectorsByField == null) {
            return generatedTermVectors;
        }
        return TermVectorsService.mergeFields(termVectorsByField, generatedTermVectors);
    }

    private static Analyzer getAnalyzerAtField(IndexShard indexShard, String field, @Nullable Map<String, String> perFieldAnalyzer) {
        NamedAnalyzer analyzer;
        MapperService mapperService = indexShard.mapperService();
        if (perFieldAnalyzer != null && perFieldAnalyzer.containsKey(field)) {
            analyzer = mapperService.getIndexAnalyzers().get(perFieldAnalyzer.get(field));
        } else {
            MappedFieldType fieldType = mapperService.fieldType(field);
            analyzer = fieldType.indexAnalyzer();
        }
        if (analyzer == null) {
            analyzer = mapperService.getIndexAnalyzers().getDefaultIndexAnalyzer();
        }
        return analyzer;
    }

    private static Set<String> getFieldsToGenerate(Map<String, String> perAnalyzerField, Fields fieldsObject) {
        HashSet<String> selectedFields = new HashSet<String>();
        for (String fieldName : fieldsObject) {
            if (!perAnalyzerField.containsKey(fieldName)) continue;
            selectedFields.add(fieldName);
        }
        return selectedFields;
    }

    private static Fields generateTermVectors(IndexShard indexShard, Map<String, Object> source, Collection<DocumentField> getFields, boolean withOffsets, @Nullable Map<String, String> perFieldAnalyzer, Set<String> fields) throws IOException {
        HashMap<String, List<Object>> values = new HashMap<String, List<Object>>();
        for (DocumentField documentField : getFields) {
            String string = documentField.getName();
            if (!fields.contains(string)) continue;
            values.put(string, documentField.getValues());
        }
        if (source != null) {
            for (String string : fields) {
                List<Object> list;
                if (values.containsKey(string) || (list = XContentMapValues.extractRawValues(string, source)).isEmpty()) continue;
                values.put(string, list);
            }
        }
        MemoryIndex index = new MemoryIndex(withOffsets);
        for (Map.Entry entry : values.entrySet()) {
            String field = (String)entry.getKey();
            Analyzer analyzer = TermVectorsService.getAnalyzerAtField(indexShard, field, perFieldAnalyzer);
            if (entry.getValue() instanceof List) {
                for (Object text : (Collection)entry.getValue()) {
                    index.addField(field, text.toString(), analyzer);
                }
                continue;
            }
            index.addField(field, ((Collection)entry.getValue()).toString(), analyzer);
        }
        TermVectors termVectors = index.createSearcher().getIndexReader().termVectors();
        return termVectors.get(0);
    }

    private static Fields generateTermVectorsFromDoc(IndexShard indexShard, TermVectorsRequest request) throws IOException {
        ParsedDocument parsedDocument = TermVectorsService.parseDocument(indexShard, indexShard.shardId().getIndexName(), request.doc(), request.xContentType(), request.routing());
        ParseContext.Document doc = parsedDocument.rootDoc();
        HashSet<String> seenFields = new HashSet<String>();
        HashSet<DocumentField> documentFields = new HashSet<DocumentField>();
        for (IndexableField field : doc.getFields()) {
            MappedFieldType fieldType = indexShard.mapperService().fieldType(field.name());
            if (!TermVectorsService.isValidField(fieldType) || request.selectedFields() != null && !request.selectedFields().contains(field.name()) || seenFields.contains(field.name())) continue;
            seenFields.add(field.name());
            String[] values = TermVectorsService.getValues(doc.getFields(field.name()));
            documentFields.add(new DocumentField(field.name(), Arrays.asList((Object[])values)));
        }
        return TermVectorsService.generateTermVectors(indexShard, XContentHelper.convertToMap(parsedDocument.source(), true, request.xContentType()).v2(), documentFields, request.offsets(), request.perFieldAnalyzer(), seenFields);
    }

    public static String[] getValues(IndexableField[] fields) {
        ArrayList<String> result = new ArrayList<String>();
        for (IndexableField field : fields) {
            if (field.fieldType().indexOptions() == IndexOptions.NONE) continue;
            if (field.binaryValue() != null) {
                result.add(field.binaryValue().utf8ToString());
                continue;
            }
            result.add(field.stringValue());
        }
        return result.toArray(new String[0]);
    }

    private static ParsedDocument parseDocument(IndexShard indexShard, String index, BytesReference doc, MediaType mediaType, String routing) {
        MapperService mapperService = indexShard.mapperService();
        DocumentMapperForType docMapper = mapperService.documentMapperWithAutoCreate();
        ParsedDocument parsedDocument = docMapper.getDocumentMapper().parse(new SourceToParse(index, "_id_for_tv_api", doc, mediaType, routing));
        if (docMapper.getMapping() != null) {
            parsedDocument.addDynamicMappingsUpdate(docMapper.getMapping());
        }
        return parsedDocument;
    }

    private static Fields mergeFields(Fields fields1, Fields fields2) throws IOException {
        Terms terms;
        ParallelFields parallelFields = new ParallelFields();
        for (String fieldName : fields2) {
            terms = fields2.terms(fieldName);
            if (terms == null) continue;
            parallelFields.addField(fieldName, terms);
        }
        for (String fieldName : fields1) {
            if (parallelFields.fields.containsKey(fieldName) || (terms = fields1.terms(fieldName)) == null) continue;
            parallelFields.addField(fieldName, terms);
        }
        return parallelFields;
    }

    private static final class ParallelFields
    extends Fields {
        final Map<String, Terms> fields = new TreeMap<String, Terms>();

        ParallelFields() {
        }

        void addField(String fieldName, Terms terms) {
            this.fields.put(fieldName, terms);
        }

        @Override
        public Iterator<String> iterator() {
            return Collections.unmodifiableSet(this.fields.keySet()).iterator();
        }

        @Override
        public Terms terms(String field) {
            return this.fields.get(field);
        }

        @Override
        public int size() {
            return this.fields.size();
        }
    }
}

