/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.join.aggregations;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.join.aggregations.InternalChildren;
import org.opensearch.join.aggregations.ParentToChildrenAggregator;
import org.opensearch.search.aggregations.AggregationExecutionException;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.NonCollectingAggregator;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

public class ChildrenAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final Query parentFilter;
    private final Query childFilter;

    public ChildrenAggregatorFactory(String name, ValuesSourceConfig config, Query childFilter, Query parentFilter, QueryShardContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.childFilter = childFilter;
        this.parentFilter = parentFilter;
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new NonCollectingAggregator(this.name, searchContext, parent, this.factories, metadata){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return new InternalChildren(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
            }
        };
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        ValuesSource rawValuesSource = this.config.getValuesSource();
        if (!(rawValuesSource instanceof ValuesSource.Bytes.WithOrdinals)) {
            throw new AggregationExecutionException("ValuesSource type " + rawValuesSource.toString() + "is not supported for aggregation " + this.name());
        }
        ValuesSource.Bytes.WithOrdinals valuesSource = (ValuesSource.Bytes.WithOrdinals)rawValuesSource;
        long maxOrd = valuesSource.globalMaxOrd(searchContext.searcher());
        return new ParentToChildrenAggregator(this.name, this.factories, searchContext, parent, this.childFilter, this.parentFilter, valuesSource, maxOrd, cardinality, metadata);
    }

    @Override
    public String getStatsSubtype() {
        return "other";
    }

    @Override
    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

