/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.list;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.pagination.IndexPaginationStrategy;
import org.opensearch.action.pagination.PageParams;
import org.opensearch.common.breaker.ResponseLimitSettings;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.cat.RestIndicesAction;

public class RestIndicesListAction
extends RestIndicesAction {
    private static final int MAX_SUPPORTED_LIST_INDICES_PAGE_SIZE = 5000;
    private static final int DEFAULT_LIST_INDICES_PAGE_SIZE = 500;

    public RestIndicesListAction(ResponseLimitSettings responseLimitSettings) {
        super(responseLimitSettings);
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_list/indices"), new RestHandler.Route(RestRequest.Method.GET, "/_list/indices/{index}")));
    }

    @Override
    public String getName() {
        return "list_indices_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_list/indices\n");
        sb.append("/_list/indices/{index}\n");
    }

    @Override
    public boolean isActionPaginated() {
        return true;
    }

    @Override
    protected PageParams validateAndGetPageParams(RestRequest restRequest) {
        PageParams pageParams = super.validateAndGetPageParams(restRequest);
        if (pageParams.getSize() > 5000) {
            throw new IllegalArgumentException("size should be less than [5000]");
        }
        if (Objects.nonNull(pageParams.getRequestedToken())) {
            IndexPaginationStrategy.IndexStrategyToken.validateIndexStrategyToken(pageParams.getRequestedToken());
        }
        return pageParams;
    }

    @Override
    public boolean isRequestLimitCheckSupported() {
        return false;
    }

    @Override
    protected int defaultPageSize() {
        return 500;
    }

    @Override
    protected IndexPaginationStrategy getPaginationStrategy(ClusterStateResponse clusterStateResponse) {
        return new IndexPaginationStrategy(this.pageParams, clusterStateResponse.getState());
    }

    @Override
    public Iterator<Tuple<String, Settings>> getTableIterator(final String[] indices, final Map<String, Settings> indexSettingsMap) {
        return new Iterator<Tuple<String, Settings>>(){
            int indexPos = 0;

            @Override
            public boolean hasNext() {
                while (this.indexPos < indices.length && !indexSettingsMap.containsKey(indices[this.indexPos])) {
                    ++this.indexPos;
                }
                return this.indexPos < indices.length;
            }

            @Override
            public Tuple<String, Settings> next() {
                Tuple<String, Settings> tuple = new Tuple<String, Settings>(indices[this.indexPos], (Settings)indexSettingsMap.get(indices[this.indexPos]));
                ++this.indexPos;
                return tuple;
            }
        };
    }
}

