/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.backpressure.stats;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.backpressure.trackers.CpuUsageTracker;
import org.opensearch.search.backpressure.trackers.ElapsedTimeTracker;
import org.opensearch.search.backpressure.trackers.HeapUsageTracker;
import org.opensearch.search.backpressure.trackers.TaskResourceUsageTrackerType;
import org.opensearch.search.backpressure.trackers.TaskResourceUsageTrackers;

public class SearchTaskStats
implements ToXContentObject,
Writeable {
    private final long cancellationCount;
    private final long limitReachedCount;
    private final Map<TaskResourceUsageTrackerType, TaskResourceUsageTrackers.TaskResourceUsageTracker.Stats> resourceUsageTrackerStats;

    public SearchTaskStats(long cancellationCount, long limitReachedCount, Map<TaskResourceUsageTrackerType, TaskResourceUsageTrackers.TaskResourceUsageTracker.Stats> resourceUsageTrackerStats) {
        this.cancellationCount = cancellationCount;
        this.limitReachedCount = limitReachedCount;
        this.resourceUsageTrackerStats = resourceUsageTrackerStats;
    }

    public SearchTaskStats(StreamInput in) throws IOException {
        this.cancellationCount = in.readVLong();
        this.limitReachedCount = in.readVLong();
        MapBuilder<TaskResourceUsageTrackerType, TaskResourceUsageTrackers.TaskResourceUsageTracker.Stats> builder = new MapBuilder<TaskResourceUsageTrackerType, TaskResourceUsageTrackers.TaskResourceUsageTracker.Stats>();
        builder.put(TaskResourceUsageTrackerType.CPU_USAGE_TRACKER, in.readOptionalWriteable(CpuUsageTracker.Stats::new));
        builder.put(TaskResourceUsageTrackerType.HEAP_USAGE_TRACKER, in.readOptionalWriteable(HeapUsageTracker.Stats::new));
        builder.put(TaskResourceUsageTrackerType.ELAPSED_TIME_TRACKER, in.readOptionalWriteable(ElapsedTimeTracker.Stats::new));
        this.resourceUsageTrackerStats = builder.immutableMap();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("resource_tracker_stats");
        for (Map.Entry<TaskResourceUsageTrackerType, TaskResourceUsageTrackers.TaskResourceUsageTracker.Stats> entry : this.resourceUsageTrackerStats.entrySet()) {
            builder.field(entry.getKey().getName(), entry.getValue());
        }
        builder.endObject();
        builder.startObject("cancellation_stats").field("cancellation_count", this.cancellationCount).field("cancellation_limit_reached_count", this.limitReachedCount).endObject();
        return builder.endObject();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.cancellationCount);
        out.writeVLong(this.limitReachedCount);
        out.writeOptionalWriteable(this.resourceUsageTrackerStats.get((Object)TaskResourceUsageTrackerType.CPU_USAGE_TRACKER));
        out.writeOptionalWriteable(this.resourceUsageTrackerStats.get((Object)TaskResourceUsageTrackerType.HEAP_USAGE_TRACKER));
        out.writeOptionalWriteable(this.resourceUsageTrackerStats.get((Object)TaskResourceUsageTrackerType.ELAPSED_TIME_TRACKER));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchTaskStats that = (SearchTaskStats)o;
        return this.cancellationCount == that.cancellationCount && this.limitReachedCount == that.limitReachedCount && this.resourceUsageTrackerStats.equals(that.resourceUsageTrackerStats);
    }

    public int hashCode() {
        return Objects.hash(this.cancellationCount, this.limitReachedCount, this.resourceUsageTrackerStats);
    }
}

