/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.grouping.CollapseTopFieldDocs;
import org.apache.lucene.search.grouping.CollapsingTopDocsCollector;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.action.search.MaxScoreCollector;
import org.opensearch.common.Nullable;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.lucene.search.TopDocsAndMaxScore;
import org.opensearch.common.lucene.search.function.FunctionScoreQuery;
import org.opensearch.common.lucene.search.function.ScriptScoreQuery;
import org.opensearch.common.util.CachedSupplier;
import org.opensearch.index.search.OpenSearchToParentBlockJoinQuery;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.collapse.CollapseContext;
import org.opensearch.search.internal.ScrollContext;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.query.EarlyTerminatingCollector;
import org.opensearch.search.query.EarlyTerminatingCollectorManager;
import org.opensearch.search.query.EarlyTerminatingListener;
import org.opensearch.search.query.MultiCollectorWrapper;
import org.opensearch.search.query.QueryCollectorContext;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.search.query.ReduceableSearchResult;
import org.opensearch.search.query.RescoringQueryCollectorContext;
import org.opensearch.search.query.TotalHitCountCollectorManager;
import org.opensearch.search.rescore.RescoreContext;
import org.opensearch.search.sort.SortAndFormats;

public abstract class TopDocsCollectorContext
extends QueryCollectorContext
implements RescoringQueryCollectorContext {
    protected final int numHits;

    TopDocsCollectorContext(String profilerName, int numHits) {
        super(profilerName);
        this.numHits = numHits;
    }

    final int numHits() {
        return this.numHits;
    }

    @Override
    public boolean shouldRescore() {
        return false;
    }

    static int shortcutTotalHitCount(IndexReader reader, Query query) throws IOException {
        while (true) {
            if (query instanceof ConstantScoreQuery) {
                query = ((ConstantScoreQuery)query).getQuery();
                continue;
            }
            if (!(query instanceof BoostQuery)) break;
            query = ((BoostQuery)query).getQuery();
        }
        if (query.getClass() == MatchAllDocsQuery.class) {
            return reader.numDocs();
        }
        if (query.getClass() == TermQuery.class && !reader.hasDeletions()) {
            Term term = ((TermQuery)query).getTerm();
            int count = 0;
            for (LeafReaderContext context : reader.leaves()) {
                count += context.reader().docFreq(term);
            }
            return count;
        }
        if (query.getClass() == DocValuesFieldExistsQuery.class && !reader.hasDeletions()) {
            String field = ((DocValuesFieldExistsQuery)query).getField();
            int count = 0;
            for (LeafReaderContext context : reader.leaves()) {
                FieldInfos fieldInfos = context.reader().getFieldInfos();
                FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
                if (fieldInfo == null) continue;
                if (fieldInfo.getPointIndexDimensionCount() > 0) {
                    PointValues points = context.reader().getPointValues(field);
                    if (points == null) continue;
                    count += points.getDocCount();
                    continue;
                }
                if (fieldInfo.getIndexOptions() != IndexOptions.NONE) {
                    Terms terms = context.reader().terms(field);
                    if (terms == null) continue;
                    count += terms.getDocCount();
                    continue;
                }
                return -1;
            }
            return count;
        }
        return -1;
    }

    public static TopDocsCollectorContext createTopDocsCollectorContext(SearchContext searchContext, boolean hasFilterCollector) throws IOException {
        boolean rescore;
        IndexReader reader = searchContext.searcher().getIndexReader();
        Query query = searchContext.query();
        int totalNumDocs = Math.max(1, reader.numDocs());
        if (searchContext.size() == 0) {
            return new EmptyTopDocsCollectorContext(reader, query, searchContext.sort(), searchContext.trackTotalHitsUpTo(), hasFilterCollector);
        }
        if (searchContext.scrollContext() != null) {
            int trackTotalHitsUpTo = searchContext.scrollContext().totalHits != null ? -1 : Integer.MAX_VALUE;
            int numDocs = Math.min(searchContext.size(), totalNumDocs);
            return new ScrollingTopDocsCollectorContext(reader, query, searchContext.scrollContext(), searchContext.sort(), numDocs, searchContext.trackScores(), searchContext.numberOfShards(), trackTotalHitsUpTo, hasFilterCollector);
        }
        if (searchContext.collapse() != null) {
            boolean trackScores = searchContext.sort() == null ? true : searchContext.trackScores();
            int numDocs = Math.min(searchContext.from() + searchContext.size(), totalNumDocs);
            return new CollapsingTopDocsCollectorContext(searchContext.collapse(), searchContext.sort(), numDocs, trackScores);
        }
        int numDocs = Math.min(searchContext.from() + searchContext.size(), totalNumDocs);
        boolean bl = rescore = !searchContext.rescore().isEmpty();
        if (rescore) {
            assert (searchContext.sort() == null);
            for (RescoreContext rescoreContext : searchContext.rescore()) {
                numDocs = Math.max(numDocs, rescoreContext.getWindowSize());
            }
        }
        return new SimpleTopDocsCollectorContext(reader, query, searchContext.sort(), searchContext.searchAfter(), numDocs, searchContext.trackScores(), searchContext.trackTotalHitsUpTo(), hasFilterCollector){

            @Override
            public boolean shouldRescore() {
                return rescore;
            }
        };
    }

    static boolean hasInfMaxScore(Query query) {
        MaxScoreQueryVisitor visitor = new MaxScoreQueryVisitor();
        query.visit(visitor);
        return visitor.hasInfMaxScore;
    }

    static class EmptyTopDocsCollectorContext
    extends TopDocsCollectorContext {
        private final Sort sort;
        private final Collector collector;
        private final Supplier<TotalHits> hitCountSupplier;
        private final int trackTotalHitsUpTo;
        private final int hitCount;

        private EmptyTopDocsCollectorContext(IndexReader reader, Query query, @Nullable SortAndFormats sortAndFormats, int trackTotalHitsUpTo, boolean hasFilterCollector) throws IOException {
            super("search_count", 0);
            this.sort = sortAndFormats == null ? null : sortAndFormats.sort;
            this.trackTotalHitsUpTo = trackTotalHitsUpTo;
            if (this.trackTotalHitsUpTo == -1) {
                this.collector = new EarlyTerminatingCollector(new TotalHitCountCollector(), 0, false);
                this.hitCountSupplier = () -> new TotalHits(0L, TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
                this.hitCount = Integer.MIN_VALUE;
            } else {
                TotalHitCountCollector hitCountCollector = new TotalHitCountCollector();
                int n = this.hitCount = hasFilterCollector ? -1 : EmptyTopDocsCollectorContext.shortcutTotalHitCount(reader, query);
                if (this.hitCount == -1) {
                    if (this.trackTotalHitsUpTo == Integer.MAX_VALUE) {
                        this.collector = hitCountCollector;
                        this.hitCountSupplier = () -> new TotalHits(hitCountCollector.getTotalHits(), TotalHits.Relation.EQUAL_TO);
                    } else {
                        EarlyTerminatingCollector col = new EarlyTerminatingCollector(hitCountCollector, trackTotalHitsUpTo, false);
                        this.collector = col;
                        this.hitCountSupplier = () -> new TotalHits(hitCountCollector.getTotalHits(), col.hasEarlyTerminated() ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO);
                    }
                } else {
                    this.collector = new EarlyTerminatingCollector(hitCountCollector, 0, false);
                    this.hitCountSupplier = () -> new TotalHits(this.hitCount, TotalHits.Relation.EQUAL_TO);
                }
            }
        }

        @Override
        CollectorManager<?, ReduceableSearchResult> createManager(CollectorManager<?, ReduceableSearchResult> in) throws IOException {
            assert (in == null);
            CollectorManager<TotalHitCountCollector, ReduceableSearchResult> manager = null;
            manager = this.trackTotalHitsUpTo == -1 ? new EarlyTerminatingCollectorManager<TotalHitCountCollector>(new TotalHitCountCollectorManager.Empty(new TotalHits(0L, TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO), this.sort), 0, false) : (this.hitCount == -1 ? (this.trackTotalHitsUpTo == Integer.MAX_VALUE ? new TotalHitCountCollectorManager(this.sort) : new EarlyTerminatingCollectorManager<TotalHitCountCollector>(new TotalHitCountCollectorManager(this.sort), this.trackTotalHitsUpTo, false)) : new EarlyTerminatingCollectorManager<TotalHitCountCollector>(new TotalHitCountCollectorManager.Empty(new TotalHits(this.hitCount, TotalHits.Relation.EQUAL_TO), this.sort), 0, false));
            return manager;
        }

        @Override
        Collector create(Collector in) {
            assert (in == null);
            return this.collector;
        }

        @Override
        void postProcess(QuerySearchResult result) {
            TotalHits totalHitCount = this.hitCountSupplier.get();
            TopDocs topDocs = this.sort != null ? new TopFieldDocs(totalHitCount, Lucene.EMPTY_SCORE_DOCS, this.sort.getSort()) : new TopDocs(totalHitCount, Lucene.EMPTY_SCORE_DOCS);
            result.topDocs(new TopDocsAndMaxScore(topDocs, Float.NaN), null);
        }
    }

    static class ScrollingTopDocsCollectorContext
    extends SimpleTopDocsCollectorContext {
        private final ScrollContext scrollContext;
        private final int numberOfShards;

        private ScrollingTopDocsCollectorContext(IndexReader reader, Query query, ScrollContext scrollContext, @Nullable SortAndFormats sortAndFormats, int numHits, boolean trackMaxScore, int numberOfShards, int trackTotalHitsUpTo, boolean hasFilterCollector) throws IOException {
            super(reader, query, sortAndFormats, scrollContext.lastEmittedDoc, numHits, trackMaxScore, trackTotalHitsUpTo, hasFilterCollector);
            this.scrollContext = Objects.requireNonNull(scrollContext);
            this.numberOfShards = numberOfShards;
        }

        @Override
        protected ReduceableSearchResult reduceWith(TopDocs topDocs, float maxScore, Integer terminatedAfter) {
            return result -> {
                TopDocsAndMaxScore topDocsAndMaxScore = this.newTopDocs(topDocs, maxScore, terminatedAfter);
                if (this.scrollContext.totalHits == null) {
                    this.scrollContext.totalHits = topDocsAndMaxScore.topDocs.totalHits;
                    this.scrollContext.maxScore = topDocsAndMaxScore.maxScore;
                } else {
                    topDocsAndMaxScore.topDocs.totalHits = this.scrollContext.totalHits;
                    topDocsAndMaxScore.maxScore = this.scrollContext.maxScore;
                }
                if (this.numberOfShards == 1 && topDocsAndMaxScore.topDocs.scoreDocs.length > 0) {
                    this.scrollContext.lastEmittedDoc = topDocsAndMaxScore.topDocs.scoreDocs[topDocsAndMaxScore.topDocs.scoreDocs.length - 1];
                }
                result.topDocs(topDocsAndMaxScore, this.sortAndFormats == null ? null : this.sortAndFormats.formats);
            };
        }

        @Override
        void postProcess(QuerySearchResult result) throws IOException {
            TopDocsAndMaxScore topDocs = this.newTopDocs();
            if (this.scrollContext.totalHits == null) {
                this.scrollContext.totalHits = topDocs.topDocs.totalHits;
                this.scrollContext.maxScore = topDocs.maxScore;
            } else {
                topDocs.topDocs.totalHits = this.scrollContext.totalHits;
                topDocs.maxScore = this.scrollContext.maxScore;
            }
            if (this.numberOfShards == 1 && topDocs.topDocs.scoreDocs.length > 0) {
                this.scrollContext.lastEmittedDoc = topDocs.topDocs.scoreDocs[topDocs.topDocs.scoreDocs.length - 1];
            }
            result.topDocs(topDocs, this.sortAndFormats == null ? null : this.sortAndFormats.formats);
        }
    }

    static class CollapsingTopDocsCollectorContext
    extends TopDocsCollectorContext {
        private final DocValueFormat[] sortFmt;
        private final CollapsingTopDocsCollector<?> topDocsCollector;
        private final Collector collector;
        private final Supplier<Float> maxScoreSupplier;
        private final CollapseContext collapseContext;
        private final boolean trackMaxScore;
        private final Sort sort;

        private CollapsingTopDocsCollectorContext(CollapseContext collapseContext, @Nullable SortAndFormats sortAndFormats, int numHits, boolean trackMaxScore) {
            super("search_top_hits", numHits);
            DocValueFormat[] docValueFormatArray;
            assert (numHits > 0);
            assert (collapseContext != null);
            Sort sort = this.sort = sortAndFormats == null ? Sort.RELEVANCE : sortAndFormats.sort;
            if (sortAndFormats == null) {
                DocValueFormat[] docValueFormatArray2 = new DocValueFormat[1];
                docValueFormatArray = docValueFormatArray2;
                docValueFormatArray2[0] = DocValueFormat.RAW;
            } else {
                docValueFormatArray = sortAndFormats.formats;
            }
            this.sortFmt = docValueFormatArray;
            this.collapseContext = collapseContext;
            this.topDocsCollector = collapseContext.createTopDocs(this.sort, numHits);
            this.trackMaxScore = trackMaxScore;
            MaxScoreCollector maxScoreCollector = null;
            if (trackMaxScore) {
                maxScoreCollector = new MaxScoreCollector();
                this.maxScoreSupplier = maxScoreCollector::getMaxScore;
            } else {
                maxScoreCollector = null;
                this.maxScoreSupplier = () -> Float.valueOf(Float.NaN);
            }
            this.collector = MultiCollector.wrap(this.topDocsCollector, maxScoreCollector);
        }

        @Override
        Collector create(Collector in) throws IOException {
            assert (in == null);
            return this.collector;
        }

        @Override
        void postProcess(QuerySearchResult result) throws IOException {
            CollapseTopFieldDocs topDocs = this.topDocsCollector.getTopDocs();
            result.topDocs(new TopDocsAndMaxScore(topDocs, this.maxScoreSupplier.get().floatValue()), this.sortFmt);
        }

        @Override
        CollectorManager<?, ReduceableSearchResult> createManager(CollectorManager<?, ReduceableSearchResult> in) throws IOException {
            return new CollectorManager<Collector, ReduceableSearchResult>(){

                @Override
                public Collector newCollector() throws IOException {
                    MaxScoreCollector maxScoreCollector = null;
                    if (trackMaxScore) {
                        maxScoreCollector = new MaxScoreCollector();
                    }
                    return MultiCollectorWrapper.wrap(collapseContext.createTopDocs(sort, numHits), maxScoreCollector);
                }

                @Override
                public ReduceableSearchResult reduce(Collection<Collector> collectors) throws IOException {
                    ArrayList<Collector> subs = new ArrayList<Collector>();
                    for (Collector collector : collectors) {
                        if (collector instanceof MultiCollectorWrapper) {
                            subs.addAll(((MultiCollectorWrapper)collector).getCollectors());
                            continue;
                        }
                        subs.add(collector);
                    }
                    ArrayList<CollapseTopFieldDocs> topFieldDocs = new ArrayList<CollapseTopFieldDocs>();
                    float maxScore = Float.NaN;
                    for (Collector collector : subs) {
                        if (collector instanceof CollapsingTopDocsCollector) {
                            topFieldDocs.add(((CollapsingTopDocsCollector)collector).getTopDocs());
                            continue;
                        }
                        if (!(collector instanceof MaxScoreCollector)) continue;
                        float score = ((MaxScoreCollector)collector).getMaxScore();
                        if (Float.isNaN(maxScore)) {
                            maxScore = score;
                            continue;
                        }
                        maxScore = Math.max(maxScore, score);
                    }
                    return this.reduceWith(topFieldDocs, maxScore);
                }
            };
        }

        protected ReduceableSearchResult reduceWith(Collection<CollapseTopFieldDocs> topFieldDocs, float maxScore) {
            return result -> {
                CollapseTopFieldDocs topDocs = CollapseTopFieldDocs.merge(this.sort, 0, this.numHits, topFieldDocs.toArray(new CollapseTopFieldDocs[0]), true);
                result.topDocs(new TopDocsAndMaxScore(topDocs, maxScore), this.sortFmt);
            };
        }
    }

    private static class MaxScoreQueryVisitor
    extends QueryVisitor {
        private boolean hasInfMaxScore;

        private MaxScoreQueryVisitor() {
        }

        @Override
        public void visitLeaf(Query query) {
            this.checkMaxScoreInfo(query);
        }

        @Override
        public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
            if (occur != BooleanClause.Occur.MUST) {
                return QueryVisitor.EMPTY_VISITOR;
            }
            this.checkMaxScoreInfo(parent);
            return this;
        }

        void checkMaxScoreInfo(Query query) {
            if (query instanceof FunctionScoreQuery || query instanceof ScriptScoreQuery || query instanceof SpanQuery) {
                this.hasInfMaxScore = true;
            } else if (query instanceof OpenSearchToParentBlockJoinQuery) {
                OpenSearchToParentBlockJoinQuery q = (OpenSearchToParentBlockJoinQuery)query;
                this.hasInfMaxScore |= q.getScoreMode() != ScoreMode.None;
            }
        }
    }

    static abstract class SimpleTopDocsCollectorContext
    extends TopDocsCollectorContext {
        @Nullable
        protected final SortAndFormats sortAndFormats;
        private final Collector collector;
        private final Supplier<TotalHits> totalHitsSupplier;
        private final Supplier<TopDocs> topDocsSupplier;
        private final Supplier<Float> maxScoreSupplier;
        private final ScoreDoc searchAfter;
        private final int trackTotalHitsUpTo;
        private final boolean trackMaxScore;
        private final boolean hasInfMaxScore;
        private final int hitCount;

        private static TopDocsCollector<?> createCollector(@Nullable SortAndFormats sortAndFormats, int numHits, @Nullable ScoreDoc searchAfter, int hitCountThreshold) {
            if (sortAndFormats == null) {
                return TopScoreDocCollector.create(numHits, searchAfter, hitCountThreshold);
            }
            return TopFieldCollector.create(sortAndFormats.sort, numHits, (FieldDoc)searchAfter, hitCountThreshold);
        }

        private static CollectorManager<? extends TopDocsCollector<?>, ? extends TopDocs> createCollectorManager(@Nullable SortAndFormats sortAndFormats, int numHits, @Nullable ScoreDoc searchAfter, int hitCountThreshold) {
            if (sortAndFormats == null) {
                if (searchAfter != null) {
                    return TopScoreDocCollector.createSharedManager(numHits, new FieldDoc(searchAfter.doc, searchAfter.score), hitCountThreshold);
                }
                return TopScoreDocCollector.createSharedManager(numHits, null, hitCountThreshold);
            }
            return TopFieldCollector.createSharedManager(sortAndFormats.sort, numHits, (FieldDoc)searchAfter, hitCountThreshold);
        }

        private SimpleTopDocsCollectorContext(IndexReader reader, Query query, @Nullable SortAndFormats sortAndFormats, @Nullable ScoreDoc searchAfter, int numHits, boolean trackMaxScore, int trackTotalHitsUpTo, boolean hasFilterCollector) throws IOException {
            super("search_top_hits", numHits);
            TopDocsCollector<?> topDocsCollector;
            this.sortAndFormats = sortAndFormats;
            this.searchAfter = searchAfter;
            this.trackTotalHitsUpTo = trackTotalHitsUpTo;
            this.trackMaxScore = trackMaxScore;
            this.hasInfMaxScore = SimpleTopDocsCollectorContext.hasInfMaxScore(query);
            if ((sortAndFormats == null || SortField.FIELD_SCORE.equals(sortAndFormats.sort.getSort()[0])) && this.hasInfMaxScore) {
                topDocsCollector = SimpleTopDocsCollectorContext.createCollector(sortAndFormats, numHits, searchAfter, Integer.MAX_VALUE);
                this.topDocsSupplier = new CachedSupplier<TopDocs>(topDocsCollector::topDocs);
                this.totalHitsSupplier = () -> this.topDocsSupplier.get().totalHits;
                this.hitCount = Integer.MIN_VALUE;
            } else if (trackTotalHitsUpTo == -1) {
                topDocsCollector = SimpleTopDocsCollectorContext.createCollector(sortAndFormats, numHits, searchAfter, 1);
                this.topDocsSupplier = new CachedSupplier<TopDocs>(topDocsCollector::topDocs);
                this.totalHitsSupplier = () -> new TotalHits(0L, TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
                this.hitCount = -1;
            } else {
                int n = this.hitCount = hasFilterCollector ? -1 : SimpleTopDocsCollectorContext.shortcutTotalHitCount(reader, query);
                if (this.hitCount == -1) {
                    topDocsCollector = SimpleTopDocsCollectorContext.createCollector(sortAndFormats, numHits, searchAfter, trackTotalHitsUpTo);
                    this.topDocsSupplier = new CachedSupplier<TopDocs>(topDocsCollector::topDocs);
                    this.totalHitsSupplier = () -> this.topDocsSupplier.get().totalHits;
                } else {
                    topDocsCollector = SimpleTopDocsCollectorContext.createCollector(sortAndFormats, numHits, searchAfter, 1);
                    this.topDocsSupplier = new CachedSupplier<TopDocs>(topDocsCollector::topDocs);
                    this.totalHitsSupplier = () -> new TotalHits(this.hitCount, TotalHits.Relation.EQUAL_TO);
                }
            }
            MaxScoreCollector maxScoreCollector = null;
            if (sortAndFormats == null) {
                this.maxScoreSupplier = () -> {
                    TopDocs topDocs = this.topDocsSupplier.get();
                    if (topDocs.scoreDocs.length == 0) {
                        return Float.valueOf(Float.NaN);
                    }
                    return Float.valueOf(topDocs.scoreDocs[0].score);
                };
            } else if (trackMaxScore) {
                maxScoreCollector = new MaxScoreCollector();
                this.maxScoreSupplier = maxScoreCollector::getMaxScore;
            } else {
                this.maxScoreSupplier = () -> Float.valueOf(Float.NaN);
            }
            this.collector = MultiCollector.wrap(topDocsCollector, maxScoreCollector);
        }

        @Override
        CollectorManager<?, ReduceableSearchResult> createManager(CollectorManager<?, ReduceableSearchResult> in) throws IOException {
            assert (in == null);
            return new SimpleTopDocsCollectorManager();
        }

        protected ReduceableSearchResult reduceWith(TopDocs topDocs, float maxScore, Integer terminatedAfter) {
            return result -> {
                TopDocsAndMaxScore topDocsAndMaxScore = this.newTopDocs(topDocs, maxScore, terminatedAfter);
                result.topDocs(topDocsAndMaxScore, this.sortAndFormats == null ? null : this.sortAndFormats.formats);
            };
        }

        @Override
        Collector create(Collector in) {
            assert (in == null);
            return this.collector;
        }

        TopDocsAndMaxScore newTopDocs(TopDocs topDocs, float maxScore, Integer terminatedAfter) {
            TopDocs newTopDocs;
            TotalHits totalHits = null;
            totalHits = (this.sortAndFormats == null || SortField.FIELD_SCORE.equals(this.sortAndFormats.sort.getSort()[0])) && this.hasInfMaxScore ? topDocs.totalHits : (this.trackTotalHitsUpTo == -1 ? new TotalHits(0L, TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO) : (this.hitCount == -1 ? topDocs.totalHits : new TotalHits(this.hitCount, TotalHits.Relation.EQUAL_TO)));
            ScoreDoc[] scoreDocs = topDocs.scoreDocs;
            if (terminatedAfter != null) {
                if (totalHits.value > (long)terminatedAfter.intValue()) {
                    totalHits = new TotalHits(terminatedAfter.intValue(), TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
                }
                if (scoreDocs != null && scoreDocs.length > terminatedAfter) {
                    scoreDocs = Arrays.copyOf(scoreDocs, (int)terminatedAfter);
                }
            }
            if (topDocs instanceof TopFieldDocs) {
                TopFieldDocs fieldDocs = (TopFieldDocs)topDocs;
                newTopDocs = new TopFieldDocs(totalHits, scoreDocs, fieldDocs.fields);
            } else {
                newTopDocs = new TopDocs(totalHits, scoreDocs);
            }
            if (Float.isNaN(maxScore) && newTopDocs.scoreDocs.length > 0 && this.sortAndFormats == null) {
                return new TopDocsAndMaxScore(newTopDocs, newTopDocs.scoreDocs[0].score);
            }
            return new TopDocsAndMaxScore(newTopDocs, maxScore);
        }

        TopDocsAndMaxScore newTopDocs() {
            TopDocs newTopDocs;
            TopDocs in = this.topDocsSupplier.get();
            float maxScore = this.maxScoreSupplier.get().floatValue();
            if (in instanceof TopFieldDocs) {
                TopFieldDocs fieldDocs = (TopFieldDocs)in;
                newTopDocs = new TopFieldDocs(this.totalHitsSupplier.get(), fieldDocs.scoreDocs, fieldDocs.fields);
            } else {
                newTopDocs = new TopDocs(this.totalHitsSupplier.get(), in.scoreDocs);
            }
            return new TopDocsAndMaxScore(newTopDocs, maxScore);
        }

        @Override
        void postProcess(QuerySearchResult result) throws IOException {
            TopDocsAndMaxScore topDocs = this.newTopDocs();
            result.topDocs(topDocs, this.sortAndFormats == null ? null : this.sortAndFormats.formats);
        }

        private class SimpleTopDocsCollectorManager
        implements CollectorManager<Collector, ReduceableSearchResult>,
        EarlyTerminatingListener {
            private Integer terminatedAfter;
            private final CollectorManager<? extends TopDocsCollector<?>, ? extends TopDocs> manager;

            private SimpleTopDocsCollectorManager() {
                this.manager = (SimpleTopDocsCollectorContext.this.sortAndFormats == null || SortField.FIELD_SCORE.equals(SimpleTopDocsCollectorContext.this.sortAndFormats.sort.getSort()[0])) && SimpleTopDocsCollectorContext.this.hasInfMaxScore ? SimpleTopDocsCollectorContext.createCollectorManager(SimpleTopDocsCollectorContext.this.sortAndFormats, SimpleTopDocsCollectorContext.this.numHits, SimpleTopDocsCollectorContext.this.searchAfter, Integer.MAX_VALUE) : (SimpleTopDocsCollectorContext.this.trackTotalHitsUpTo == -1 ? SimpleTopDocsCollectorContext.createCollectorManager(SimpleTopDocsCollectorContext.this.sortAndFormats, SimpleTopDocsCollectorContext.this.numHits, SimpleTopDocsCollectorContext.this.searchAfter, 1) : (SimpleTopDocsCollectorContext.this.hitCount == -1 ? SimpleTopDocsCollectorContext.createCollectorManager(SimpleTopDocsCollectorContext.this.sortAndFormats, SimpleTopDocsCollectorContext.this.numHits, SimpleTopDocsCollectorContext.this.searchAfter, SimpleTopDocsCollectorContext.this.trackTotalHitsUpTo) : SimpleTopDocsCollectorContext.createCollectorManager(SimpleTopDocsCollectorContext.this.sortAndFormats, SimpleTopDocsCollectorContext.this.numHits, SimpleTopDocsCollectorContext.this.searchAfter, 1)));
            }

            @Override
            public void onEarlyTermination(int maxCountHits, boolean forcedTermination) {
                this.terminatedAfter = maxCountHits;
            }

            @Override
            public Collector newCollector() throws IOException {
                MaxScoreCollector maxScoreCollector = null;
                if (SimpleTopDocsCollectorContext.this.sortAndFormats != null && SimpleTopDocsCollectorContext.this.trackMaxScore) {
                    maxScoreCollector = new MaxScoreCollector();
                }
                return MultiCollectorWrapper.wrap(this.manager.newCollector(), maxScoreCollector);
            }

            @Override
            public ReduceableSearchResult reduce(Collection<Collector> collectors) throws IOException {
                ArrayList<TopDocsCollector> topDocsCollectors = new ArrayList<TopDocsCollector>();
                ArrayList<MaxScoreCollector> maxScoreCollectors = new ArrayList<MaxScoreCollector>();
                for (Collector collector : collectors) {
                    if (collector instanceof MultiCollectorWrapper) {
                        for (Collector sub : ((MultiCollectorWrapper)collector).getCollectors()) {
                            if (sub instanceof TopDocsCollector) {
                                topDocsCollectors.add((TopDocsCollector)sub);
                                continue;
                            }
                            if (!(sub instanceof MaxScoreCollector)) continue;
                            maxScoreCollectors.add((MaxScoreCollector)sub);
                        }
                        continue;
                    }
                    if (collector instanceof TopDocsCollector) {
                        topDocsCollectors.add((TopDocsCollector)collector);
                        continue;
                    }
                    if (!(collector instanceof MaxScoreCollector)) continue;
                    maxScoreCollectors.add((MaxScoreCollector)collector);
                }
                float maxScore = Float.NaN;
                for (MaxScoreCollector collector : maxScoreCollectors) {
                    float score = collector.getMaxScore();
                    if (Float.isNaN(maxScore)) {
                        maxScore = score;
                        continue;
                    }
                    if (Float.isNaN(score)) continue;
                    maxScore = Math.max(maxScore, score);
                }
                TopDocs topDocs = this.manager.reduce(topDocsCollectors);
                return SimpleTopDocsCollectorContext.this.reduceWith(topDocs, maxScore, this.terminatedAfter);
            }
        }
    }
}

