/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.ConnectTransportException;
import org.opensearch.transport.TcpChannel;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportResponseHandler;

final class TransportHandshaker {
    static final String HANDSHAKE_ACTION_NAME = "internal:tcp/handshake";
    private final ConcurrentMap<Long, HandshakeResponseHandler> pendingHandshakes = new ConcurrentHashMap<Long, HandshakeResponseHandler>();
    private final CounterMetric numHandshakes = new CounterMetric();
    private final Version version;
    private final ThreadPool threadPool;
    private final HandshakeRequestSender handshakeRequestSender;
    static final Version V_3_0_0 = Version.fromId(137217827);

    TransportHandshaker(Version version, ThreadPool threadPool, HandshakeRequestSender handshakeRequestSender) {
        this.version = version;
        this.threadPool = threadPool;
        this.handshakeRequestSender = handshakeRequestSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendHandshake(long requestId, DiscoveryNode node, TcpChannel channel, TimeValue timeout, ActionListener<Version> listener) {
        block8: {
            this.numHandshakes.inc();
            HandshakeResponseHandler handler = new HandshakeResponseHandler(requestId, this.version, listener);
            this.pendingHandshakes.put(requestId, handler);
            channel.addCloseListener(ActionListener.wrap(() -> handler.handleLocalException(new TransportException("handshake failed because connection reset"))));
            boolean success = false;
            try {
                Version minCompatVersion = this.version.minimumCompatibilityVersion();
                if (this.version.onOrAfter(Version.V_1_0_0) && this.version.before(Version.V_2_0_0)) {
                    minCompatVersion = Version.fromId(0x5CC5FF);
                } else if (this.version.onOrAfter(Version.V_2_0_0)) {
                    minCompatVersion = Version.fromId(7099999);
                }
                this.handshakeRequestSender.sendRequest(node, channel, requestId, minCompatVersion);
                this.threadPool.schedule(() -> handler.handleLocalException(new ConnectTransportException(node, "handshake_timeout[" + String.valueOf(timeout) + "]")), timeout, "generic");
                success = true;
            }
            catch (Exception e) {
                handler.handleLocalException(new ConnectTransportException(node, "failure to send internal:tcp/handshake", e));
            }
            finally {
                if (success) break block8;
                TransportResponseHandler removed = (TransportResponseHandler)this.pendingHandshakes.remove(requestId);
                if ($assertionsDisabled || removed == null) break block8;
                throw new AssertionError((Object)"Handshake should not be pending if exception was thrown");
            }
        }
    }

    void handleHandshake(TransportChannel channel, long requestId, StreamInput stream) throws IOException {
        HandshakeRequest handshakeRequest = new HandshakeRequest(stream);
        int nextByte = stream.read();
        if (nextByte != -1) {
            throw new IllegalStateException("Handshake request not fully read for requestId [" + requestId + "], action [internal:tcp/handshake], available [" + stream.available() + "]; resetting");
        }
        if (this.version.onOrAfter(Version.V_1_0_0) && this.version.before(V_3_0_0) && (stream.getVersion().equals(LegacyESVersion.fromId(6080099)) || stream.getVersion().equals(Version.fromId(5060099)))) {
            channel.sendResponse(new HandshakeResponse(LegacyESVersion.V_7_10_2));
        } else {
            channel.sendResponse(new HandshakeResponse(this.version));
        }
    }

    TransportResponseHandler<HandshakeResponse> removeHandlerForHandshake(long requestId) {
        return (TransportResponseHandler)this.pendingHandshakes.remove(requestId);
    }

    int getNumPendingHandshakes() {
        return this.pendingHandshakes.size();
    }

    long getNumHandshakes() {
        return this.numHandshakes.count();
    }

    @FunctionalInterface
    static interface HandshakeRequestSender {
        public void sendRequest(DiscoveryNode var1, TcpChannel var2, long var3, Version var5) throws IOException;
    }

    private class HandshakeResponseHandler
    implements TransportResponseHandler<HandshakeResponse> {
        private final long requestId;
        private final Version currentVersion;
        private final ActionListener<Version> listener;
        private final AtomicBoolean isDone = new AtomicBoolean(false);

        private HandshakeResponseHandler(long requestId, Version currentVersion, ActionListener<Version> listener) {
            this.requestId = requestId;
            this.currentVersion = currentVersion;
            this.listener = listener;
        }

        @Override
        public HandshakeResponse read(StreamInput in) throws IOException {
            return new HandshakeResponse(in);
        }

        @Override
        public void handleResponse(HandshakeResponse response) {
            if (this.isDone.compareAndSet(false, true)) {
                Version version = response.responseVersion;
                if (!this.currentVersion.isCompatible(version)) {
                    this.listener.onFailure(new IllegalStateException("Received message from unsupported version: [" + String.valueOf(version) + "] minimal compatible version is: [" + String.valueOf(this.currentVersion.minimumCompatibilityVersion()) + "]"));
                } else {
                    this.listener.onResponse(version);
                }
            }
        }

        @Override
        public void handleException(TransportException e) {
            if (this.isDone.compareAndSet(false, true)) {
                this.listener.onFailure(new IllegalStateException("handshake failed", e));
            }
        }

        void handleLocalException(TransportException e) {
            if (TransportHandshaker.this.removeHandlerForHandshake(this.requestId) != null && this.isDone.compareAndSet(false, true)) {
                this.listener.onFailure(e);
            }
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    static final class HandshakeRequest
    extends TransportRequest {
        private final Version version;

        HandshakeRequest(Version version) {
            this.version = version;
        }

        HandshakeRequest(StreamInput streamInput) throws IOException {
            super(streamInput);
            BytesReference remainingMessage;
            try {
                remainingMessage = streamInput.readBytesReference();
            }
            catch (EOFException e) {
                remainingMessage = null;
            }
            if (remainingMessage == null) {
                this.version = null;
            } else {
                try (StreamInput messageStreamInput = remainingMessage.streamInput();){
                    this.version = messageStreamInput.readVersion();
                }
            }
        }

        @Override
        public void writeTo(StreamOutput streamOutput) throws IOException {
            super.writeTo(streamOutput);
            assert (this.version != null);
            try (BytesStreamOutput messageStreamOutput = new BytesStreamOutput(4);){
                messageStreamOutput.writeVersion(this.version);
                BytesReference reference = messageStreamOutput.bytes();
                streamOutput.writeBytesReference(reference);
            }
        }
    }

    static final class HandshakeResponse
    extends TransportResponse {
        private final Version responseVersion;

        HandshakeResponse(Version responseVersion) {
            this.responseVersion = responseVersion;
        }

        private HandshakeResponse(StreamInput in) throws IOException {
            super(in);
            this.responseVersion = in.readVersion();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            assert (this.responseVersion != null);
            out.writeVersion(this.responseVersion);
        }

        Version getResponseVersion() {
            return this.responseVersion;
        }
    }
}

