/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.tiering;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.master.AcknowledgedRequest;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

@ExperimentalApi
public class TieringIndexRequest
extends AcknowledgedRequest<TieringIndexRequest>
implements IndicesRequest.Replaceable {
    private String[] indices;
    private final Tier targetTier;
    private IndicesOptions indicesOptions;
    private boolean waitForCompletion;

    public TieringIndexRequest(String targetTier, String ... indices) {
        this.targetTier = Tier.fromString(targetTier);
        this.indices = indices;
        this.indicesOptions = IndicesOptions.fromOptions(false, false, true, false);
        this.waitForCompletion = false;
    }

    public TieringIndexRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.targetTier = Tier.fromString(in.readString());
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.waitForCompletion = in.readBoolean();
    }

    TieringIndexRequest(Tier targetTier, IndicesOptions indicesOptions, boolean waitForCompletion, String ... indices) {
        this.indices = indices;
        this.targetTier = targetTier;
        this.indicesOptions = indicesOptions;
        this.waitForCompletion = waitForCompletion;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indices == null) {
            validationException = ValidateActions.addValidationError("Mandatory parameter - indices is missing from the request", validationException);
        } else {
            for (String index : this.indices) {
                if (index != null && index.length() != 0) continue;
                validationException = ValidateActions.addValidationError(String.format(Locale.ROOT, "Specified index in the request [%s] is null or empty", index), validationException);
            }
        }
        if (!Tier.WARM.equals((Object)this.targetTier)) {
            validationException = ValidateActions.addValidationError("The specified tier is not supported", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        out.writeString(this.targetTier.value());
        this.indicesOptions.writeIndicesOptions(out);
        out.writeBoolean(this.waitForCompletion);
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    @Override
    public TieringIndexRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public TieringIndexRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public TieringIndexRequest waitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    public boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public Tier tier() {
        return this.targetTier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TieringIndexRequest that = (TieringIndexRequest)o;
        return this.clusterManagerNodeTimeout.equals((Object)that.clusterManagerNodeTimeout) && this.timeout.equals((Object)that.timeout) && Objects.equals(this.indicesOptions, that.indicesOptions) && Arrays.equals(this.indices, that.indices) && this.targetTier.equals((Object)that.targetTier) && this.waitForCompletion == that.waitForCompletion;
    }

    public int hashCode() {
        return Objects.hash(this.clusterManagerNodeTimeout, this.timeout, this.indicesOptions, this.waitForCompletion, Arrays.hashCode(this.indices));
    }

    @ExperimentalApi
    public static enum Tier {
        HOT,
        WARM;


        public static Tier fromString(String name) {
            String upperCase;
            if (name == null) {
                throw new IllegalArgumentException("Tiering type cannot be null");
            }
            switch (upperCase = name.trim().toUpperCase(Locale.ROOT)) {
                case "HOT": {
                    return HOT;
                }
                case "WARM": {
                    return WARM;
                }
            }
            throw new IllegalArgumentException("Tiering type [" + name + "] is not supported. Supported types are " + String.valueOf((Object)HOT) + " and " + String.valueOf((Object)WARM));
        }

        public String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

