/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.util.FixedBitSet;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.index.codec.composite.CompositeIndexFieldInfo;
import org.opensearch.index.codec.composite.CompositeIndexReader;
import org.opensearch.index.compositeindex.datacube.Dimension;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.utils.StarTreeUtils;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.SortedNumericStarTreeValuesIterator;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.StarTreeBucketCollector;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.startree.StarTreeQueryContext;
import org.opensearch.search.startree.StarTreeTraversalUtil;
import org.opensearch.search.startree.filter.DimensionFilter;
import org.opensearch.search.startree.filter.StarTreeFilter;

public class StarTreeQueryHelper {
    private static StarTreeValues starTreeValues;

    public static boolean isStarTreeSupported(SearchContext context) {
        return context.aggregations() != null && context.mapperService().isCompositeIndexPresent() && context.parsedPostFilter() == null;
    }

    public static CompositeIndexFieldInfo getSupportedStarTree(QueryShardContext context) {
        StarTreeQueryContext starTreeQueryContext = context.getStarTreeQueryContext();
        return starTreeQueryContext != null ? starTreeQueryContext.getStarTree() : null;
    }

    public static StarTreeValues getStarTreeValues(LeafReaderContext context, CompositeIndexFieldInfo starTree) throws IOException {
        SegmentReader reader = Lucene.segmentReader(context.reader());
        if (!(reader.getDocValuesReader() instanceof CompositeIndexReader)) {
            return null;
        }
        CompositeIndexReader starTreeDocValuesReader = (CompositeIndexReader)reader.getDocValuesReader();
        return (StarTreeValues)starTreeDocValuesReader.getCompositeIndexValues(starTree);
    }

    public static void precomputeLeafUsingStarTree(SearchContext context, ValuesSource.Numeric valuesSource, LeafReaderContext ctx, CompositeIndexFieldInfo starTree, String metric, Consumer<Long> valueConsumer, Runnable finalConsumer) throws IOException {
        StarTreeValues starTreeValues = StarTreeQueryHelper.getStarTreeValues(ctx, starTree);
        assert (starTreeValues != null);
        String fieldName = ((ValuesSource.Numeric.FieldData)valuesSource).getIndexFieldName();
        String metricName = StarTreeUtils.fullyQualifiedFieldNameForStarTreeMetricsDocValues(starTree.getField(), fieldName, metric);
        SortedNumericStarTreeValuesIterator valuesIterator = (SortedNumericStarTreeValuesIterator)starTreeValues.getMetricValuesIterator(metricName);
        FixedBitSet filteredValues = StarTreeQueryHelper.getStarTreeFilteredValues(context, ctx, starTreeValues);
        int numBits = filteredValues.length();
        if (numBits > 0) {
            int bit = filteredValues.nextSetBit(0);
            while (bit != Integer.MAX_VALUE) {
                if (valuesIterator.advanceExact(bit)) {
                    int count = valuesIterator.entryValueCount();
                    for (int i = 0; i < count; ++i) {
                        long value = valuesIterator.nextValue();
                        valueConsumer.accept(value);
                    }
                }
                bit = bit + 1 < numBits ? filteredValues.nextSetBit(bit + 1) : Integer.MAX_VALUE;
            }
        }
        finalConsumer.run();
    }

    public static FixedBitSet getStarTreeFilteredValues(SearchContext context, LeafReaderContext ctx, StarTreeValues starTreeValues) throws IOException {
        FixedBitSet result = context.getQueryShardContext().getStarTreeQueryContext().maybeGetCachedNodeIdsForSegment(ctx.ord);
        if (result == null) {
            result = StarTreeTraversalUtil.getStarTreeResult(starTreeValues, context.getQueryShardContext().getStarTreeQueryContext().getBaseQueryStarTreeFilter(), context);
        }
        context.getQueryShardContext().getStarTreeQueryContext().maybeSetCachedNodeIdsForSegment(ctx.ord, result);
        return result;
    }

    public static Dimension getMatchingDimensionOrThrow(String dimensionName, List<Dimension> orderedDimensions) {
        Dimension matchingDimension = StarTreeQueryHelper.getMatchingDimensionOrNull(dimensionName, orderedDimensions);
        if (matchingDimension == null) {
            throw new IllegalStateException("No matching dimension found for [" + dimensionName + "]");
        }
        return matchingDimension;
    }

    public static Dimension getMatchingDimensionOrNull(String dimensionName, List<Dimension> orderedDimensions) {
        List matchingDimensions = orderedDimensions.stream().filter(x -> x.getField().equals(dimensionName)).collect(Collectors.toList());
        if (matchingDimensions.size() != 1) {
            return null;
        }
        return (Dimension)matchingDimensions.get(0);
    }

    public static StarTreeBucketCollector getStarTreeBucketMetricCollector(final CompositeIndexFieldInfo starTree, final String metric, final ValuesSource.Numeric valuesSource, StarTreeBucketCollector parentCollector, final Consumer<Long> growArrays, final BiConsumer<Long, Long> updateBucket) throws IOException {
        assert (parentCollector != null);
        return new StarTreeBucketCollector(parentCollector){
            String metricName;
            SortedNumericStarTreeValuesIterator metricValuesIterator;
            {
                super(parent);
                this.metricName = StarTreeUtils.fullyQualifiedFieldNameForStarTreeMetricsDocValues(starTree.getField(), ((ValuesSource.Numeric.FieldData)valuesSource).getIndexFieldName(), metric);
                this.metricValuesIterator = (SortedNumericStarTreeValuesIterator)this.starTreeValues.getMetricValuesIterator(this.metricName);
            }

            @Override
            public void collectStarTreeEntry(int starTreeEntryBit, long bucket) throws IOException {
                growArrays.accept(bucket);
                if (!this.metricValuesIterator.advanceExact(starTreeEntryBit)) {
                    return;
                }
                long metricValue = this.metricValuesIterator.nextValue();
                updateBucket.accept(bucket, metricValue);
            }
        };
    }

    public static StarTreeFilter mergeDimensionFilterIfNotExists(StarTreeFilter baseStarTreeFilter, String dimensionToMerge, List<DimensionFilter> dimensionFiltersToMerge) {
        HashMap<String, List<DimensionFilter>> dimensionFilterMap = new HashMap<String, List<DimensionFilter>>(baseStarTreeFilter.getDimensions().size());
        for (String baseDimension : baseStarTreeFilter.getDimensions()) {
            dimensionFilterMap.put(baseDimension, baseStarTreeFilter.getFiltersForDimension(baseDimension));
        }
        if (!dimensionFilterMap.containsKey(dimensionToMerge)) {
            dimensionFilterMap.put(dimensionToMerge, dimensionFiltersToMerge);
        }
        return new StarTreeFilter(dimensionFilterMap);
    }
}

