/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.rest.action.servers;

import de.virtimo.bpc.opensearch.plugin.BpcConnection;
import de.virtimo.bpc.opensearch.plugin.Manager;
import de.virtimo.bpc.opensearch.plugin.dto.ConnectedServerDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ConnectedServersDTO;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.rest.action.BaseBpcPluginRestHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.logging.Loggers;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;

public class RestGetConnectedServersAction
extends BaseBpcPluginRestHandler {
    private static final Logger LOG = Loggers.getLogger(RestGetConnectedServersAction.class, (String[])new String[]{"os-bpc-plugin"});

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_bpc/servers"));
    }

    public String getName() {
        return "get_connected_servers_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient, Manager manager) throws IOException {
        LOG.debug("prepareRequest request=" + request + ", nodeClient=" + nodeClient + ", manager=" + manager);
        return channel -> {
            ArrayList<ConnectedServerDTO> servers = new ArrayList<ConnectedServerDTO>();
            for (BpcConnection bpcConnection : manager.getConnections().getAll()) {
                servers.add(new ConnectedServerDTO(bpcConnection.getConnectedNode(), bpcConnection.getWebsocketId(), bpcConnection.getServerStateInfo(), bpcConnection.getServerLoadedModules()));
            }
            ConnectedServersDTO connectedServers = new ConnectedServersDTO(servers);
            this.sendDTO((RestChannel)channel, (OpenSearchPluginDTO)connectedServers);
        };
    }
}

