/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.forms;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.Error;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaRegistry;
import com.networknt.schema.dialect.Dialect;
import com.networknt.schema.dialect.Dialects;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.module.forms.Form;
import de.virtimo.bpc.module.forms.Module;
import java.util.List;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;

public class FormValidator {
    private static final Logger LOG = Logger.getLogger(FormValidator.class.getName());
    private final Schema jsonSchema;
    private final ObjectMapper mapper = new ObjectMapper();

    public FormValidator() {
        this(Module.getInstance().getModuleBundle());
    }

    public FormValidator(Bundle bundle) {
        this(bundle, "formConfig-1.json");
    }

    public FormValidator(Bundle bundle, String fileName) {
        this(JsonDefaultsUtil.loadJsonFileAsString((Bundle)bundle, (String)fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormValidator(String jsonSchemaAsString) {
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(SchemaRegistry.class.getClassLoader());
            SchemaRegistry schemaRegistry = SchemaRegistry.withDefaultDialect((Dialect)Dialects.getDraft202012());
            this.jsonSchema = schemaRegistry.getSchema(jsonSchemaAsString);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
        }
    }

    public List<Error> validate(Form form) {
        LOG.finest("validate");
        List validationErrors = this.jsonSchema.validate(this.mapper.valueToTree(form.getConfig()));
        if (!validationErrors.isEmpty()) {
            LOG.warning("found " + validationErrors.size() + " validation errors");
        }
        return validationErrors;
    }
}

