/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;

public class TimestampUtil {
    private static final Logger LOG = Loggers.getLogger(TimestampUtil.class, (String[])new String[]{"os-bpc-plugin"});

    public static Instant nowInUtc() {
        return Instant.now();
    }

    public static String formatAsIsoInstantString(Instant utcTimestamp) {
        return utcTimestamp == null ? null : DateTimeFormatter.ISO_INSTANT.format(utcTimestamp);
    }

    public static LocalDateTime asLocalDateTime(Instant utcTimestamp) {
        return LocalDateTime.ofInstant(utcTimestamp, ZoneId.systemDefault());
    }

    public static Instant parseAsInstant(String isoInstantFormattedUtcTimestamp) {
        return Instant.parse(isoInstantFormattedUtcTimestamp);
    }
}

