/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.osgi.registry;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.geronimo.osgi.registry.Activator;
import org.apache.geronimo.osgi.registry.api.ProviderRegistry;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderRegistryImpl
implements ProviderRegistry {
    public static final String OPT_IN_HEADER = "SPI-Provider";
    public static final String EXPORT_PROVIDER_HEADER = "Export-SPI-Provider";
    private SPIRegistry providers = new SPIRegistry();
    private SPIRegistry serviceProviders = new SPIRegistry();
    private Activator activator;

    public ProviderRegistryImpl(Activator activator) {
        this.activator = activator;
    }

    public Object addBundle(Bundle bundle) {
        this.log(4, "adding bundle " + bundle);
        BundleResources tracker = new BundleResources(bundle);
        return tracker.needsTracking() ? tracker : null;
    }

    public void removeBundle(Bundle bundle, Object obj) {
        this.log(4, "removing bundle " + bundle);
        BundleResources tracker = (BundleResources)obj;
        if (tracker != null) {
            tracker.remove();
        }
    }

    protected void registerProvider(BundleProviderLoader provider) {
        this.log(4, "registering provider " + provider);
        this.providers.register(provider);
    }

    protected void unregisterProvider(BundleProviderLoader provider) {
        this.log(4, "unregistering provider " + provider);
        this.providers.unregister(provider);
    }

    protected void registerService(BundleProviderLoader provider) {
        this.log(4, "registering service " + provider);
        this.serviceProviders.register(provider);
    }

    protected void unregisterService(BundleProviderLoader provider) {
        this.log(4, "unregistering service " + provider);
        this.serviceProviders.unregister(provider);
    }

    @Override
    public Class<?> locate(String providerId) {
        BundleProviderLoader loader = this.providers.getLoader(providerId);
        if (loader != null) {
            try {
                return loader.loadClass();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public List<Class<?>> locateAll(String providerId) {
        ArrayList classes = new ArrayList();
        List l = this.providers.getLoaders(providerId);
        if (l != null) {
            for (BundleProviderLoader c : l) {
                try {
                    classes.add(c.loadClass());
                }
                catch (Exception e) {}
            }
        }
        return classes;
    }

    @Override
    public Object getService(String providerId) throws Exception {
        List loaders = this.serviceProviders.getLoaders(providerId);
        if (loaders == null || loaders.size() == 0) {
            return null;
        }
        String preferenceProviderClassName = System.getProperty(providerId);
        if (preferenceProviderClassName != null) {
            for (BundleProviderLoader loader : loaders) {
                if (!loader.providerClass.equals(preferenceProviderClassName)) continue;
                return loader.createInstance();
            }
        }
        return ((BundleProviderLoader)loaders.get(0)).createInstance();
    }

    @Override
    public List<Object> getServices(String providerId) {
        ArrayList<Object> instances = new ArrayList<Object>();
        List l = this.serviceProviders.getLoaders(providerId);
        if (l != null) {
            for (BundleProviderLoader c : l) {
                try {
                    instances.add(c.createInstance());
                }
                catch (Exception e) {}
            }
        }
        return instances;
    }

    @Override
    public List<Class<?>> getServiceClasses(String providerId) {
        ArrayList classes = new ArrayList();
        List l = this.serviceProviders.getLoaders(providerId);
        if (l != null) {
            for (BundleProviderLoader c : l) {
                try {
                    classes.add(c.loadClass());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return classes;
    }

    @Override
    public Class<?> getServiceClass(String providerId) throws ClassNotFoundException {
        List loaders = this.serviceProviders.getLoaders(providerId);
        if (loaders == null || loaders.size() == 0) {
            return null;
        }
        String preferenceProviderClassName = System.getProperty(providerId);
        if (preferenceProviderClassName != null) {
            for (BundleProviderLoader loader : loaders) {
                if (!loader.providerClass.equals(preferenceProviderClassName)) continue;
                return loader.loadClass();
            }
        }
        return ((BundleProviderLoader)loaders.get(0)).loadClass();
    }

    private void log(int level, String message) {
        this.activator.log(level, message);
    }

    private void log(int level, String message, Throwable th) {
        this.activator.log(level, message, th);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BundleProviderLoader {
        private final String providerId;
        private final String providerClass;
        private final Bundle bundle;

        public BundleProviderLoader(String providerId, String providerClass, Bundle bundle) {
            this.providerId = providerId;
            this.providerClass = providerClass;
            this.bundle = bundle;
        }

        public Class<?> loadClass() throws ClassNotFoundException {
            try {
                ProviderRegistryImpl.this.log(4, "loading class for: " + this);
                return this.bundle.loadClass(this.providerClass);
            }
            catch (ClassNotFoundException e) {
                ProviderRegistryImpl.this.log(4, "exception caught while loading " + this, e);
                throw e;
            }
        }

        public Object createInstance() throws Exception {
            Class<?> cls = this.loadClass();
            try {
                return cls.newInstance();
            }
            catch (Exception e) {
                ProviderRegistryImpl.this.log(4, "exception caught while creating " + this, e);
                throw e;
            }
            catch (Error e) {
                ProviderRegistryImpl.this.log(4, "error caught while creating " + this, e);
                throw e;
            }
        }

        public String id() {
            return this.providerId;
        }

        public String toString() {
            return "Provider interface=" + this.providerId + " , provider class=" + this.providerClass + ", bundle=" + this.bundle;
        }

        public int hashCode() {
            return this.providerId.hashCode() + this.providerClass.hashCode() + (int)this.bundle.getBundleId();
        }

        public boolean equals(Object obj) {
            if (obj instanceof BundleProviderLoader) {
                return this.providerId.equals(((BundleProviderLoader)obj).providerId) && this.providerClass.equals(((BundleProviderLoader)obj).providerClass) && this.bundle.getBundleId() == ((BundleProviderLoader)obj).bundle.getBundleId();
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SPIRegistry {
        private Map<String, List<BundleProviderLoader>> registry;

        private SPIRegistry() {
        }

        public synchronized void register(BundleProviderLoader provider) {
            String providerId;
            List<BundleProviderLoader> l;
            if (this.registry == null) {
                this.registry = new HashMap<String, List<BundleProviderLoader>>();
            }
            if ((l = this.registry.get(providerId = provider.id())) == null) {
                l = new ArrayList<BundleProviderLoader>();
                this.registry.put(providerId, l);
            }
            l.add(provider);
        }

        public synchronized void unregister(BundleProviderLoader provider) {
            List<BundleProviderLoader> l;
            if (this.registry != null && (l = this.registry.get(provider.id())) != null) {
                l.remove(provider);
            }
        }

        private synchronized BundleProviderLoader getLoader(String id) {
            List<BundleProviderLoader> list;
            if (this.registry != null && (list = this.registry.get(id)) != null && !list.isEmpty()) {
                return list.get(0);
            }
            return null;
        }

        private synchronized List<BundleProviderLoader> getLoaders(String id) {
            List<BundleProviderLoader> list;
            if (this.registry != null && (list = this.registry.get(id)) != null && !list.isEmpty()) {
                return new ArrayList<BundleProviderLoader>(list);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BundleResources {
        private Bundle bundle;
        private List<BundleProviderLoader> serviceProviders;
        private List<BundleProviderLoader> providers;

        public BundleResources(Bundle b) {
            this.bundle = b;
            this.locateProviders();
            this.locateServices();
        }

        public boolean needsTracking() {
            return this.serviceProviders != null || this.providers != null;
        }

        private void locateProviders() {
            List<BundleProviderLoader> directoryProviders;
            LinkedHashSet<BundleProviderLoader> locatedProviders = new LinkedHashSet<BundleProviderLoader>();
            List<BundleProviderLoader> headerProviders = this.locateHeaderProviderDefinitions();
            if (headerProviders != null) {
                locatedProviders.addAll(headerProviders);
            }
            if ((directoryProviders = this.processDefinitions("OSGI-INF/providers/")) != null) {
                locatedProviders.addAll(directoryProviders);
            }
            if (!locatedProviders.isEmpty()) {
                for (BundleProviderLoader loader : locatedProviders) {
                    ProviderRegistryImpl.this.registerProvider(loader);
                }
                this.providers = new ArrayList<BundleProviderLoader>(locatedProviders);
            }
        }

        private List<BundleProviderLoader> locateHeaderProviderDefinitions() {
            String[] classNames;
            String exportedProviders = (String)this.bundle.getHeaders().get(ProviderRegistryImpl.EXPORT_PROVIDER_HEADER);
            if (exportedProviders == null) {
                return null;
            }
            ArrayList<BundleProviderLoader> providers = new ArrayList<BundleProviderLoader>();
            for (String name : classNames = exportedProviders.split(",")) {
                name = name.trim();
                providers.add(new BundleProviderLoader(name, name, this.bundle));
            }
            return providers;
        }

        private void locateServices() {
            if (this.bundle.getHeaders().get(ProviderRegistryImpl.OPT_IN_HEADER) == null) {
                return;
            }
            ProviderRegistryImpl.this.log(3, "SPI-Provider Manifest header found in bundle: " + this.bundle.getSymbolicName());
            this.serviceProviders = this.processDefinitions("META-INF/services/");
            if (this.serviceProviders != null) {
                for (BundleProviderLoader loader : this.serviceProviders) {
                    ProviderRegistryImpl.this.registerService(loader);
                }
            }
        }

        public void remove() {
            ProviderRegistryImpl.this.log(4, "removing bundle " + this.bundle);
            if (this.providers != null) {
                for (BundleProviderLoader loader : this.providers) {
                    ProviderRegistryImpl.this.unregisterProvider(loader);
                }
            }
            if (this.serviceProviders != null) {
                for (BundleProviderLoader loader : this.serviceProviders) {
                    ProviderRegistryImpl.this.unregisterService(loader);
                }
            }
        }

        private List<BundleProviderLoader> processDefinitions(String path) {
            ArrayList<BundleProviderLoader> mappings = new ArrayList<BundleProviderLoader>();
            Enumeration e = this.bundle.findEntries(path, "*", false);
            if (e != null) {
                while (e.hasMoreElements()) {
                    URL u = (URL)e.nextElement();
                    this.parseServiceFile(u, mappings);
                }
            }
            return mappings.isEmpty() ? null : mappings;
        }

        private void parseServiceFile(URL u, List<BundleProviderLoader> mappings) {
            String url = u.toString();
            if (url.endsWith("/")) {
                return;
            }
            String providerId = url.substring(url.lastIndexOf("/") + 1);
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(u.openStream(), "UTF-8"));
                String line = br.readLine();
                while (line != null) {
                    int comment = line.indexOf(35);
                    if (comment != -1) {
                        line = line.substring(0, comment);
                    }
                    if ((line = line.trim()).length() > 0) {
                        mappings.add(new BundleProviderLoader(providerId, line, this.bundle));
                    }
                    line = br.readLine();
                }
                br.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

