/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jdbc.command.ds;

import java.util.Map;
import org.apache.karaf.jdbc.command.JdbcCommandSupport;
import org.apache.karaf.jdbc.command.completers.DataSourcesNameCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="jdbc", name="ds-info", description="Display details about a JDBC datasource")
@Service
public class InfoCommand
extends JdbcCommandSupport {
    @Argument(index=0, name="datasource", description="The JDBC datasource name, its JNDI name or service.id", required=true, multiValued=false)
    @Completion(value=DataSourcesNameCompleter.class)
    String datasource;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("Property");
        table.column("Value");
        Map<String, String> info = this.getJdbcService().info(this.datasource);
        for (String property : info.keySet()) {
            table.addRow().addContent(new Object[]{property, info.get(property)});
        }
        table.print(System.out);
        return null;
    }
}

