/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jdbc.internal;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.karaf.jdbc.JdbcService;
import org.apache.karaf.jdbc.internal.JdbcConnector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcServiceImpl
implements JdbcService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcServiceImpl.class);
    private BundleContext bundleContext;
    private ConfigurationAdmin configAdmin;

    @Override
    public void create(String name, String driverName, String driverClass, String databaseName, String url, String user, String password, String databaseType) throws Exception {
        if (driverName == null && driverClass == null) {
            throw new IllegalStateException("No driverName or driverClass supplied");
        }
        if (this.datasources().contains(name)) {
            throw new IllegalArgumentException("There is already a DataSource with the name " + name);
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("dataSourceName", name);
        this.put(properties, "osgi.jdbc.driver.name", driverName);
        this.put(properties, "osgi.jdbc.driver.class", driverClass);
        this.put(properties, "databaseName", databaseName);
        this.put(properties, "url", url);
        this.put(properties, "user", user);
        this.put(properties, "password", password);
        this.put(properties, "dataSourceType", databaseType);
        Configuration config = this.configAdmin.createFactoryConfiguration("org.ops4j.datasource", null);
        config.update(properties);
    }

    private void put(Dictionary<String, String> properties, String key, String value) {
        if (value != null) {
            properties.put(key, value);
        }
    }

    @Override
    public void delete(String name) throws Exception {
        Configuration[] configs;
        String filter = String.format("(&(service.factoryPid=org.ops4j.datasource)(%s=%s))", "dataSourceName", name);
        for (Configuration config : configs = this.configAdmin.listConfigurations(filter)) {
            config.delete();
        }
    }

    @Override
    public List<String> datasources() throws Exception {
        ArrayList<String> datasources = new ArrayList<String>();
        ServiceReference[] references = this.bundleContext.getServiceReferences((String)null, "(|(objectClass=" + DataSource.class.getName() + ")(objectClass=" + XADataSource.class.getName() + "))");
        if (references != null) {
            for (ServiceReference reference : references) {
                if (reference.getProperty("osgi.jndi.service.name") != null) {
                    datasources.add(reference.getProperty("osgi.jndi.service.name").toString());
                    continue;
                }
                if (reference.getProperty("datasource") != null) {
                    datasources.add(reference.getProperty("datasource").toString());
                    continue;
                }
                if (reference.getProperty("name") != null) {
                    datasources.add(reference.getProperty("name").toString());
                    continue;
                }
                if (reference.getProperty("dataSourceName") != null) {
                    datasources.add(reference.getProperty("dataSourceName").toString());
                    continue;
                }
                datasources.add(reference.getProperty("service.id").toString());
            }
        }
        return datasources;
    }

    @Override
    public List<Long> datasourceServiceIds() throws Exception {
        ArrayList<Long> datasources = new ArrayList<Long>();
        ServiceReference[] references = this.bundleContext.getServiceReferences((String)null, "(|(objectClass=" + DataSource.class.getName() + ")(objectClass=" + XADataSource.class.getName() + "))");
        if (references != null) {
            for (ServiceReference reference : references) {
                datasources.add((Long)reference.getProperty("service.id"));
            }
        }
        return datasources;
    }

    @Override
    public Map<String, List<String>> query(String datasource, String query) throws Exception {
        try (JdbcConnector jdbcConnector = new JdbcConnector(this.bundleContext, this.lookupDataSource(datasource));){
            int c;
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            Statement statement = jdbcConnector.createStatement();
            ResultSet resultSet = jdbcConnector.register(statement.executeQuery(query));
            ResultSetMetaData metaData = resultSet.getMetaData();
            for (c = 1; c <= metaData.getColumnCount(); ++c) {
                map.put(metaData.getColumnLabel(c), new ArrayList());
            }
            while (resultSet.next()) {
                for (c = 1; c <= metaData.getColumnCount(); ++c) {
                    ((List)map.get(metaData.getColumnLabel(c))).add(resultSet.getString(c));
                }
            }
            HashMap<String, List<String>> hashMap = map;
            return hashMap;
        }
    }

    @Override
    public void execute(String datasource, String command) throws Exception {
        try (JdbcConnector jdbcConnector = new JdbcConnector(this.bundleContext, this.lookupDataSource(datasource));){
            jdbcConnector.createStatement().execute(command);
        }
    }

    @Override
    public Map<String, List<String>> tables(String datasource) throws Exception {
        try (JdbcConnector jdbcConnector = new JdbcConnector(this.bundleContext, this.lookupDataSource(datasource));){
            int c;
            DatabaseMetaData dbMetaData = jdbcConnector.connect().getMetaData();
            ResultSet resultSet = jdbcConnector.register(dbMetaData.getTables(null, null, null, null));
            ResultSetMetaData metaData = resultSet.getMetaData();
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            for (c = 1; c <= metaData.getColumnCount(); ++c) {
                map.put(metaData.getColumnLabel(c), new ArrayList());
            }
            while (resultSet.next()) {
                for (c = 1; c <= metaData.getColumnCount(); ++c) {
                    ((List)map.get(metaData.getColumnLabel(c))).add(resultSet.getString(c));
                }
            }
            HashMap<String, List<String>> hashMap = map;
            return hashMap;
        }
    }

    @Override
    public Map<String, String> info(String datasource) throws Exception {
        ServiceReference<?> reference = this.lookupDataSource(datasource);
        String dsName = datasource;
        if (reference.getProperty("osgi.jndi.service.name") != null) {
            dsName = (String)reference.getProperty("osgi.jndi.service.name");
        } else if (reference.getProperty("datasource") != null) {
            dsName = (String)reference.getProperty("datasource");
        } else if (reference.getProperty("name") != null) {
            dsName = (String)reference.getProperty("name");
        }
        JdbcConnector jdbcConnector = new JdbcConnector(this.bundleContext, reference);
        try {
            DatabaseMetaData dbMetaData = jdbcConnector.connect().getMetaData();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", dsName);
            map.put("service.id", reference.getProperty("service.id").toString());
            map.put("db.product", dbMetaData.getDatabaseProductName());
            map.put("db.version", dbMetaData.getDatabaseProductVersion());
            map.put("url", dbMetaData.getURL());
            map.put("username", dbMetaData.getUserName());
            map.put("driver.name", dbMetaData.getDriverName());
            map.put("driver.version", dbMetaData.getDriverVersion());
            HashMap<String, String> hashMap = map;
            jdbcConnector.close();
            return hashMap;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jdbcConnector.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Can't get information about datasource {}", (Object)datasource, (Object)e);
                throw e;
            }
        }
    }

    private ServiceReference<?> lookupDataSource(String name) {
        Object[] references;
        try {
            references = this.bundleContext.getServiceReferences((String)null, "(&(|(objectClass=" + DataSource.class.getName() + ")(objectClass=" + XADataSource.class.getName() + "))(|(osgi.jndi.service.name=" + name + ")(datasource=" + name + ")(name=" + name + ")(service.id=" + name + ")))");
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Error finding datasource with name " + name, e);
        }
        if (references == null || references.length == 0) {
            throw new IllegalArgumentException("No JDBC datasource found for " + name);
        }
        if (references.length > 1) {
            Arrays.sort(references);
            if (this.getRank((ServiceReference<?>)references[references.length - 1]) == this.getRank((ServiceReference<?>)references[references.length - 2])) {
                LOGGER.warn("Multiple JDBC datasources found with the same service ranking for " + name);
            }
        }
        return references[references.length - 1];
    }

    private int getRank(ServiceReference<?> reference) {
        Object rankObj = reference.getProperty("service.ranking");
        rankObj = rankObj == null ? Integer.valueOf(0) : rankObj;
        return rankObj instanceof Integer ? (Integer)rankObj : 0;
    }

    @Override
    public List<String> factoryNames() throws Exception {
        ArrayList<String> factories = new ArrayList<String>();
        Collection references = this.bundleContext.getServiceReferences(DataSourceFactory.class, null);
        if (references == null) {
            return factories;
        }
        for (ServiceReference reference : references) {
            String driverName = (String)reference.getProperty("osgi.jdbc.driver.name");
            if (driverName == null) continue;
            factories.add(driverName);
        }
        return factories;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }
}

