/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.decanter.marshaller.json;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.apache.karaf.decanter.api.marshaller.Marshaller;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;

@Component(name="org.apache.karaf.decanter.marshaller.json", immediate=true, property={"dataFormat=json"})
public class JsonMarshaller
implements Marshaller {
    private static final String TIMESTAMP_FORMAT_PROPERTY = "timestamp.format";
    private static final String TIMESTAMP_ZONE_PROPERTY = "timestamp.zone";
    boolean replaceDotsByUnderscores = true;
    private DateTimeFormatter timestampFormatter = DateTimeFormatter.ISO_DATE_TIME;
    private ZoneId timestampZoneId = ZoneId.of("UTC");

    @Activate
    public void activate(ComponentContext componentContext) {
        this.activate(componentContext.getProperties());
    }

    public void activate(Dictionary<String, Object> config) {
        if (config.get(TIMESTAMP_FORMAT_PROPERTY) != null) {
            String timestampFormatterProp = (String)config.get(TIMESTAMP_FORMAT_PROPERTY);
            this.timestampFormatter = timestampFormatterProp.equalsIgnoreCase("ISO_DATE_TIME") ? DateTimeFormatter.ISO_DATE_TIME : (timestampFormatterProp.equalsIgnoreCase("BASIC_ISO_DATE") ? DateTimeFormatter.BASIC_ISO_DATE : (timestampFormatterProp.equalsIgnoreCase("ISO_LOCAL_DATE") ? DateTimeFormatter.ISO_LOCAL_DATE : (timestampFormatterProp.equalsIgnoreCase("ISO_OFFSET_DATE") ? DateTimeFormatter.ISO_OFFSET_DATE : (timestampFormatterProp.equalsIgnoreCase("ISO_DATE") ? DateTimeFormatter.ISO_DATE : (timestampFormatterProp.equalsIgnoreCase("ISO_LOCAL_TIME") ? DateTimeFormatter.ISO_LOCAL_TIME : (timestampFormatterProp.equalsIgnoreCase("ISO_OFFSET_TIME") ? DateTimeFormatter.ISO_OFFSET_TIME : (timestampFormatterProp.equalsIgnoreCase("ISO_TIME") ? DateTimeFormatter.ISO_TIME : (timestampFormatterProp.equalsIgnoreCase("ISO_LOCAL_DATE_TIME") ? DateTimeFormatter.ISO_LOCAL_DATE_TIME : (timestampFormatterProp.equalsIgnoreCase("ISO_OFFSET_DATE_TIME") ? DateTimeFormatter.ISO_OFFSET_DATE_TIME : (timestampFormatterProp.equalsIgnoreCase("ISO_ZONED_DATE_TIME") ? DateTimeFormatter.ISO_ZONED_DATE_TIME : (timestampFormatterProp.equalsIgnoreCase("ISO_ORDINAL_DATE") ? DateTimeFormatter.ISO_ORDINAL_DATE : (timestampFormatterProp.equalsIgnoreCase("ISO_WEEK_DATE") ? DateTimeFormatter.ISO_WEEK_DATE : (timestampFormatterProp.equalsIgnoreCase("ISO_INSTANT") ? DateTimeFormatter.ISO_INSTANT : (timestampFormatterProp.equalsIgnoreCase("RFC_1123_DATE_TIME") ? DateTimeFormatter.RFC_1123_DATE_TIME : DateTimeFormatter.ofPattern(timestampFormatterProp)))))))))))))));
        }
        if (config.get(TIMESTAMP_ZONE_PROPERTY) != null) {
            this.timestampZoneId = ZoneId.of((String)config.get(TIMESTAMP_ZONE_PROPERTY), ZoneId.SHORT_IDS);
        }
        this.replaceDotsByUnderscores = config.get("replaceDotsByUnderscores") != null ? Boolean.valueOf((String)config.get("replaceDotsByUnderscores")) : true;
    }

    public void marshal(Object obj, OutputStream out) {
        JsonObject jsonObj = this.marshal((Event)obj);
        JsonWriter writer = Json.createWriter((OutputStream)out);
        writer.writeObject(jsonObj);
        writer.close();
    }

    public String marshal(Object obj) {
        return this.marshal((Event)obj).toString();
    }

    private JsonObject marshal(Event event) {
        JsonObjectBuilder json = Json.createObjectBuilder();
        this.addTimestamp(event, json);
        for (String key : event.getPropertyNames()) {
            Object value = event.getProperty(key);
            key = this.replaceDotsByUnderscores ? key.replace('.', '_') : key;
            this.marshalAttribute(json, key, value);
        }
        return json.build();
    }

    private void addTimestamp(Event event, JsonObjectBuilder json) {
        Long timestamp = (Long)event.getProperty("timestamp");
        LocalDateTime date = timestamp != null ? LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), this.timestampZoneId) : LocalDateTime.now();
        json.add("@timestamp", date.format(this.timestampFormatter));
    }

    private void marshalAttribute(JsonObjectBuilder jsonObjectBuilder, String key, Object value) {
        String string = key = this.replaceDotsByUnderscores ? key.replace('.', '_') : key;
        if (value instanceof Map) {
            jsonObjectBuilder.add(key, (JsonValue)this.build((Map)value));
        } else if (value instanceof List) {
            jsonObjectBuilder.add(key, (JsonValue)this.build((List)value));
        } else if (value instanceof long[] || value instanceof Long[]) {
            long[] array;
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (long l : array = (long[])value) {
                arrayBuilder.add(l);
            }
            jsonObjectBuilder.add(key, (JsonValue)arrayBuilder.build());
        } else if (value instanceof int[] || value instanceof Integer[]) {
            int[] array;
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (int i : array = (int[])value) {
                arrayBuilder.add(i);
            }
            jsonObjectBuilder.add(key, (JsonValue)arrayBuilder.build());
        } else if (value instanceof String[]) {
            String[] array;
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (String s : array = (String[])value) {
                arrayBuilder.add(s);
            }
            jsonObjectBuilder.add(key, (JsonValue)arrayBuilder.build());
        } else if (value instanceof Object[]) {
            Object[] array;
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (Object o : array = (Object[])value) {
                if (o == null) continue;
                arrayBuilder.add(o.toString());
            }
            jsonObjectBuilder.add(key, (JsonValue)arrayBuilder.build());
        } else {
            this.addProperty(jsonObjectBuilder, key, value);
        }
    }

    private JsonObject build(Map<String, Object> value) {
        JsonObjectBuilder json = Json.createObjectBuilder();
        for (Map.Entry<String, Object> entries : value.entrySet()) {
            this.addProperty(json, this.replaceDotsByUnderscores ? entries.getKey().replace('.', '_') : entries.getKey(), entries.getValue());
        }
        return json.build();
    }

    private JsonArray build(List<?> values) {
        JsonArrayBuilder json = Json.createArrayBuilder();
        for (Object value : values) {
            this.addValue(json, value);
        }
        return json.build();
    }

    private void addValue(JsonArrayBuilder json, Object value) {
        if (value instanceof Map) {
            json.add((JsonValue)this.build((Map)value));
        } else if (value instanceof BigDecimal) {
            json.add((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            json.add((BigInteger)value);
        } else if (value instanceof String) {
            json.add((String)value);
        } else if (value instanceof Long) {
            json.add(((Long)value).longValue());
        } else if (value instanceof Integer) {
            json.add(((Integer)value).intValue());
        } else if (value instanceof Float) {
            json.add((double)((Float)value).floatValue());
        } else if (value instanceof Double) {
            json.add(((Double)value).doubleValue());
        } else if (value instanceof Boolean) {
            json.add(((Boolean)value).booleanValue());
        }
    }

    private void addProperty(JsonObjectBuilder json, String key, Object value) {
        String string = key = this.replaceDotsByUnderscores ? key.replace('.', '_') : key;
        if (value instanceof BigDecimal) {
            json.add(key, (BigDecimal)value);
        } else if (value instanceof BigInteger) {
            json.add(key, (BigInteger)value);
        } else if (value instanceof String) {
            json.add(key, (String)value);
        } else if (value instanceof Long) {
            json.add(key, ((Long)value).longValue());
        } else if (value instanceof Integer) {
            json.add(key, ((Integer)value).intValue());
        } else if (value instanceof Float) {
            json.add(key, (double)((Float)value).floatValue());
        } else if (value instanceof Double) {
            if (Double.isInfinite((Double)value)) {
                json.add(key, "Infinity");
            } else if (Double.isNaN((Double)value)) {
                json.add(key, "NaN");
            } else {
                json.add(key, ((Double)value).doubleValue());
            }
        } else if (value instanceof Boolean) {
            json.add(key, ((Boolean)value).booleanValue());
        }
    }
}

