/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class IndexOperationDTO
implements OpenSearchPluginDTO {
    private final String index;
    private final Set<String> aliasesOfIndex;
    private final String id;
    private final Operation operation;
    private final long version;
    private final Instant timestampInUtc;
    private final Map<String, Object> source;

    public IndexOperationDTO(String index, Set<String> aliasesOfIndex, String id, Operation operation, long version, Map<String, Object> source) {
        this.index = index;
        this.aliasesOfIndex = aliasesOfIndex;
        this.id = id;
        this.operation = operation;
        this.version = version;
        this.timestampInUtc = TimestampUtil.nowInUtc();
        this.source = source;
    }

    public IndexOperationDTO(String index, Set<String> aliasesOfIndex, String id, Operation operation, long version, Map<String, Object> source, Instant timestampInUtc) {
        this.index = index;
        this.aliasesOfIndex = aliasesOfIndex;
        this.id = id;
        this.operation = operation;
        this.version = version;
        this.timestampInUtc = timestampInUtc;
        this.source = source;
    }

    public IndexOperationDTO(Map<String, Object> indexOperationMap) {
        this.index = MapUtil.getValueAsString(indexOperationMap, (String)"index", null);
        this.aliasesOfIndex = MapUtil.getValueAsSet(indexOperationMap, (String)"aliasesOfIndex", null);
        this.id = MapUtil.getValueAsString(indexOperationMap, (String)"id", null);
        this.operation = Operation.valueOf(MapUtil.getValueAsString(indexOperationMap, (String)"operation", (String)Operation.INDEX.name()));
        this.version = MapUtil.getValueAsLong(indexOperationMap, (String)"version", (long)-1L);
        this.timestampInUtc = MapUtil.getValueAsInstant(indexOperationMap, (String)"timestamp", (Instant)TimestampUtil.nowInUtc());
        this.source = MapUtil.getValueAsMap(indexOperationMap, (String)"source", null);
    }

    public IndexOperationDTO(StreamInput in) throws IOException {
        this.index = in.readString();
        this.aliasesOfIndex = in.readBoolean() ? new HashSet<String>(in.readStringList()) : null;
        this.id = in.readOptionalString();
        this.operation = (Operation)in.readEnum(Operation.class);
        this.version = in.readOptionalVLong();
        this.timestampInUtc = in.readOptionalInstant();
        this.source = in.readBoolean() ? in.readMap() : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        boolean hasAliasesOfIndex = this.aliasesOfIndex != null && !this.aliasesOfIndex.isEmpty();
        out.writeBoolean(hasAliasesOfIndex);
        if (hasAliasesOfIndex) {
            out.writeStringCollection(this.aliasesOfIndex);
        }
        out.writeOptionalString(this.id);
        out.writeEnum((Enum)this.operation);
        out.writeOptionalVLong(Long.valueOf(this.version));
        out.writeOptionalInstant(this.timestampInUtc);
        boolean hasSource = this.source != null;
        out.writeBoolean(hasSource);
        if (hasSource) {
            out.writeMap(this.source);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("index", this.index);
        builder.field("aliasesOfIndex", this.aliasesOfIndex);
        builder.field("id", this.id);
        builder.field("operation", this.operation.name());
        builder.field("version", this.version);
        builder.field("timestamp", TimestampUtil.formatAsIsoInstantString((Instant)this.timestampInUtc));
        builder.field("source", this.source);
        builder.endObject();
        return builder;
    }

    public static IndexOperationDTO fromXContent(XContentParser parser) throws IOException {
        return new IndexOperationDTO(parser.map());
    }

    public String getIndex() {
        return this.index;
    }

    public Set<String> getAliasesOfIndex() {
        return this.aliasesOfIndex;
    }

    public Set<String> getIndexAndAliasNames() {
        HashSet<String> result = new HashSet<String>();
        if (this.aliasesOfIndex != null) {
            result.addAll(this.aliasesOfIndex);
        }
        if (this.index != null) {
            result.add(this.index);
        }
        return result;
    }

    public String getDocumentId() {
        return this.id;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Instant getTimestampInUtc() {
        return this.timestampInUtc;
    }

    public LocalDateTime getTimestampInLocalDateTime() {
        return TimestampUtil.asLocalDateTime((Instant)this.timestampInUtc);
    }

    public long getVersion() {
        return this.version;
    }

    public Map<String, Object> getSource() {
        return this.source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexOperationDTO that = (IndexOperationDTO)o;
        return this.version == that.version && Objects.equals(this.index, that.index) && Objects.equals(this.aliasesOfIndex, that.aliasesOfIndex) && Objects.equals(this.id, that.id) && this.operation == that.operation && Objects.equals(this.timestampInUtc, that.timestampInUtc) && Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.index, this.aliasesOfIndex, this.id, this.operation, this.version, this.timestampInUtc, this.source});
    }

    public String toString() {
        return "IndexOperationDTO{index='" + this.index + "', aliasesOfIndex=" + this.aliasesOfIndex + ", id='" + this.id + "', operation=" + this.operation + ", version=" + this.version + ", timestampInUtc=" + this.timestampInUtc + ", source=...}";
    }

    public static enum Operation {
        INDEX,
        CREATE,
        DELETE;

    }
}

