/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.opensearch.action.admin.indices.datastream.DataStreamsStatsAction;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.common.Strings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestDataStreamsStatsAction
extends BaseRestHandler {
    @Override
    public String getName() {
        return "data_stream_stats_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_data_stream/_stats"), new RestHandler.Route(RestRequest.Method.GET, "/_data_stream/{name}/_stats"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        IndicesOptions defaultIndicesOption;
        DataStreamsStatsAction.Request dataStreamsStatsRequest = new DataStreamsStatsAction.Request();
        boolean forbidClosedIndices = request.paramAsBoolean("forbid_closed_indices", true);
        IndicesOptions indicesOptions = defaultIndicesOption = forbidClosedIndices ? dataStreamsStatsRequest.indicesOptions() : IndicesOptions.strictExpandOpen();
        assert (dataStreamsStatsRequest.indicesOptions() == IndicesOptions.strictExpandOpenAndForbidClosed()) : "DataStreamStats default indices options changed";
        dataStreamsStatsRequest.indicesOptions(IndicesOptions.fromRequest(request, defaultIndicesOption));
        dataStreamsStatsRequest.indices(Strings.splitStringByCommaToArray((String)request.param("name")));
        return channel -> client.execute(DataStreamsStatsAction.INSTANCE, dataStreamsStatsRequest, new RestToXContentListener((RestChannel)channel));
    }
}

