/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ChangesFilterRemoveActionDTO
implements OpenSearchPluginDTO {
    private final String serverUUID;
    private final String index;

    public ChangesFilterRemoveActionDTO(String serverUUID, String index) {
        Objects.requireNonNull(serverUUID, "serverUUID cannot be null");
        Objects.requireNonNull(index, "index cannot be null");
        this.serverUUID = serverUUID;
        this.index = index;
    }

    public ChangesFilterRemoveActionDTO(Map<String, Object> actionMap) {
        this(MapUtil.getValueAsString(actionMap, (String)"serverUUID", null), MapUtil.getValueAsString(actionMap, (String)"index", null));
    }

    public ChangesFilterRemoveActionDTO(StreamInput in) throws IOException {
        this.serverUUID = in.readString();
        this.index = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.serverUUID);
        out.writeString(this.index);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("serverUUID", this.serverUUID);
        builder.field("index", this.index);
        builder.endObject();
        return builder;
    }

    public ChangesFilterRemoveActionDTO fromXContent(XContentParser parser) throws IOException {
        return new ChangesFilterRemoveActionDTO(parser.map());
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public String getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangesFilterRemoveActionDTO that = (ChangesFilterRemoveActionDTO)o;
        return Objects.equals(this.serverUUID, that.serverUUID) && Objects.equals(this.index, that.index);
    }

    public int hashCode() {
        return Objects.hash(this.serverUUID, this.index);
    }

    public String toString() {
        return "ChangesFilterRemoveActionDTO{serverUUID='" + this.serverUUID + "', index='" + this.index + "'}";
    }
}

